/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.net.URL;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.data.test.MockData;
import org.geotools.data.DataUtilities;
import org.w3c.dom.Document;

public class CoverageTest
extends CatalogRESTTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        dataDirectory.addWellKnownCoverageTypes();
    }

    public void testGetAllByWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coverages.xml");
        CoverageTest.assertEquals((int)this.catalog.getCoveragesByNamespace(this.catalog.getNamespaceByPrefix("wcs")).size(), (int)dom.getElementsByTagName("coverage").getLength());
    }

    void addCoverageStore(boolean autoConfigureCoverage) throws Exception {
        URL zip = ((Object)((Object)this)).getClass().getResource("test-data/usa.zip");
        byte[] bytes = FileUtils.readFileToByteArray((File)DataUtilities.urlToFile((URL)zip));
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/file.worldimage" + (!autoConfigureCoverage ? "?configure=none" : ""), bytes, "application/zip");
        CoverageTest.assertEquals((int)201, (int)response.getStatusCode());
    }

    public void testGetAllByCoverageStore() throws Exception {
        this.addCoverageStore(true);
        Document dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        CoverageTest.assertEquals((int)1, (int)dom.getElementsByTagName("coverage").getLength());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//coverage/name[text()='usa'])", (Document)dom);
    }

    public void testPutAllUnauthorized() throws Exception {
        CoverageTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        CoverageTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"BlueMarble", (String)"/coverage/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//latLonBoundingBox)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//nativeFormat)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//grid)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//supportedFormats)", (Document)dom);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.json");
        JSONObject coverage = ((JSONObject)json).getJSONObject("coverage");
        CoverageTest.assertNotNull((Object)coverage);
        CoverageTest.assertEquals((Object)"BlueMarble", (Object)coverage.get("name"));
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.html");
        CoverageTest.assertEquals((String)"html", (String)dom.getDocumentElement().getNodeName());
    }

    public void testPostAsXML() throws Exception {
        String req = "wcs?service=wcs&request=getcoverage&version=1.1.1&identifier=gs:usa&boundingbox=-100,30,-80,44,EPSG:4326&format=image/tiff&gridbasecrs=EPSG:4326&store=true";
        Document dom = this.getAsDOM(req);
        CoverageTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        this.addCoverageStore(false);
        dom = this.getAsDOM("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages.xml");
        CoverageTest.assertEquals((int)0, (int)dom.getElementsByTagName("coverage").getLength());
        String xml = "<coverage><name>usa</name><title>usa is a A raster file accompanied by a spatial data file</title><description>Generated from WorldImage</description><srs>EPSG:4326</srs><latLonBoundingBox><minx>-130.85168</minx><maxx>-62.0054</maxx><miny>20.7052</miny><maxy>54.1141</maxy></latLonBoundingBox><nativeBoundingBox><minx>-130.85168</minx><maxx>-62.0054</maxx><miny>20.7052</miny><maxy>54.1141</maxy><crs>EPSG:4326</crs></nativeBoundingBox><grid dimension=\"2\"><range><low>0 0</low><high>983 598</high></range><transform><scaleX>0.07003690742624616</scaleX><scaleY>-0.05586772575250837</scaleY><shearX>0.0</shearX><shearX>0.0</shearX><translateX>-130.81666154628687</translateX><translateY>54.08616613712375</translateY></transform><crs>EPSG:4326</crs></grid><supportedFormats><string>PNG</string><string>TIFF</string></supportedFormats><requestSRS><string>EPSG:4326</string></requestSRS><responseSRS><string>EPSG:4326</string></responseSRS><store>usaWorldImage</store><namespace>gs</namespace></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs/coveragestores/usaWorldImage/coverages/", xml, "text/xml");
        CoverageTest.assertEquals((int)201, (int)response.getStatusCode());
        CoverageTest.assertNotNull((Object)response.getHeader("Location"));
        CoverageTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/gs/coveragestores/usaWorldImage/coverages/usa"));
        dom = this.getAsDOM(req);
        CoverageTest.assertEquals((String)"wcs:Coverages", (String)dom.getDocumentElement().getNodeName());
    }

    public void testPostToResource() throws Exception {
        String xml = "<coverage><name>foo</name></coverage>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", xml, "text/xml");
        CoverageTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testPut() throws Exception {
        String xml = "<coverage><title>new title</title></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble", xml, "text/xml");
        CoverageTest.assertEquals((int)200, (int)response.getStatusCode());
        Document dom = this.getAsDOM("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"new title", (String)"/coverage/title", (Document)dom);
        CoverageInfo c = this.catalog.getCoverageByName("wcs", "BlueMarble");
        CoverageTest.assertEquals((String)"new title", (String)c.getTitle());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<coverage><title>new title</title></coverage>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/NonExistant", xml, "text/xml");
        CoverageTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDelete() throws Exception {
        CoverageTest.assertNotNull((Object)this.catalog.getCoverageByName("wcs", "BlueMarble"));
        for (LayerInfo l : this.catalog.getLayers((ResourceInfo)this.catalog.getCoverageByName("wcs", "BlueMarble"))) {
            this.catalog.remove(l);
        }
        CoverageTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble").getStatusCode());
        CoverageTest.assertNull((Object)this.catalog.getCoverageByName("wcs", "BlueMarble"));
    }

    public void testDeleteNonExistant() throws Exception {
        CoverageTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/NonExistant").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        CoverageTest.assertNotNull((Object)this.catalog.getCoverageByName("wcs", "BlueMarble"));
        CoverageTest.assertNotNull((Object)this.catalog.getLayerByName("wcs:BlueMarble"));
        CoverageTest.assertEquals((int)403, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble").getStatusCode());
        CoverageTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/wcs/coveragestores/BlueMarble/coverages/BlueMarble?recurse=true").getStatusCode());
        CoverageTest.assertNull((Object)this.catalog.getCoverageByName("wcs", "BlueMarble"));
        CoverageTest.assertNull((Object)this.catalog.getLayerByName("wcs:BlueMarble"));
    }
}

