/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.CatalogResourceBase;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.format.ReflectiveJSONFormat;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;

public abstract class AbstractCatalogListResource
extends CatalogResourceBase {
    protected AbstractCatalogListResource(Context context, Request request, Response response, Class clazz, Catalog catalog) {
        super(context, request, response, clazz, catalog);
    }

    protected final Object handleObjectGet() throws Exception {
        return XStreamPersister.unwrapProxies((Object)this.handleListGet());
    }

    protected abstract Collection handleListGet() throws Exception;

    protected ReflectiveJSONFormat createJSONFormat(Request request, Response response) {
        final ReflectiveJSONFormat f = super.createJSONFormat(request, response);
        return new ReflectiveJSONFormat(){

            public XStream getXStream() {
                return f.getXStream();
            }

            protected void write(Object data, OutputStream output) throws IOException {
                AbstractCatalogListResource.this.aliasCollection(data, f.getXStream());
                f.getXStream().toXML(data, output);
            }
        };
    }

    protected ReflectiveXMLFormat createXMLFormat(Request request, Response response) {
        final ReflectiveXMLFormat f = super.createXMLFormat(request, response);
        return new ReflectiveXMLFormat(){

            public XStream getXStream() {
                return f.getXStream();
            }

            protected void write(Object data, OutputStream output) throws IOException {
                AbstractCatalogListResource.this.aliasCollection(data, f.getXStream());
                f.getXStream().toXML(data, output);
            }
        };
    }

    protected void configureXStream(XStream xstream) {
        XStreamPersister xp = this.xpf.createXMLPersister();
        final String name = xp.getClassAliasingMapper().serializedClass(this.clazz);
        xstream.alias(name, this.clazz);
        xstream.registerConverter((Converter)new CollectionConverter(xstream.getMapper()){

            public boolean canConvert(Class type) {
                return Collection.class.isAssignableFrom(type);
            }

            protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
                writer.startNode(name);
                context.convertAnother(item);
                writer.endNode();
            }
        });
        xstream.registerConverter(new Converter(){

            public boolean canConvert(Class type) {
                return AbstractCatalogListResource.this.clazz.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                String ref = null;
                if (OwsUtils.getter((Class)AbstractCatalogListResource.this.clazz, (String)"name", String.class) != null) {
                    ref = (String)OwsUtils.get((Object)source, (String)"name");
                } else if (OwsUtils.getter((Class)AbstractCatalogListResource.this.clazz, (String)"id", String.class) != null) {
                    ref = (String)OwsUtils.get((Object)source, (String)"id");
                } else {
                    throw new RuntimeException("Could not determine identifier for: " + AbstractCatalogListResource.this.clazz.getName());
                }
                writer.startNode("name");
                writer.setValue(ref);
                writer.endNode();
                AbstractCatalogListResource.this.encodeLink(AbstractCatalogListResource.this.encode(ref), writer);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                return null;
            }
        });
    }

    protected void aliasCollection(Object data, XStream xstream) {
        XStreamPersister xp = this.xpf.createXMLPersister();
        String alias = xp.getClassAliasingMapper().serializedClass(this.clazz);
        xstream.alias(alias + "s", Collection.class, data.getClass());
    }
}

