/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CollectionModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.ReflectiveHTMLFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class CoverageStoreResource
extends AbstractCatalogResource {
    public CoverageStoreResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, CoverageStoreInfo.class, catalog);
    }

    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new CoverageStoreHTMLFormat(request, response, (Resource)this, this.catalog);
    }

    protected Object handleObjectGet() throws Exception {
        String ws = this.getAttribute("workspace");
        String cs = this.getAttribute("coveragestore");
        LOGGER.fine("GET coverage store " + ws + "," + cs);
        if (cs == null) {
            return this.catalog.getCoverageStoresByWorkspace(ws);
        }
        return this.catalog.getCoverageStoreByName(ws, cs);
    }

    public boolean allowPost() {
        return this.getAttribute("coveragestore") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        CoverageStoreInfo coverageStore = (CoverageStoreInfo)object;
        this.catalog.add((StoreInfo)coverageStore);
        LOGGER.info("POST coverage store " + coverageStore.getName());
        return coverageStore.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("coveragestore") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        CoverageStoreInfo cs = (CoverageStoreInfo)object;
        CoverageStoreInfo original = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        new CatalogBuilder(this.catalog).updateCoverageStore(original, cs);
        this.catalog.save((StoreInfo)original);
        this.clear(original);
        LOGGER.info("PUT coverage store " + workspace + "," + coveragestore);
    }

    public boolean allowDelete() {
        return this.getAttribute("coveragestore") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String workspace = this.getAttribute("workspace");
        String coveragestore = this.getAttribute("coveragestore");
        boolean recurse = (Boolean)this.getQueryStringValue("recurse", Boolean.class, false);
        CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(workspace, coveragestore);
        if (!recurse) {
            if (!this.catalog.getCoveragesByCoverageStore(cs).isEmpty()) {
                throw new RestletException("coveragestore not empty", Status.CLIENT_ERROR_UNAUTHORIZED);
            }
            this.catalog.remove((StoreInfo)cs);
        } else {
            new CascadeDeleteVisitor(this.catalog).visit(cs);
        }
        this.clear(cs);
        LOGGER.info("DELETE coverage store " + workspace + "," + coveragestore);
    }

    protected void configurePersister(XStreamPersister persister, final DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeCoverageStore(CoverageStoreInfo cs, HierarchicalStreamWriter writer, MarshallingContext context) {
                writer.startNode("coverages");
                CoverageStoreResource.this.encodeCollectionLink("coverages", writer, format);
                writer.endNode();
            }

            protected void postEncodeReference(Object obj, String ref, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof WorkspaceInfo) {
                    CoverageStoreResource.this.encodeLink("/workspaces/" + CoverageStoreResource.this.encode(ref), writer, format);
                }
            }
        });
    }

    void clear(CoverageStoreInfo info) {
        this.catalog.getResourcePool().clear(info);
    }

    static class CoverageStoreHTMLFormat
    extends CatalogFreemarkerHTMLFormat {
        Catalog catalog;

        public CoverageStoreHTMLFormat(Request request, Response response, Resource resource, Catalog catalog) {
            super(CoverageStoreInfo.class, request, response, resource);
            this.catalog = catalog;
        }

        protected Configuration createConfiguration(Object data, Class clazz) {
            Configuration cfg = super.createConfiguration(data, clazz);
            cfg.setObjectWrapper((ObjectWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper<CoverageStoreInfo>(CoverageStoreInfo.class){

                protected void wrapInternal(Map properties, SimpleHash model, CoverageStoreInfo object) {
                    List coverages = CoverageStoreHTMLFormat.this.catalog.getCoveragesByCoverageStore(object);
                    properties.put("coverages", new CollectionModel((Collection)coverages, (BeansWrapper)new ReflectiveHTMLFormat.ObjectToMapWrapper((ReflectiveHTMLFormat)CoverageStoreHTMLFormat.this, CoverageInfo.class)));
                }
            });
            return cfg;
        }
    }
}

