/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.data.test.MockData;
import org.h2.tools.DeleteDbFiles;
import org.w3c.dom.Document;

public class DataStoreFileUploadTest
extends CatalogRESTTestSupport {
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        DeleteDbFiles.execute((String)".", (String)"foo", (boolean)true);
        DeleteDbFiles.execute((String)".", (String)"pds", (boolean)true);
        DeleteDbFiles.execute((String)".", (String)"chinese_poly", (boolean)true);
    }

    public void testPropertyFileUpload() throws Exception {
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", bytes, "text/plain");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    public void testPropertyFileUploadWithWorkspace() throws Exception {
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/sf/datastores/pds/file.properties", bytes, "text/plain");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=sf:pds");
        this.assertFeatures(dom, "sf");
    }

    public void testPropertyFileUploadZipped() throws Exception {
        byte[] bytes = this.propertyFile();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.putNextEntry(new ZipEntry("pds.properties"));
        zout.write(bytes);
        zout.flush();
        zout.close();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", out.toByteArray(), "application/zip");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    byte[] propertyFile() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("ds.0='zero'|POINT(0 0)\n");
        writer.write("ds.1='one'|POINT(1 1)\n");
        writer.flush();
        return output.toByteArray();
    }

    void assertFeatures(Document dom) throws Exception {
        this.assertFeatures(dom, "gs");
    }

    void assertFeatures(Document dom, String ns) throws Exception {
        DataStoreFileUploadTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        DataStoreFileUploadTest.assertEquals((int)2, (int)dom.getElementsByTagName(String.valueOf(ns) + ":pds").getLength());
    }

    public void testShapeFileUpload() throws Exception {
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/pds/file.shp", bytes, "application/zip");
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    public void testShapeFileUploadWithCharset() throws Exception {
        byte[] bytes = this.shpChineseZipAsBytes();
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs/datastores/chinese_poly/file.shp?charset=UTF-8", bytes, "application/zip");
        DataStoreFileUploadTest.assertEquals((int)201, (int)response.getStatusCode());
        MockHttpServletResponse response2 = this.getAsServletResponse("wfs?request=getfeature&typename=gs:chinese_poly", "GB18030");
        DataStoreFileUploadTest.assertTrue((boolean)response2.getOutputStreamContent().contains("\u951f\u65a4\u62f7"));
    }

    byte[] shpZipAsBytes() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int c = -1;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    byte[] shpChineseZipAsBytes() throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/chinese_poly.zip");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int c = -1;
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        return out.toByteArray();
    }

    public void testShapeFileUploadExternal() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        DataStoreFileUploadTest.assertEquals((String)"ows:ExceptionReport", (String)dom.getDocumentElement().getNodeName());
        File target = new File("target");
        File f = File.createTempFile("rest", "dir", target);
        f.delete();
        f.mkdir();
        File zip = new File(f, "pds.zip");
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test-data/pds.zip"), (OutputStream)new FileOutputStream(zip));
        org.geoserver.rest.util.IOUtils.inflate((ZipFile)new ZipFile(zip), (File)f, null);
        MockHttpServletResponse resp = this.putAsServletResponse("/rest/workspaces/gs/datastores/pds/external.shp", new File(f, "pds.shp").toURL().toString(), "text/plain");
        DataStoreFileUploadTest.assertEquals((int)201, (int)resp.getStatusCode());
        dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    public void testShapeFileUploadIntoExisting() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreFileUploadTest.assertNull((Object)cat.getDataStoreByName("gs", "foo_h2"));
        String xml = "<dataStore> <name>foo_h2</name> <type>H2</type> <connectionParameters><namespace>" + MockData.DEFAULT_URI + "</namespace>" + "<database>foo</database>" + "<dbtype>h2</dbtype>" + " </connectionParameters>" + "</dataStore>";
        this.post("/rest/workspaces/gs/datastores", xml);
        DataStoreInfo ds = cat.getDataStoreByName("gs", "foo_h2");
        DataStoreFileUploadTest.assertNotNull((Object)ds);
        DataStoreFileUploadTest.assertTrue((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/foo_h2/file.shp", bytes, "application/zip");
        DataStoreFileUploadTest.assertFalse((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    public void testShapeFileUploadWithTarget() throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreFileUploadTest.assertNull((Object)cat.getDataStoreByName("gs", "pds"));
        byte[] bytes = this.shpZipAsBytes();
        this.put("/rest/workspaces/gs/datastores/pds/file.shp?target=h2", bytes, "application/zip");
        DataStoreInfo ds = cat.getDataStoreByName("gs", "pds");
        DataStoreFileUploadTest.assertNotNull((Object)ds);
        DataStoreFileUploadTest.assertFalse((boolean)cat.getFeatureTypesByDataStore(ds).isEmpty());
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:pds");
        this.assertFeatures(dom);
    }

    public void testGet() throws Exception {
        MockHttpServletResponse resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        DataStoreFileUploadTest.assertEquals((int)404, (int)resp.getStatusCode());
        byte[] bytes = this.propertyFile();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties", bytes, "text/plain");
        resp = this.getAsServletResponse("/rest/workspaces/gs/datastores/pds/file.properties");
        DataStoreFileUploadTest.assertEquals((int)200, (int)resp.getStatusCode());
        DataStoreFileUploadTest.assertEquals((String)"application/zip", (String)resp.getContentType());
        ByteArrayInputStream bin = this.getBinaryInputStream(resp);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        DataStoreFileUploadTest.assertNotNull((Object)entry);
        DataStoreFileUploadTest.assertEquals((String)"pds.properties", (String)entry.getName());
    }
}

