/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMSStoreTest
extends CatalogRESTTestSupport {
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        CatalogBuilder cb = new CatalogBuilder(this.catalog);
        cb.setWorkspace(this.catalog.getWorkspaceByName("sf"));
        WMSStoreInfo wms = cb.buildWMSStore("demo");
        wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?");
        this.catalog.add((StoreInfo)wms);
    }

    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores.xml");
        WMSStoreTest.assertEquals((String)"wmsStores", (String)dom.getDocumentElement().getNodeName());
        WMSStoreTest.assertEquals((int)this.catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size(), (int)dom.getElementsByTagName("wmsStore").getLength());
    }

    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmsstores.json");
        WMSStoreTest.assertTrue((boolean)(json instanceof JSONObject));
        Object stores = ((JSONObject)json).getJSONObject("wmsStores").get("wmsStore");
        WMSStoreTest.assertNotNull((Object)stores);
        if (stores instanceof JSONArray) {
            WMSStoreTest.assertEquals((int)this.catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size(), (int)((JSONArray)stores).size());
        } else {
            WMSStoreTest.assertEquals((int)1, (int)this.catalog.getStoresByWorkspace("sf", WMSStoreInfo.class).size());
        }
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores.html");
        List stores = this.catalog.getStoresByWorkspace("sf", WMSStoreInfo.class);
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        WMSStoreTest.assertEquals((int)stores.size(), (int)links.getLength());
        int i = 0;
        while (i < stores.size()) {
            WMSStoreInfo store = (WMSStoreInfo)stores.get(i);
            Element link = (Element)links.item(i);
            WMSStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(store.getName()) + ".html"));
            ++i;
        }
    }

    public void testPutAllUnauthorized() throws Exception {
        WMSStoreTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces/sf/wmsstores").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        WMSStoreTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.xml");
        WMSStoreTest.assertEquals((String)"wmsStore", (String)dom.getDocumentElement().getNodeName());
        WMSStoreTest.assertEquals((String)"demo", (String)this.xp.evaluate("/wmsStore/name", dom));
        WMSStoreTest.assertEquals((String)"sf", (String)this.xp.evaluate("/wmsStore/workspace/name", dom));
        XMLAssert.assertXpathExists((String)"/wmsStore/capabilitiesURL", (Document)dom);
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/wmsstores/demo.html");
        WMSStoreInfo wms = (WMSStoreInfo)this.catalog.getStoreByName("demo", WMSStoreInfo.class);
        List wmsLayers = this.catalog.getResourcesByStore((StoreInfo)wms, WMSLayerInfo.class);
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        WMSStoreTest.assertEquals((int)wmsLayers.size(), (int)links.getLength());
        int i = 0;
        while (i < wmsLayers.size()) {
            WMSLayerInfo wl = (WMSLayerInfo)wmsLayers.get(i);
            Element link = (Element)links.item(i);
            WMSStoreTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(wl.getName()) + ".html"));
            ++i;
        }
    }

    public void testPostAsXML() throws Exception {
        String xml = "<wmsStore><name>newWMSStore</name><capabilitiesURL>http://somehost/wms?</capabilitiesURL><workspace>sf</workspace></wmsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores", xml, "text/xml");
        WMSStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        WMSStoreTest.assertNotNull((Object)response.getHeader("Location"));
        WMSStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmsstores/newWMSStore"));
        WMSStoreInfo newStore = (WMSStoreInfo)this.catalog.getStoreByName("newWMSStore", WMSStoreInfo.class);
        WMSStoreTest.assertNotNull((Object)newStore);
        WMSStoreTest.assertEquals((String)"http://somehost/wms?", (String)newStore.getCapabilitiesURL());
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf/wmsstores/demo.json");
        JSONObject store = ((JSONObject)json).getJSONObject("wmsStore");
        WMSStoreTest.assertNotNull((Object)store);
        WMSStoreTest.assertEquals((Object)"demo", (Object)store.get("name"));
        WMSStoreTest.assertEquals((Object)"sf", (Object)store.getJSONObject("workspace").get("name"));
        WMSStoreTest.assertEquals((String)"http://demo.opengeo.org/geoserver/wms?", (String)store.getString("capabilitiesURL"));
    }

    public void testPostAsJSON() throws Exception {
        String json = "{'wmsStore':{'capabilitiesURL': 'http://somehost/wms?','workspace':'sf','name':'newWMSStore',}}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores", json, "text/json");
        WMSStoreTest.assertEquals((int)201, (int)response.getStatusCode());
        WMSStoreTest.assertNotNull((Object)response.getHeader("Location"));
        WMSStoreTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/sf/wmsstores/newWMSStore"));
        WMSStoreInfo newStore = (WMSStoreInfo)this.catalog.getStoreByName("newWMSStore", WMSStoreInfo.class);
        WMSStoreTest.assertNotNull((Object)newStore);
        WMSStoreTest.assertEquals((String)"http://somehost/wms?", (String)newStore.getCapabilitiesURL());
    }

    public void testPostToResource() throws Exception {
        String xml = "<wmsStore><name>demo</name><enabled>false</enabled></wmsStore>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml");
        WMSStoreTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testPut() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"true", (String)"/dataStore/enabled", (Document)dom);
        String xml = "<dataStore><name>sf</name><enabled>false</enabled></dataStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/datastores/sf", xml, "text/xml");
        WMSStoreTest.assertEquals((int)200, (int)response.getStatusCode());
        dom = this.getAsDOM("/rest/workspaces/sf/datastores/sf.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"false", (String)"/dataStore/enabled", (Document)dom);
        WMSStoreTest.assertFalse((boolean)this.catalog.getDataStoreByName("sf", "sf").isEnabled());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<wmsStore><name>changed</name></wmsStore>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/sf/wmsstores/nonExistant", xml, "text/xml");
        WMSStoreTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testDeleteNonExistant() throws Exception {
        WMSStoreTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/sf/datastores/nonExistant").getStatusCode());
    }

    public void testDelete() throws Exception {
        this.testPostAsXML();
        WMSStoreTest.assertNotNull((Object)this.catalog.getStoreByName("sf", "newWMSStore", WMSStoreInfo.class));
        WMSStoreTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/sf/wmsstores/newWMSStore").getStatusCode());
        WMSStoreTest.assertNull((Object)this.catalog.getStoreByName("sf", "newWMSStore", WMSStoreInfo.class));
    }

    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<wmsStore><name>newName</name></wmsStore>";
        WMSStoreTest.assertEquals((int)403, (int)this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml").getStatusCode());
    }

    public void testPutWorkspaceChangeForbidden() throws Exception {
        String xml = "<wmsStore><workspace>gs</workspace></wmsStore>";
        WMSStoreTest.assertEquals((int)403, (int)this.putAsServletResponse("/rest/workspaces/sf/wmsstores/demo", xml, "text/xml").getStatusCode());
    }
}

