/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.rest.AbstractCatalogResource;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.DataFormat;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class LayerGroupResource
extends AbstractCatalogResource {
    public LayerGroupResource(Context context, Request request, Response response, Catalog catalog) {
        super(context, request, response, LayerGroupInfo.class, catalog);
    }

    protected Object handleObjectGet() throws Exception {
        String lg = this.getAttribute("layergroup");
        LOGGER.fine("GET layer group " + lg);
        return this.catalog.getLayerGroupByName(lg);
    }

    public boolean allowPost() {
        return this.getAttribute("layergroup") == null;
    }

    protected String handleObjectPost(Object object) throws Exception {
        LayerGroupInfo lg = (LayerGroupInfo)object;
        LOGGER.info("POST layer group " + lg.getName());
        if (lg.getLayers().isEmpty()) {
            throw new RestletException("layer group must not be empty", Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (lg.getBounds() == null) {
            LOGGER.fine("Auto calculating layer group bounds");
            new CatalogBuilder(this.catalog).calculateLayerGroupBounds(lg);
        }
        this.catalog.add(lg);
        return lg.getName();
    }

    public boolean allowPut() {
        return this.getAttribute("layergroup") != null;
    }

    protected void handleObjectPut(Object object) throws Exception {
        String layergroup = this.getAttribute("layergroup");
        LOGGER.info("PUT layer group " + layergroup);
        LayerGroupInfo lg = (LayerGroupInfo)object;
        LayerGroupInfo original = this.catalog.getLayerGroupByName(layergroup);
        if (lg.getName() != null && !lg.getName().equals(original.getName())) {
            throw new RestletException("Can't change name of a layer group", Status.CLIENT_ERROR_FORBIDDEN);
        }
        new CatalogBuilder(this.catalog).updateLayerGroup(original, lg);
        this.catalog.save(original);
    }

    public boolean allowDelete() {
        return this.getAttribute("layergroup") != null;
    }

    protected void handleObjectDelete() throws Exception {
        String layergroup = this.getAttribute("layergroup");
        LOGGER.info("DELETE layer group " + layergroup);
        LayerGroupInfo lg = this.catalog.getLayerGroupByName(layergroup);
        this.catalog.remove(lg);
    }

    protected void configurePersister(XStreamPersister persister, DataFormat format) {
        persister.setCallback(new XStreamPersister.Callback(){

            protected void postEncodeReference(Object obj, String ref, HierarchicalStreamWriter writer, MarshallingContext context) {
                if (obj instanceof StyleInfo) {
                    LayerGroupResource.this.encodeLink("/styles/" + LayerGroupResource.this.encode(ref), writer);
                }
                if (obj instanceof LayerInfo) {
                    LayerGroupResource.this.encodeLink("/layers/" + LayerGroupResource.this.encode(ref), writer);
                }
            }
        });
    }
}

