/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.AbstractCatalogFinder;
import org.geoserver.catalog.rest.StyleListResource;
import org.geoserver.catalog.rest.StyleResource;
import org.geoserver.rest.RestletException;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class StyleFinder
extends AbstractCatalogFinder {
    public StyleFinder(Catalog catalog) {
        super(catalog);
    }

    public Resource findTarget(Request request, Response response) {
        String style = this.getAttribute(request, "style");
        String layer = this.getAttribute(request, "layer");
        if (style != null && this.catalog.getStyleByName(style) == null) {
            throw new RestletException("No such style: " + style, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (layer != null && this.catalog.getLayerByName(layer) == null) {
            throw new RestletException("No such layer: " + layer, Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (style == null && request.getMethod() == Method.GET) {
            return new StyleListResource(this.getContext(), request, response, this.catalog);
        }
        return new StyleResource(this.getContext(), request, response, this.catalog);
    }
}

