/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.data.test.MockData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NamespaceTest
extends CatalogRESTTestSupport {
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces.xml");
        NamespaceTest.assertEquals((int)this.catalog.getNamespaces().size(), (int)dom.getElementsByTagName("namespace").getLength());
    }

    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/namespaces.json");
        NamespaceTest.assertTrue((boolean)(json instanceof JSONObject));
        JSONArray namespaces = ((JSONObject)json).getJSONObject("namespaces").getJSONArray("namespace");
        NamespaceTest.assertNotNull((Object)namespaces);
        NamespaceTest.assertEquals((int)this.catalog.getNamespaces().size(), (int)namespaces.size());
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces.html");
        List namespaces = this.catalog.getNamespaces();
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        NamespaceTest.assertEquals((int)namespaces.size(), (int)links.getLength());
        int i = 0;
        while (i < namespaces.size()) {
            NamespaceInfo ws = (NamespaceInfo)namespaces.get(i);
            Element link = (Element)links.item(i);
            NamespaceTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(ws.getPrefix()) + ".html"));
            ++i;
        }
    }

    public void testPutAllUnauthorized() throws Exception {
        NamespaceTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/namespaces").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        NamespaceTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/namespaces").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/sf.xml");
        NamespaceTest.assertEquals((String)"namespace", (String)dom.getDocumentElement().getLocalName());
        NamespaceTest.assertEquals((int)1, (int)dom.getElementsByTagName("prefix").getLength());
        Element prefix = (Element)dom.getElementsByTagName("prefix").item(0);
        NamespaceTest.assertEquals((String)"sf", (String)prefix.getFirstChild().getTextContent());
        Element name = (Element)dom.getElementsByTagName("uri").item(0);
        NamespaceTest.assertEquals((String)MockData.SF_URI, (String)name.getFirstChild().getTextContent());
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/sf.html");
        List resources = this.catalog.getResourcesByNamespace("sf", ResourceInfo.class);
        NodeList listItems = this.xp.getMatchingNodes("//html:li", dom);
        NamespaceTest.assertEquals((int)resources.size(), (int)listItems.getLength());
        int i = 0;
        while (i < resources.size()) {
            ResourceInfo resource = (ResourceInfo)resources.get(i);
            Element listItem = (Element)listItems.item(i);
            NamespaceTest.assertTrue((boolean)listItem.getFirstChild().getNodeValue().endsWith(resource.getName()));
            ++i;
        }
    }

    public void testGetNonExistant() throws Exception {
        NamespaceTest.assertEquals((int)404, (int)this.getAsServletResponse("/rest/namespaces/none").getStatusCode());
    }

    public void testPostAsXML() throws Exception {
        String xml = "<namespace><prefix>foo</prefix><uri>http://foo.com</uri></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces", xml, "text/xml");
        NamespaceTest.assertEquals((int)201, (int)response.getStatusCode());
        NamespaceTest.assertNotNull((Object)response.getHeader("Location"));
        NamespaceTest.assertTrue((boolean)response.getHeader("Location").endsWith("/namespaces/foo"));
        NamespaceInfo ws = this.getCatalog().getNamespaceByPrefix("foo");
        NamespaceTest.assertNotNull((Object)ws);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/namespaces/sf.json");
        JSONObject namespace = ((JSONObject)json).getJSONObject("namespace");
        NamespaceTest.assertEquals((Object)"sf", (Object)namespace.get("prefix"));
        NamespaceTest.assertEquals((Object)MockData.SF_URI, (Object)namespace.get("uri"));
    }

    public void testPostAsJSON() throws Exception {
        String json = "{'namespace':{ 'prefix':'foo', 'uri':'http://foo.com' }}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces", json, "text/json");
        NamespaceTest.assertEquals((int)201, (int)response.getStatusCode());
        NamespaceTest.assertNotNull((Object)response.getHeader("Location"));
        NamespaceTest.assertTrue((boolean)response.getHeader("Location").endsWith("/namespaces/foo"));
        NamespaceInfo ws = this.getCatalog().getNamespaceByPrefix("foo");
        NamespaceTest.assertNotNull((Object)ws);
    }

    public void testPostToResource() throws Exception {
        String xml = "<namespace><name>changed</name></namespace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/namespaces/gs", xml, "text/xml");
        NamespaceTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testDeleteNonExistant() throws Exception {
        NamespaceTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/namespaces/newExistant").getStatusCode());
    }

    public void testDelete() throws Exception {
        String xml = "<namespace><prefix>foo</prefix><uri>http://foo.com</uri></namespace>";
        this.post("/rest/namespaces", xml);
        Document dom = this.getAsDOM("/rest/namespaces/foo.xml");
        NamespaceTest.assertEquals((String)"namespace", (String)dom.getDocumentElement().getNodeName());
        NamespaceTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/namespaces/foo").getStatusCode());
        NamespaceTest.assertEquals((int)404, (int)this.getAsServletResponse("/rest/namespaces/foo.xml").getStatusCode());
    }

    public void testDeleteNonEmpty() throws Exception {
        NamespaceTest.assertEquals((int)401, (int)this.deleteAsServletResponse("/rest/namespaces/sf").getStatusCode());
    }

    public void testPut() throws Exception {
        String xml = "<namespace><uri>http://changed</uri></namespace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/namespaces/gs", xml, "text/xml");
        NamespaceTest.assertEquals((int)200, (int)response.getStatusCode());
        Document dom = this.getAsDOM("/rest/namespaces/gs.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//namespace/uri[text()='http://changed'])", (Document)dom);
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<namespace><name>changed</name></namespace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/namespaces/nonExistant", xml, "text/xml");
        NamespaceTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testGetDefaultNamespace() throws Exception {
        Document dom = this.getAsDOM("/rest/namespaces/default.xml");
        NamespaceTest.assertEquals((String)"namespace", (String)dom.getDocumentElement().getLocalName());
        NamespaceTest.assertEquals((int)1, (int)dom.getElementsByTagName("prefix").getLength());
        NamespaceTest.assertEquals((int)1, (int)dom.getElementsByTagName("uri").getLength());
    }

    public void testPutDefaultNamespace() throws Exception {
        NamespaceInfo def = this.getCatalog().getDefaultNamespace();
        NamespaceTest.assertEquals((String)"gs", (String)def.getPrefix());
        String json = "{'namespace':{ 'prefix':'sf' }}";
        this.put("/rest/namespaces/default", json, "text/json");
        def = this.getCatalog().getDefaultNamespace();
        NamespaceTest.assertEquals((String)"sf", (String)def.getPrefix());
    }
}

