/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.util.RESTUtils;
import org.geotools.util.logging.Logging;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public abstract class StoreFileResource
extends Resource {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");
    protected Catalog catalog;

    public StoreFileResource(Request request, Response response, Catalog catalog) {
        super(null, request, response);
        this.catalog = catalog;
    }

    public boolean allowPut() {
        return true;
    }

    protected String getAttribute(String attribute) {
        return RESTUtils.getAttribute((Request)this.getRequest(), (String)attribute);
    }

    protected String getUploadMethod(Request request) {
        return request.getResourceRef().getLastSegment().toLowerCase();
    }

    protected boolean isInlineUpload(String method) {
        return method != null && (method.startsWith("file.") || method.startsWith("url."));
    }

    protected File doFileUpload(String method, String workspaceName, String storeName, String format) {
        File directory = null;
        if (this.isInlineUpload(method)) {
            try {
                directory = this.catalog.getResourceLoader().findOrCreateDirectory(new String[]{"data", workspaceName, storeName});
            }
            catch (IOException e) {
                throw new RestletException(e.getMessage(), Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return this.handleFileUpload(storeName, format, directory);
    }

    protected File handleFileUpload(String store, String format, File directory) {
        File uploadedFile;
        MediaType mediaType;
        block12: {
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
            mediaType = this.getRequest().getEntity().getMediaType();
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("PUT file, mimetype: " + mediaType);
            }
            uploadedFile = null;
            try {
                String method = this.getRequest().getResourceRef().getLastSegment();
                if (method != null && method.toLowerCase().startsWith("file.")) {
                    uploadedFile = RESTUtils.handleBinUpload((String)(String.valueOf(store) + "." + format), (File)directory, (Request)this.getRequest());
                    break block12;
                }
                if (method != null && method.toLowerCase().startsWith("url.")) {
                    uploadedFile = RESTUtils.handleURLUpload((String)store, (String)format, (Request)this.getRequest());
                    break block12;
                }
                if (method != null && method.toLowerCase().startsWith("external.")) {
                    uploadedFile = RESTUtils.handleEXTERNALUpload((Request)this.getRequest());
                    break block12;
                }
                StringBuilder builder = new StringBuilder("Unrecognized file upload method: ").append(method);
                throw new RestletException(builder.toString(), Status.CLIENT_ERROR_BAD_REQUEST);
            }
            catch (Throwable t) {
                throw new RestletException("Error while storing uploaded file:", Status.SERVER_ERROR_INTERNAL, t);
            }
        }
        if (mediaType != null && RESTUtils.isZipMediaType((MediaType)mediaType)) {
            if (!uploadedFile.getName().endsWith(".zip")) {
                File newUploadedFile = new File(uploadedFile.getParentFile(), String.valueOf(FilenameUtils.getBaseName((String)uploadedFile.getAbsolutePath())) + ".zip");
                uploadedFile.renameTo(newUploadedFile);
                uploadedFile = newUploadedFile;
            }
            try {
                RESTUtils.unzipFile((File)uploadedFile, (File)directory);
                File primaryFile = this.findPrimaryFile(directory, format);
                if (primaryFile == null) {
                    throw new RestletException("Could not find appropriate " + format + " file in archive", Status.CLIENT_ERROR_BAD_REQUEST);
                }
                uploadedFile = primaryFile;
            }
            catch (RestletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestletException("Error occured unzipping file", Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return uploadedFile;
    }

    protected File findPrimaryFile(File directory, String format) {
        File[] files = directory.listFiles();
        Iterator f = FileUtils.listFiles((File)directory, (String[])new String[]{format}, (boolean)false).iterator();
        f.hasNext();
        if (f.hasNext()) {
            return (File)f.next();
        }
        return null;
    }
}

