/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.w3c.dom.Document;

public class LayerTest
extends CatalogRESTTestSupport {
    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layers/cite:Buildings.xml");
        LayerTest.assertEquals((String)"layer", (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"Buildings", (String)"/layer/*[1]", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://localhost/geoserver/rest/styles/Buildings.xml", (String)"/layer/defaultStyle/atom:link/attribute::href", (Document)dom);
    }

    public void testGetAsHTML() throws Exception {
        this.getAsDOM("/rest/layers/cite:Buildings.html");
    }

    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/layers.xml");
        XMLAssert.assertXpathEvaluatesTo((String)String.valueOf(this.catalog.getLayers().size()), (String)"count(//layer)", (Document)dom);
    }

    public void testGetAllAsHTML() throws Exception {
        this.getAsDOM("/rest/layers.html");
    }

    public void testPut() throws Exception {
        LayerInfo l = this.catalog.getLayerByName("cite:Buildings");
        LayerTest.assertEquals((String)"Buildings", (String)l.getDefaultStyle().getName());
        String xml = "<layer><defaultStyle>Forests</defaultStyle><styles><style>Ponds</style></styles></layer>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/layers/cite:Buildings", xml, "text/xml");
        LayerTest.assertEquals((int)200, (int)response.getStatusCode());
        l = this.catalog.getLayerByName("cite:Buildings");
        LayerTest.assertEquals((String)"Forests", (String)l.getDefaultStyle().getName());
    }

    public void testDelete() throws Exception {
        LayerTest.assertNotNull((Object)this.catalog.getLayerByName("cite:Buildings"));
        LayerTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/layers/cite:Buildings").getStatusCode());
    }

    public void testDeleteRecursive() throws Exception {
        LayerTest.assertNotNull((Object)this.catalog.getLayerByName("cite:Buildings"));
        LayerTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("cite", "Buildings"));
        LayerTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/layers/cite:Buildings").getStatusCode());
        LayerTest.assertNull((Object)this.catalog.getLayerByName("cite:Buildings"));
        LayerTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("cite", "Buildings"));
        LayerTest.assertNotNull((Object)this.catalog.getLayerByName("cite:Bridges"));
        LayerTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("cite", "Bridges"));
        LayerTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/layers/cite:Bridges?recurse=true").getStatusCode());
        LayerTest.assertNull((Object)this.catalog.getLayerByName("cite:Bridges"));
        LayerTest.assertNull((Object)this.catalog.getFeatureTypeByName("cite", "Bridges"));
    }
}

