/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.DispatcherServlet;

public class RestConcurrencyTest
extends CatalogRESTTestSupport {
    static volatile Exception exception;
    volatile DispatcherServlet dispatcher;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        exception = null;
    }

    protected void addPropertyDataStores(int typeCount) throws Exception {
        ByteArrayOutputStream zbytes = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(zbytes);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int i = 0;
        while (i < typeCount) {
            String name = "pds" + i;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(bytes));
            writer.write("_=name:String,pointProperty:Point\n");
            writer.write(String.valueOf(name) + ".0='zero'|POINT(0 0)\n");
            writer.write(String.valueOf(name) + ".1='one'|POINT(1 1)\n");
            writer.flush();
            zout.putNextEntry(new ZipEntry(String.valueOf(name) + ".properties"));
            zout.write(bytes.toByteArray());
            bytes.reset();
            ++i;
        }
        zout.flush();
        zout.close();
        this.put("/rest/workspaces/gs/datastores/pds/file.properties?configure=none", zbytes.toByteArray(), "application/zip");
    }

    protected boolean useLegacyDataDirectory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DispatcherServlet getDispatcher() throws Exception {
        if (this.dispatcher == null) {
            RestConcurrencyTest restConcurrencyTest = this;
            synchronized (restConcurrencyTest) {
                if (this.dispatcher == null) {
                    this.dispatcher = super.getDispatcher();
                }
            }
        }
        return this.dispatcher;
    }

    /*
     * WARNING - void declaration
     */
    public void testFeatureTypeConcurrency() throws Exception {
        int typeCount = 5;
        this.addPropertyDataStores(typeCount);
        ExecutorService es = Executors.newCachedThreadPool();
        try {
            void var4_5;
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            boolean bl = false;
            while (var4_5 < typeCount) {
                futures.add(es.submit(new AddRemoveFeatureTypeWorker("gs", "pds", "pds" + (int)var4_5, 5)));
                ++var4_5;
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            es.shutdownNow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AddRemoveFeatureTypeWorker
    implements Callable<Integer> {
        final Logger LOGGER = Logging.getLogger(RestConcurrencyTest.class);
        String typeName;
        String workspace;
        String store;
        int loops;

        public AddRemoveFeatureTypeWorker(String workspace, String store, String typeName, int loops) {
            this.typeName = typeName;
            this.workspace = workspace;
            this.store = store;
            this.loops = loops;
        }

        @Override
        public Integer call() throws Exception {
            try {
                this.callInternal();
            }
            catch (Exception e) {
                exception = e;
                throw e;
            }
            return this.loops;
        }

        private void callInternal() throws Exception {
            String threadId = String.valueOf(Thread.currentThread().getId()) + " ";
            int i = 0;
            while (i < this.loops && exception == null) {
                String base = "/rest/workspaces/" + this.workspace + "/datastores/" + this.store + "/featuretypes/";
                String xml = "<featureType><name>" + this.typeName + "</name>" + "<nativeName>" + this.typeName + "</nativeName>" + "<srs>EPSG:4326</srs>" + "<nativeCRS>EPSG:4326</nativeCRS>" + "<nativeBoundingBox>" + "<minx>0.0</minx>" + "<maxx>1.0</maxx>" + "<miny>0.0</miny>" + "<maxy>1.0</maxy>" + "<crs>EPSG:4326</crs>" + "</nativeBoundingBox>" + "<store>" + this.store + "</store>" + "</featureType>";
                this.LOGGER.info(String.valueOf(threadId) + "Adding " + this.typeName);
                MockHttpServletResponse response = RestConcurrencyTest.this.postAsServletResponse(base, xml, "text/xml");
                RestConcurrencyTest.assertEquals((int)201, (int)response.getStatusCode());
                RestConcurrencyTest.assertNotNull((Object)response.getHeader("Location"));
                RestConcurrencyTest.assertTrue((boolean)response.getHeader("Location").endsWith(String.valueOf(base) + this.typeName));
                this.LOGGER.info(String.valueOf(threadId) + "Checking " + this.typeName);
                String resourcePath = "/rest/layers/" + this.workspace + ":" + this.typeName;
                response = RestConcurrencyTest.this.getAsServletResponse(String.valueOf(resourcePath) + ".xml");
                RestConcurrencyTest.assertEquals((int)200, (int)response.getStatusCode());
                this.LOGGER.info(String.valueOf(threadId) + "Reloading catalog");
                RestConcurrencyTest.assertEquals((int)200, (int)RestConcurrencyTest.this.postAsServletResponse("/rest/reload", "").getStatusCode());
                this.LOGGER.info(String.valueOf(threadId) + "Removing layer");
                String deletePath = String.valueOf(resourcePath) + "?recurse=true";
                RestConcurrencyTest.assertEquals((int)200, (int)RestConcurrencyTest.this.deleteAsServletResponse(deletePath).getStatusCode());
                ++i;
            }
        }
    }
}

