/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.rest.StoreFileResource;
import org.geoserver.rest.RestletException;
import org.geoserver.rest.format.StreamDataFormat;
import org.geoserver.rest.util.RESTUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.vfny.geoserver.util.DataStoreUtils;

public class DataStoreFileResource
extends StoreFileResource {
    protected static HashMap<String, String> formatToDataStoreFactory = new HashMap();
    protected static HashMap<String, Map> dataStoreFactoryToDefaultParams;
    String dataStoreFormat;
    DataStoreFactorySpi factory;

    static {
        formatToDataStoreFactory.put("shp", "org.geotools.data.shapefile.ShapefileDataStoreFactory");
        formatToDataStoreFactory.put("properties", "org.geotools.data.property.PropertyDataStoreFactory");
        formatToDataStoreFactory.put("h2", "org.geotools.data.h2.H2DataStoreFactory");
        formatToDataStoreFactory.put("spatialite", "org.geotools.data.spatialite.SpatiaLiteDataStoreFactory");
        dataStoreFactoryToDefaultParams = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("database", "@DATA_DIR@/@NAME@");
        map.put("dbtype", "h2");
        dataStoreFactoryToDefaultParams.put("org.geotools.data.h2.H2DataStoreFactory", map);
        map = new HashMap();
        map.put("database", "@DATA_DIR@/@NAME@");
        map.put("dbtype", "spatialite");
        dataStoreFactoryToDefaultParams.put("org.geotools.data.spatialite.SpatiaLiteDataStoreFactory", map);
    }

    public static DataStoreFactorySpi lookupDataStoreFactory(String format) {
        DataStoreFactorySpi factory;
        String factoryClassName = formatToDataStoreFactory.get(format);
        if (factoryClassName == null) {
            throw new RestletException("Unsupported format: " + format, Status.CLIENT_ERROR_BAD_REQUEST);
        }
        try {
            Class<?> factoryClass = Class.forName(factoryClassName);
            factory = (DataStoreFactorySpi)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new RestletException("Datastore format unavailable: " + factoryClassName, Status.SERVER_ERROR_INTERNAL);
        }
        return factory;
    }

    public static String lookupDataStoreFactoryFormat(String type) {
        for (DataAccessFactory factory : DataStoreUtils.getAvailableDataStoreFactories()) {
            if (!(factory instanceof DataStoreFactorySpi) || !factory.getDisplayName().equals(type)) continue;
            for (Map.Entry<String, String> e : formatToDataStoreFactory.entrySet()) {
                if (!e.getValue().equals(factory.getClass().getCanonicalName())) continue;
                return e.getKey();
            }
            return factory.getDisplayName();
        }
        return null;
    }

    public DataStoreFileResource(Request request, Response response, String dataStoreFormat, Catalog catalog) {
        super(request, response, catalog);
        this.dataStoreFormat = dataStoreFormat;
        this.factory = DataStoreFileResource.lookupDataStoreFactory(dataStoreFormat);
    }

    public void handleGet() {
        String workspace = this.getAttribute("workspace");
        String datastore = this.getAttribute("datastore");
        String format = this.getAttribute("format");
        DataStoreInfo info = this.catalog.getDataStoreByName(workspace, datastore);
        if (info == null) {
            throw new RestletException("No such datastore " + datastore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        Map params = info.getConnectionParameters();
        File directory = null;
        for (Map.Entry e : params.entrySet()) {
            if (e.getValue() instanceof File) {
                directory = (File)e.getValue();
            } else if (e.getValue() instanceof URL) {
                directory = new File(((URL)e.getValue()).getFile());
            }
            if (directory != null && !"directory".equals(e.getKey())) {
                directory = directory.getParentFile();
            }
            if (directory != null) break;
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new RestletException("No files for datastore " + datastore, Status.CLIENT_ERROR_NOT_FOUND);
        }
        StreamDataFormat fmt = new StreamDataFormat(MediaType.APPLICATION_ZIP){

            protected Object read(InputStream in) throws IOException {
                return null;
            }

            protected void write(Object object, OutputStream out) throws IOException {
                ZipOutputStream zout = new ZipOutputStream(out);
                File directory = (File)object;
                File[] fileArray = directory.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ZipEntry entry = new ZipEntry(f.getName());
                    zout.putNextEntry(entry);
                    IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)zout);
                    zout.closeEntry();
                    ++n2;
                }
                zout.flush();
                zout.close();
            }
        };
        this.getResponse().setEntity(fmt.toRepresentation((Object)directory));
    }

    public void handlePut() {
        block47: {
            DataStore source;
            String workspace = this.getAttribute("workspace");
            String datastore = this.getAttribute("datastore");
            String format = this.getAttribute("format");
            String method = this.getUploadMethod(this.getRequest());
            this.getResponse().setStatus(Status.SUCCESS_ACCEPTED);
            Form form = this.getRequest().getResourceRef().getQueryAsForm();
            File uploadedFile = this.doFileUpload(method, workspace, datastore, format);
            String sourceDataStoreFormat = this.dataStoreFormat;
            String targetDataStoreFormat = RESTUtils.getQueryStringValue((Request)this.getRequest(), (String)"target");
            if (targetDataStoreFormat == null) {
                targetDataStoreFormat = sourceDataStoreFormat;
            }
            sourceDataStoreFormat = sourceDataStoreFormat.toLowerCase();
            targetDataStoreFormat = targetDataStoreFormat.toLowerCase();
            CatalogBuilder builder = new CatalogBuilder(this.catalog);
            builder.setWorkspace(this.catalog.getWorkspaceByName(workspace));
            DataStoreInfo info = this.catalog.getDataStoreByName(workspace, datastore);
            NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace);
            boolean add = false;
            boolean save = false;
            boolean canRemoveFiles = false;
            String charset = form.getFirstValue("charset");
            if (info == null) {
                LOGGER.info("Auto-configuring datastore: " + datastore);
                info = builder.buildDataStore(datastore);
                add = true;
                if (charset != null && charset.length() > 0) {
                    info.getConnectionParameters().put("charset", charset);
                }
                DataStoreFactorySpi targetFactory = this.factory;
                if (!targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                    targetFactory = DataStoreFileResource.lookupDataStoreFactory(targetDataStoreFormat);
                    if (targetFactory == null) {
                        throw new RestletException("Unable to create data store of type " + targetDataStoreFormat, Status.CLIENT_ERROR_BAD_REQUEST);
                    }
                    this.autoCreateParameters(info, namespace, targetFactory);
                    canRemoveFiles = true;
                } else {
                    this.updateParameters(info, namespace, targetFactory, uploadedFile);
                }
                info.setType(targetFactory.getDisplayName());
            } else {
                LOGGER.info("Using existing datastore: " + datastore);
                targetDataStoreFormat = DataStoreFileResource.lookupDataStoreFactoryFormat(info.getType());
                if (targetDataStoreFormat == null) {
                    throw new RuntimeException("Unable to locate data store factory of type " + info.getType());
                }
                if (targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                    save = true;
                    this.updateParameters(info, namespace, this.factory, uploadedFile);
                } else {
                    canRemoveFiles = true;
                }
            }
            builder.setStore((StoreInfo)info);
            if (add) {
                this.catalog.add((StoreInfo)info);
            } else if (save) {
                this.catalog.save((StoreInfo)info);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (charset != null && charset.length() > 0) {
                params.put("charset", charset);
            }
            this.updateParameters(params, this.factory, uploadedFile);
            try {
                source = this.factory.createDataStore(params);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create source data store", e);
            }
            try {
                String configure;
                DataStore ds = (DataStore)info.getDataStore(null);
                if (!targetDataStoreFormat.equals(sourceDataStoreFormat)) {
                    String[] stringArray = source.getTypeNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block45: {
                            String featureTypeName = stringArray[n2];
                            SimpleFeatureType featureType = null;
                            try {
                                featureType = ds.getSchema(featureTypeName);
                            }
                            catch (Exception e) {
                                LOGGER.info(String.valueOf(featureTypeName) + " does not exist in data store " + datastore + ". Attempting to create it");
                                ds.createSchema((FeatureType)source.getSchema(featureTypeName));
                                featureType = source.getSchema(featureTypeName);
                            }
                            SimpleFeatureSource featureSource = ds.getFeatureSource(featureTypeName);
                            if (!(featureSource instanceof FeatureStore)) {
                                LOGGER.warning(String.valueOf(featureTypeName) + " is not writable, skipping");
                            } else {
                                DefaultTransaction tx = new DefaultTransaction();
                                FeatureStore featureStore = (FeatureStore)featureSource;
                                featureStore.setTransaction((Transaction)tx);
                                try {
                                    try {
                                        String update = form.getFirstValue("update");
                                        if ("overwrite".equalsIgnoreCase(update)) {
                                            LOGGER.fine("Removing existing features from " + featureTypeName);
                                            featureStore.removeFeatures((Filter)Filter.INCLUDE);
                                        }
                                        LOGGER.fine("Adding features to " + featureTypeName);
                                        SimpleFeatureCollection features = source.getFeatureSource(featureTypeName).getFeatures();
                                        featureStore.addFeatures((FeatureCollection)features);
                                        tx.commit();
                                    }
                                    catch (Exception e) {
                                        tx.rollback();
                                        tx.close();
                                        break block45;
                                    }
                                }
                                catch (Throwable throwable) {
                                    tx.close();
                                    throw throwable;
                                }
                                tx.close();
                            }
                        }
                        ++n2;
                    }
                }
                if ("none".equalsIgnoreCase(configure = form.getFirstValue("configure"))) {
                    this.getResponse().setStatus(Status.SUCCESS_CREATED);
                    return;
                }
                HashMap<String, FeatureTypeInfo> featureTypesByNativeName = new HashMap<String, FeatureTypeInfo>();
                for (FeatureTypeInfo ftInfo : this.catalog.getFeatureTypesByDataStore(info)) {
                    featureTypesByNativeName.put(ftInfo.getNativeName(), ftInfo);
                }
                String[] featureTypeNames = source.getTypeNames();
                int i = 0;
                while (i < featureTypeNames.length) {
                    if (!"all".equalsIgnoreCase(configure) && i > 0) break;
                    SimpleFeatureSource fs = ds.getFeatureSource(featureTypeNames[i]);
                    FeatureTypeInfo ftinfo = (FeatureTypeInfo)featureTypesByNativeName.get(featureTypeNames[i]);
                    if (ftinfo == null) {
                        ftinfo = builder.buildFeatureType((FeatureSource)fs);
                        builder.lookupSRS(ftinfo, true);
                        builder.setupBounds((ResourceInfo)ftinfo);
                    }
                    ReferencedEnvelope bounds = fs.getBounds();
                    ftinfo.setNativeBoundingBox(bounds);
                    if (ftinfo.getId() == null) {
                        if (this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null) {
                            LOGGER.warning(String.format("Feature type %s already exists in namespace %s, attempting to rename", ftinfo.getName(), namespace.getPrefix()));
                            boolean x = true;
                            String originalName = ftinfo.getName();
                            do {
                                ftinfo.setName(String.valueOf(originalName) + i);
                            } while (++i < 10 && this.catalog.getFeatureTypeByName(namespace, ftinfo.getName()) != null);
                        }
                        this.catalog.add((ResourceInfo)ftinfo);
                        LayerInfo layer = builder.buildLayer(ftinfo);
                        boolean valid = true;
                        try {
                            if (!this.catalog.validate(layer, true).isEmpty()) {
                                valid = false;
                            }
                        }
                        catch (Exception e) {
                            valid = false;
                        }
                        layer.setEnabled(valid);
                        this.catalog.add(layer);
                        LOGGER.info("Added feature type " + ftinfo.getName());
                    } else {
                        LOGGER.info("Updated feature type " + ftinfo.getName());
                        this.catalog.save((ResourceInfo)ftinfo);
                    }
                    this.getResponse().setStatus(Status.SUCCESS_CREATED);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            source.dispose();
            if (this.isInlineUpload(method) && canRemoveFiles) {
                if (uploadedFile.isFile()) {
                    uploadedFile = uploadedFile.getParentFile();
                }
                try {
                    FileUtils.deleteDirectory((File)uploadedFile);
                }
                catch (IOException e) {
                    LOGGER.info("Unable to delete " + uploadedFile.getAbsolutePath());
                    if (!LOGGER.isLoggable(Level.FINE)) break block47;
                    LOGGER.log(Level.FINE, "", e);
                }
            }
        }
    }

    protected File findPrimaryFile(File directory, String format) {
        if ("shp".equalsIgnoreCase(format)) {
            return directory;
        }
        return super.findPrimaryFile(directory, format);
    }

    void updateParameters(DataStoreInfo info, NamespaceInfo namespace, DataStoreFactorySpi factory, File uploadedFile) {
        Map connectionParameters = info.getConnectionParameters();
        this.updateParameters(connectionParameters, factory, uploadedFile);
        connectionParameters.put("namespace", namespace.getURI());
        if (!factory.canProcess(connectionParameters)) {
            throw new RestletException("Unable to configure datastore, bad parameters.", Status.SERVER_ERROR_INTERNAL);
        }
    }

    void updateParameters(Map connectionParameters, DataStoreFactorySpi factory, File uploadedFile) {
        DataAccessFactory.Param[] paramArray = factory.getParametersInfo();
        int n = paramArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataAccessFactory.Param p = paramArray[n2];
            if (File.class == p.type || URL.class == p.type) {
                File f = uploadedFile;
                if ("directory".equals(p.key)) {
                    f = f.getParentFile();
                }
                Serializable converted = null;
                if (URI.class.equals((Object)p.type)) {
                    converted = f.toURI();
                } else if (URL.class.equals((Object)p.type)) {
                    try {
                        converted = f.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (converted != null) {
                    connectionParameters.put(p.key, converted);
                } else {
                    connectionParameters.put(p.key, f);
                }
            } else if (p.required) {
                try {
                    p.lookUp(connectionParameters);
                }
                catch (Exception e) {
                    connectionParameters.put(p.key, p.sample);
                }
            }
            ++n2;
        }
    }

    void autoCreateParameters(DataStoreInfo info, NamespaceInfo namespace, DataStoreFactorySpi factory) {
        Map defaultParams = dataStoreFactoryToDefaultParams.get(factory.getClass().getCanonicalName());
        if (defaultParams == null) {
            throw new RuntimeException("Unable to auto create parameters for " + factory.getDisplayName());
        }
        HashMap<String, String> params = new HashMap<String, String>(defaultParams);
        String dataDirRoot = this.catalog.getResourceLoader().getBaseDirectory().getAbsolutePath();
        for (Map.Entry entry : params.entrySet()) {
            Map.Entry e = entry;
            if (!(e.getValue() instanceof String)) continue;
            String string = (String)e.getValue();
            string = string.replace("@NAME@", info.getName()).replace("@DATA_DIR@", dataDirRoot);
            e.setValue(string);
        }
        params.put("namespace", namespace.getURI());
        info.getConnectionParameters().putAll(params);
    }
}

