/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.geoserver.data.test.MockData;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.FeatureType;
import org.w3c.dom.Document;

public class JDBCTest
extends CatalogRESTTestSupport {
    protected String databasePath() {
        File path = new File(this.getTestData().getDataDirectoryRoot(), "target/acme");
        return path.getAbsolutePath();
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(JDBCDataStoreFactory.NAMESPACE.key, MockData.DEFAULT_URI);
        params.put(JDBCDataStoreFactory.DATABASE.key, this.databasePath());
        params.put(JDBCDataStoreFactory.DBTYPE.key, "h2");
        H2DataStoreFactory fac = new H2DataStoreFactory();
        JDBCDataStore ds = fac.createDataStore(params);
        if (Arrays.asList(ds.getTypeNames()).indexOf("widgets") >= 0) {
            return;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("widgets");
        tb.setSRS("EPSG:4326");
        tb.add("g", Point.class);
        tb.add("name", String.class);
        ds.createSchema(tb.buildFeatureType());
        FeatureWriter fw = ds.getFeatureWriterAppend("widgets", Transaction.AUTO_COMMIT);
        fw.hasNext();
        SimpleFeature sf = (SimpleFeature)fw.next();
        sf.setAttribute("g", (Object)new GeometryFactory().createPoint(new Coordinate(1.0, 1.0)));
        sf.setAttribute("name", (Object)"one");
        fw.write();
        fw.hasNext();
        sf = (SimpleFeature)fw.next();
        sf.setAttribute("g", (Object)new GeometryFactory().createPoint(new Coordinate(2.0, 2.0)));
        sf.setAttribute("name", (Object)"two");
        fw.write();
        fw.close();
        ds.dispose();
    }

    public void testCreateDataStore() throws Exception {
        JDBCTest.assertNull((Object)this.catalog.getDataStoreByName("gs", "acme"));
        String xml = "<dataStore><name>acme</name><connectionParameters><namespace>" + MockData.DEFAULT_URI + "</namespace>" + "<database>" + this.databasePath() + "</database>" + "<dbtype>h2</dbtype>" + "</connectionParameters>" + "</dataStore>";
        MockHttpServletResponse resp = this.postAsServletResponse("/rest/workspaces/gs/datastores", xml);
        JDBCTest.assertEquals((String)resp.getOutputStreamContent(), (int)201, (int)resp.getStatusCode());
        JDBCTest.assertNotNull((Object)this.catalog.getDataStoreByName("gs", "acme"));
    }

    public void testCreateFeatureType() throws Exception {
        this.testCreateDataStore();
        DataStoreInfo ds = this.catalog.getDataStoreByName("gs", "acme");
        JDBCTest.assertNull((Object)this.catalog.getFeatureTypeByDataStore(ds, "widgets"));
        String xml = "<featureType><name>widgets</name></featureType>";
        MockHttpServletResponse resp = this.postAsServletResponse("/rest/workspaces/gs/datastores/acme/featuretypes", xml);
        JDBCTest.assertEquals((int)201, (int)resp.getStatusCode());
        JDBCTest.assertNotNull((Object)this.catalog.getFeatureTypeByDataStore(ds, "widgets"));
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:widgets");
        JDBCTest.assertEquals((int)2, (int)dom.getElementsByTagName("gs:widgets").getLength());
    }

    public void testCreateGeometrylessFeatureType() throws Exception {
        this.testCreateDataStore();
        DataStoreInfo dsinfo = this.catalog.getDataStoreByName("gs", "acme");
        JDBCTest.assertNull((Object)this.catalog.getFeatureTypeByDataStore(dsinfo, "widgetsNG"));
        DataStore ds = (DataStore)dsinfo.getDataStore(null);
        try {
            if (ds.getSchema("widgetsNG") != null) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("widgetsNG");
        tb.add("name", String.class);
        ds.createSchema((FeatureType)tb.buildFeatureType());
        FeatureWriter fw = ds.getFeatureWriterAppend("widgetsNG", Transaction.AUTO_COMMIT);
        fw.hasNext();
        SimpleFeature sf = (SimpleFeature)fw.next();
        sf.setAttribute("name", (Object)"one");
        fw.write();
        fw.hasNext();
        sf = (SimpleFeature)fw.next();
        sf.setAttribute("name", (Object)"two");
        fw.write();
        fw.close();
        String xml = "<featureType><name>widgetsNG</name></featureType>";
        MockHttpServletResponse resp = this.postAsServletResponse("/rest/workspaces/gs/datastores/acme/featuretypes", xml);
        JDBCTest.assertEquals((int)201, (int)resp.getStatusCode());
        JDBCTest.assertNotNull((Object)this.catalog.getFeatureTypeByDataStore(dsinfo, "widgetsNG"));
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:widgetsNG");
        JDBCTest.assertEquals((int)2, (int)dom.getElementsByTagName("gs:widgetsNG").getLength());
    }

    public void testCreateSQLView() throws Exception {
        this.testCreateDataStore();
        DataStoreInfo ds = this.catalog.getDataStoreByName("gs", "acme");
        JDBCTest.assertNull((Object)this.catalog.getFeatureTypeByDataStore(ds, "widgets"));
        String xml = "<featureType>\n  <name>sqlview</name>\n  <nativeName>sqlview</nativeName>\n  <namespace>\n    <name>gs</name>\n  </namespace>\n  <srs>EPSG:4326</srs>\n  <metadata>\n  <entry key=\"JDBC_VIRTUAL_TABLE\">\n     <virtualTable>       <name>sqlview</name>       <sql>select \"g\" from \"widgets\"</sql>\n       <geometry>         <name>g</name>         <type>Point</type>         <srid>4326</srid>       </geometry>\n     </virtualTable>  </entry>  </metadata></featureType>";
        MockHttpServletResponse resp = this.postAsServletResponse("/rest/workspaces/gs/datastores/acme/featuretypes", xml);
        JDBCTest.assertEquals((int)201, (int)resp.getStatusCode());
        JDBCTest.assertNotNull((Object)this.catalog.getFeatureTypeByDataStore(ds, "sqlview"));
        JDBCTest.assertNotNull((Object)this.catalog.getFeatureTypeByName("gs:sqlview"));
        Document dom = this.getAsDOM("wfs?request=getfeature&typename=gs:sqlview");
        JDBCTest.assertEquals((int)2, (int)dom.getElementsByTagName("gs:sqlview").getLength());
    }

    public void testUploadUsesNativeNameForConflictDetection() throws Exception {
        this.testCreateDataStore();
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(/featureTypes/featureType)", (Document)this.getAsDOM("/rest/workspaces/gs/datastores/acme/featuretypes.xml"));
        byte[] dataToUpload = this.zippedPropertyFile("pds.properties");
        MockHttpServletResponse resp = this.putAsServletResponse("/rest/workspaces/gs/datastores/acme/file.properties", dataToUpload, "application/zip");
        JDBCTest.assertEquals((String)("Upload into database datastore failed: " + resp.getOutputStreamContent()), (int)201, (int)resp.getStatusCode());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/featureTypes/featureType)", (Document)this.getAsDOM("/rest/workspaces/gs/datastores/acme/featuretypes.xml"));
        resp = this.putAsServletResponse("/rest/workspaces/gs/datastores/acme/featuretypes/pds.xml", "<featureType><name>pds_alt</name></featureType>", "application/xml");
        JDBCTest.assertEquals((String)("Couldn't update featuretype settings: " + resp.getOutputStreamContent()), (int)200, (int)resp.getStatusCode());
        resp = this.putAsServletResponse("/rest/workspaces/gs/datastores/acme/file.properties", dataToUpload, "application/zip");
        JDBCTest.assertEquals((String)("Second upload to database datastore failed: " + resp.getOutputStreamContent()), (int)201, (int)resp.getStatusCode());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/featureTypes/featureType)", (Document)this.getAsDOM("/rest/workspaces/gs/datastores/acme/featuretypes.xml"));
    }

    byte[] zippedPropertyFile(String filename) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zout = new ZipOutputStream(out);
        zout.putNextEntry(new ZipEntry(filename));
        zout.write(this.propertyFile());
        zout.flush();
        zout.close();
        return out.toByteArray();
    }

    byte[] propertyFile() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
        writer.write("_=name:String,pointProperty:Point\n");
        writer.write("ds.0='zero'|POINT(0 0)\n");
        writer.write("ds.1='one'|POINT(1 1)\n");
        writer.flush();
        return output.toByteArray();
    }
}

