/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.rest.CatalogRESTTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WorkspaceTest
extends CatalogRESTTestSupport {
    public void testGetAllAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        WorkspaceTest.assertEquals((int)this.catalog.getNamespaces().size(), (int)dom.getElementsByTagName("workspace").getLength());
    }

    public void testGetAllAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces.json");
        WorkspaceTest.assertTrue((boolean)(json instanceof JSONObject));
        JSONArray workspaces = ((JSONObject)json).getJSONObject("workspaces").getJSONArray("workspace");
        WorkspaceTest.assertNotNull((Object)workspaces);
        WorkspaceTest.assertEquals((int)this.catalog.getNamespaces().size(), (int)workspaces.size());
    }

    public void testGetAllAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces.html");
        List workspaces = this.catalog.getWorkspaces();
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        WorkspaceTest.assertEquals((int)workspaces.size(), (int)links.getLength());
        int i = 0;
        while (i < workspaces.size()) {
            WorkspaceInfo ws = (WorkspaceInfo)workspaces.get(i);
            Element link = (Element)links.item(i);
            WorkspaceTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(ws.getName()) + ".html"));
            ++i;
        }
    }

    public void testPutAllUnauthorized() throws Exception {
        WorkspaceTest.assertEquals((int)405, (int)this.putAsServletResponse("/rest/workspaces").getStatusCode());
    }

    public void testDeleteAllUnauthorized() throws Exception {
        WorkspaceTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces").getStatusCode());
    }

    public void testGetAsXML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf.xml");
        WorkspaceTest.assertEquals((String)"workspace", (String)dom.getDocumentElement().getLocalName());
        WorkspaceTest.assertEquals((int)1, (int)dom.getElementsByTagName("name").getLength());
        Element name = (Element)dom.getElementsByTagName("name").item(0);
        WorkspaceTest.assertEquals((String)"sf", (String)name.getFirstChild().getTextContent());
    }

    public void testGetAsHTML() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/sf.html");
        List stores = this.catalog.getStoresByWorkspace("sf", StoreInfo.class);
        NodeList links = this.xp.getMatchingNodes("//html:a", dom);
        WorkspaceTest.assertEquals((int)stores.size(), (int)links.getLength());
        int i = 0;
        while (i < stores.size()) {
            StoreInfo store = (StoreInfo)stores.get(i);
            Element link = (Element)links.item(i);
            WorkspaceTest.assertTrue((boolean)link.getAttribute("href").endsWith(String.valueOf(store.getName()) + ".html"));
            ++i;
        }
    }

    public void testGetNonExistant() throws Exception {
        WorkspaceTest.assertEquals((int)404, (int)this.getAsServletResponse("/rest/workspaces/none").getStatusCode());
    }

    public void testPostAsXML() throws Exception {
        String xml = "<workspace><name>foo</name></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", xml, "text/xml");
        WorkspaceTest.assertEquals((int)201, (int)response.getStatusCode());
        WorkspaceTest.assertNotNull((Object)response.getHeader("Location"));
        WorkspaceTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        WorkspaceTest.assertNotNull((Object)ws);
    }

    public void testGetAsJSON() throws Exception {
        JSON json = this.getAsJSON("/rest/workspaces/sf.json");
        JSONObject workspace = ((JSONObject)json).getJSONObject("workspace");
        WorkspaceTest.assertEquals((Object)"sf", (Object)workspace.get("name"));
    }

    public void testPostAsJSON() throws Exception {
        String json = "{'workspace':{ 'name':'foo' }}";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces", json, "text/json");
        WorkspaceTest.assertEquals((int)201, (int)response.getStatusCode());
        WorkspaceTest.assertNotNull((Object)response.getHeader("Location"));
        WorkspaceTest.assertTrue((boolean)response.getHeader("Location").endsWith("/workspaces/foo"));
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("foo");
        WorkspaceTest.assertNotNull((Object)ws);
    }

    public void testPostToResource() throws Exception {
        String xml = "<workspace><name>changed</name></workspace>";
        MockHttpServletResponse response = this.postAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        WorkspaceTest.assertEquals((int)405, (int)response.getStatusCode());
    }

    public void testDeleteNonExistant() throws Exception {
        WorkspaceTest.assertEquals((int)404, (int)this.deleteAsServletResponse("/rest/workspaces/newExistant").getStatusCode());
    }

    public void testDelete() throws Exception {
        String xml = "<workspace><name>foo</name></workspace>";
        this.post("/rest/workspaces", xml);
        Document dom = this.getAsDOM("/rest/workspaces/foo.xml");
        WorkspaceTest.assertEquals((String)"workspace", (String)dom.getDocumentElement().getNodeName());
        WorkspaceTest.assertEquals((int)200, (int)this.deleteAsServletResponse("/rest/workspaces/foo").getStatusCode());
        WorkspaceTest.assertEquals((int)404, (int)this.getAsServletResponse("/rest/workspaces/foo.xml").getStatusCode());
    }

    public void testDeleteNonEmptyForbidden() throws Exception {
        WorkspaceTest.assertEquals((int)403, (int)this.deleteAsServletResponse("/rest/workspaces/sf").getStatusCode());
    }

    public void testDeleteDefaultNotAllowed() throws Exception {
        WorkspaceTest.assertEquals((int)405, (int)this.deleteAsServletResponse("/rest/workspaces/default").getStatusCode());
    }

    public void testDeleteAllOneByOne() throws Exception {
        for (WorkspaceInfo ws : this.getCatalog().getWorkspaces()) {
            CascadeDeleteVisitor visitor = new CascadeDeleteVisitor(this.getCatalog());
            for (StoreInfo store : this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class)) {
                store.accept((CatalogVisitor)visitor);
            }
            String resource = "/rest/workspaces/" + ws.getName();
            System.out.println(resource);
            WorkspaceTest.assertEquals((int)200, (int)this.deleteAsServletResponse(resource).getStatusCode());
            WorkspaceTest.assertEquals((int)404, (int)this.getAsServletResponse(resource).getStatusCode());
        }
        Document dom = this.getAsDOM("/rest/workspaces.xml");
        WorkspaceTest.assertEquals((int)0, (int)dom.getElementsByTagName("workspace").getLength());
    }

    public void testDeleteRecursive() throws Exception {
        List stores = this.catalog.getStoresByWorkspace("sf", StoreInfo.class);
        WorkspaceTest.assertFalse((boolean)stores.isEmpty());
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/workspaces/sf?recurse=true");
        WorkspaceTest.assertEquals((int)200, (int)response.getStatusCode());
        WorkspaceTest.assertNull((Object)this.catalog.getWorkspaceByName("sf"));
        WorkspaceTest.assertNull((Object)this.catalog.getNamespaceByPrefix("sf"));
        for (StoreInfo s : stores) {
            WorkspaceTest.assertNull((Object)this.catalog.getStoreByName(s.getName(), StoreInfo.class));
        }
    }

    public void testPut() throws Exception {
        String xml = "<workspace><metadata><foo><string>bar</string></foo></metadata></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        WorkspaceTest.assertEquals((int)200, (int)response.getStatusCode());
        Document dom = this.getAsDOM("/rest/workspaces/gs.xml");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//name[text()='gs'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//entry[@key='foo' and text()='bar'])", (Document)dom);
    }

    public void testPutNameChangeForbidden() throws Exception {
        String xml = "<workspace><name>changed</name></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/gs", xml, "text/xml");
        WorkspaceTest.assertEquals((int)403, (int)response.getStatusCode());
    }

    public void testPutNonExistant() throws Exception {
        String xml = "<workspace><metadata><entry><string>foo</string><string>bar</string></entry></metadata></workspace>";
        MockHttpServletResponse response = this.putAsServletResponse("/rest/workspaces/nonExistant", xml, "text/xml");
        WorkspaceTest.assertEquals((int)404, (int)response.getStatusCode());
    }

    public void testGetDefaultWorkspace() throws Exception {
        Document dom = this.getAsDOM("/rest/workspaces/default.xml");
        WorkspaceTest.assertEquals((String)"workspace", (String)dom.getDocumentElement().getLocalName());
        WorkspaceTest.assertEquals((int)1, (int)dom.getElementsByTagName("name").getLength());
    }

    public void testPutDefaultWorkspace() throws Exception {
        WorkspaceInfo def = this.getCatalog().getDefaultWorkspace();
        WorkspaceTest.assertEquals((String)"gs", (String)def.getName());
        String json = "{'workspace':{ 'name':'sf' }}";
        this.put("/rest/workspaces/default", json, "text/json");
        def = this.getCatalog().getDefaultWorkspace();
        WorkspaceTest.assertEquals((String)"sf", (String)def.getName());
    }
}

