/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;
import net.opengis.wcs10.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.kvp.Wcs10GetCoverageRequestReader;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geoserver.wcs.xml.v1_0_0.WcsXmlReader;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.wcs.WCSConfiguration;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCoverageTest
extends WCSTestSupport {
    private Wcs10GetCoverageRequestReader kvpreader;
    private WebCoverageService100 service;
    private WCSConfiguration configuration;
    private WcsXmlReader xmlReader;
    private Catalog catalog;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCoverageTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.kvpreader = (Wcs10GetCoverageRequestReader)applicationContext.getBean("wcs100GetCoverageRequestReader");
        this.service = (WebCoverageService100)applicationContext.getBean("wcs100ServiceTarget");
        this.configuration = new WCSConfiguration();
        this.catalog = (Catalog)applicationContext.getBean("catalog");
        this.xmlReader = new WcsXmlReader("GetCoverage", "1.0.0", this.configuration);
    }

    protected String getLogConfiguration() {
        return "/DEFAULT_LOGGING.properties";
    }

    private Map<String, Object> baseMap() {
        HashMap<String, Object> raw = new HashMap<String, Object>();
        raw.put("service", "WCS");
        raw.put("version", "1.0.0");
        raw.put("request", "GetCoverage");
        return raw;
    }

    public void testDomainSubsetRxRy() throws Exception {
        GridCoverage baseCoverage = this.catalog.getCoverageByName(MockData.TASMANIA_BM.getLocalPart()).getGridCoverage(null, null);
        AffineTransform2D expectedTx = (AffineTransform2D)baseCoverage.getGridGeometry().getGridToCRS();
        GeneralEnvelope originalEnvelope = (GeneralEnvelope)baseCoverage.getEnvelope();
        GeneralEnvelope newEnvelope = new GeneralEnvelope((Envelope)originalEnvelope);
        newEnvelope.setEnvelope(new double[]{originalEnvelope.getMinimum(0), originalEnvelope.getMaximum(1) - originalEnvelope.getSpan(1) / 2.0, originalEnvelope.getMinimum(0) + originalEnvelope.getSpan(0) / 2.0, originalEnvelope.getMaximum(1)});
        MathTransform cornerWorldToGrid = PixelTranslation.translate((MathTransform)expectedTx, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
        GeneralGridEnvelope expectedGridEnvelope = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)cornerWorldToGrid.inverse(), (Envelope)newEnvelope), PixelInCell.CELL_CORNER, false);
        StringBuilder envelopeBuilder = new StringBuilder();
        envelopeBuilder.append(newEnvelope.getMinimum(0)).append(",");
        envelopeBuilder.append(newEnvelope.getMinimum(1)).append(",");
        envelopeBuilder.append(newEnvelope.getMaximum(0)).append(",");
        envelopeBuilder.append(newEnvelope.getMaximum(1));
        Map<String, Object> raw = this.baseMap();
        String layerID = this.getLayerId(MockData.TASMANIA_BM);
        raw.put("sourcecoverage", layerID);
        raw.put("version", "1.0.0");
        raw.put("format", "image/geotiff");
        raw.put("BBox", envelopeBuilder.toString());
        raw.put("crs", "EPSG:4326");
        raw.put("resx", Double.toString(expectedTx.getScaleX()));
        raw.put("resy", Double.toString(Math.abs(expectedTx.getScaleY())));
        GridCoverage[] coverages = this.executeGetCoverageKvp(raw);
        GridCoverage2D result = (GridCoverage2D)coverages[0];
        GetCoverageTest.assertTrue((coverages.length == 1 ? 1 : 0) != 0);
        AffineTransform2D tx = (AffineTransform2D)result.getGridGeometry().getGridToCRS();
        GetCoverageTest.assertEquals((String)"resx", (double)expectedTx.getScaleX(), (double)tx.getScaleX(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"resx", (double)Math.abs(expectedTx.getScaleY()), (double)Math.abs(tx.getScaleY()), (double)1.0E-6);
        GridEnvelope gridEnvelope = result.getGridGeometry().getGridRange();
        GetCoverageTest.assertEquals((String)"w", (int)180, (int)gridEnvelope.getSpan(0));
        GetCoverageTest.assertEquals((String)"h", (int)180, (int)gridEnvelope.getSpan(1));
        GetCoverageTest.assertEquals((String)"grid envelope", (Object)expectedGridEnvelope, (Object)gridEnvelope);
        ((GridCoverage2D)coverages[0]).dispose(true);
    }

    private static void compareGrid2World(AffineTransform2D expectedTx, AffineTransform2D tx) {
        GetCoverageTest.assertEquals((String)"scalex", (double)tx.getScaleX(), (double)expectedTx.getScaleX(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"scaley", (double)tx.getScaleY(), (double)expectedTx.getScaleY(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"shearx", (double)tx.getShearX(), (double)expectedTx.getShearX(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"sheary", (double)tx.getShearY(), (double)expectedTx.getShearY(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"translatex", (double)tx.getTranslateX(), (double)expectedTx.getTranslateX(), (double)1.0E-6);
        GetCoverageTest.assertEquals((String)"translatey", (double)tx.getTranslateY(), (double)expectedTx.getTranslateY(), (double)1.0E-6);
    }

    public void testWorkspaceQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse("wcs?sourcecoverage=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        GetCoverageTest.assertTrue((boolean)response.getContentType().startsWith("image/tiff"));
        Document dom = this.getAsDOM("cdf/wcs?sourcecoverage=" + MockData.TASMANIA_BM.getLocalPart() + queryString);
        GetCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
    }

    public void testLayerQualified() throws Exception {
        String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
        MockHttpServletResponse response = this.getAsServletResponse("wcs/BlueMarble/wcs?sourcecoverage=BlueMarble" + queryString);
        GetCoverageTest.assertTrue((boolean)response.getContentType().startsWith("image/tiff"));
        Document dom = this.getAsDOM("wcs/DEM/wcs?sourcecoverage=BlueMarble" + queryString);
        GetCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
    }

    GridCoverage[] executeGetCoverageKvp(Map<String, Object> raw) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.kvpreader.read(this.kvpreader.createRequest(), this.parseKvp(raw), raw);
        return this.service.getCoverage(getCoverage);
    }

    GridCoverage[] executeGetCoverageXml(String request) throws Exception {
        GetCoverageType getCoverage = (GetCoverageType)this.xmlReader.read(null, (Reader)new StringReader(request), null);
        return this.service.getCoverage(getCoverage);
    }

    public void testInputLimits() throws Exception {
        try {
            this.setInputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            GetCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ServiceExceptionReport/ServiceException/text()", dom).trim();
            GetCoverageTest.assertTrue((boolean)error.matches(".*read too much data.*"));
        }
        finally {
            this.setInputLimit(0);
        }
    }

    public void testOutputLimits() throws Exception {
        try {
            this.setOutputLimit(1);
            String queryString = "&request=getcoverage&service=wcs&version=1.0.0&format=image/geotiff&bbox=146,-45,147,-42&crs=EPSG:4326&width=150&height=150";
            Document dom = this.getAsDOM("wcs/BlueMarble/wcs?sourcecoverage=" + this.getLayerId(MockData.TASMANIA_BM) + queryString);
            GetCoverageTest.assertEquals((String)"ServiceExceptionReport", (String)dom.getDocumentElement().getNodeName());
            String error = xpath.evaluate("/ServiceExceptionReport/ServiceException/text()", dom).trim();
            GetCoverageTest.assertTrue((boolean)error.matches(".*generate too much data.*"));
        }
        finally {
            this.setOutputLimit(0);
        }
    }

    public void testReproject() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<GetCoverage version=\"1.0.0\" service=\"WCS\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wcs\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" xsi:schemaLocation=\"http://www.opengis.net/wcs http://schemas.opengis.net/wcs/1.0.0/getCoverage.xsd\">\n  <sourceCoverage>" + this.getLayerId(MockData.TASMANIA_BM) + "</sourceCoverage>\n" + "  <domainSubset>\n" + "    <spatialSubset>\n" + "      <gml:Envelope srsName=\"EPSG:4326\">\n" + "        <gml:pos>146 -45</gml:pos>\n" + "        <gml:pos>147 42</gml:pos>\n" + "      </gml:Envelope>\n" + "      <gml:Grid dimension=\"2\">\n" + "        <gml:limits>\n" + "          <gml:GridEnvelope>\n" + "            <gml:low>0 0</gml:low>\n" + "            <gml:high>150 150</gml:high>\n" + "          </gml:GridEnvelope>\n" + "        </gml:limits>\n" + "        <gml:axisName>x</gml:axisName>\n" + "        <gml:axisName>y</gml:axisName>\n" + "      </gml:Grid>\n" + "    </spatialSubset>\n" + "  </domainSubset>\n" + "  <output>\n" + "    <crs>EPSG:3857</crs>\n" + "    <format>image/geotiff</format>\n" + "  </output>\n" + "</GetCoverage>";
        MockHttpServletResponse response = this.postAsServletResponse("wcs", xml);
        GetCoverageTest.assertEquals((String)"image/tiff;subtype=\"geotiff\"", (String)response.getContentType());
        GeoTiffFormat format = new GeoTiffFormat();
        GeoTiffReader reader = format.getReader((Object)this.getBinaryInputStream(response));
        GetCoverageTest.assertEquals((Object)CRS.decode((String)"EPSG:3857"), (Object)reader.getOriginalEnvelope().getCoordinateReferenceSystem());
    }

    private void setInputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxInputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    private void setOutputLimit(int kbytes) {
        GeoServer gs = this.getGeoServer();
        WCSInfo info = (WCSInfo)gs.getService(WCSInfo.class);
        info.setMaxOutputMemory((long)kbytes);
        gs.save((ServiceInfo)info);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GetCoverageTest.suite());
    }
}

