/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wcs10.CapabilitiesSectionType;
import net.opengis.wcs10.GetCapabilitiesType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.GeoTools;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Wcs10CapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)Wcs10CapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs";
    protected static final String CUR_VERSION = "1.0.0";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private GeoServer geoServer;
    private WCSInfo wcs;
    private Catalog catalog;
    private final boolean skipMisconfigured;

    public Wcs10CapsTransformer(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.wcs = (WCSInfo)geoServer.getService(WCSInfo.class);
        this.catalog = geoServer.getCatalog();
        this.setNamespaceDeclarationEnabled(false);
        this.skipMisconfigured = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)geoServer.getGlobal().getResourceErrorHandling());
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS100CapsTranslator(handler);
    }

    private class WCS100CapsTranslator
    extends TransformerBase.TranslatorSupport {
        public static final String SCHEMAS = "schemas";
        private GetCapabilitiesType request;

        public WCS100CapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            CapabilitiesSectionType section;
            boolean allSections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (GetCapabilitiesType)o;
            long updateSequence = Wcs10CapsTransformer.this.wcs.getGeoServer().getGlobal().getUpdateSequence();
            long requestedUpdateSequence = -1L;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Long.parseLong(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    if (this.request.getUpdateSequence().length() == 0) {
                        requestedUpdateSequence = 0L;
                    }
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence == updateSequence) {
                    throw new WcsException("WCS capabilities document is current (updateSequence = " + updateSequence + ")", WcsException.WcsExceptionCode.CurrentUpdateSequence, "");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", Wcs10CapsTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(Wcs10CapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", Wcs10CapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(Wcs10CapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            String locationDef = "http://www.opengis.net/wcs " + ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{SCHEMAS, "wcs/1.0.0/wcsCapabilities.xsd"}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.start("wcs:WCS_Capabilities", attributes);
            if (this.request.getSection() == null) {
                allSections = true;
                section = CapabilitiesSectionType.get((String)"/");
            } else {
                section = this.request.getSection();
                allSections = CapabilitiesSectionType.get((String)"/").equals(section);
            }
            HashSet<String> knownSections = new HashSet<String>(Arrays.asList("/", "/WCS_Capabilities/Service", "/WCS_Capabilities/Capability", "/WCS_Capabilities/ContentMetadata"));
            if (!knownSections.contains(section.getLiteral())) {
                throw new WcsException("Unknown section " + section, WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
            }
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_SERVICE_LITERAL)) {
                    this.handleService(allSections);
                }
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_CAPABILITY_LITERAL)) {
                    this.handleCapabilities(allSections);
                }
                if (allSections || section.equals(CapabilitiesSectionType.WCS_CAPABILITIES_CONTENT_METADATA_LITERAL)) {
                    this.handleContentMetadata(allSections);
                }
            }
            this.end("wcs:WCS_Capabilities");
        }

        private void handleService(boolean allSections) {
            AttributesImpl attributes = new AttributesImpl();
            if (!allSections) {
                attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            }
            this.start("wcs:Service", attributes);
            this.handleMetadataLink(Wcs10CapsTransformer.this.wcs.getMetadataLink());
            this.element("wcs:description", Wcs10CapsTransformer.this.wcs.getAbstract());
            this.element("wcs:name", Wcs10CapsTransformer.this.wcs.getName());
            this.element("wcs:label", Wcs10CapsTransformer.this.wcs.getTitle());
            this.handleKeywords(Wcs10CapsTransformer.this.wcs.getKeywords());
            this.handleContact();
            String fees = Wcs10CapsTransformer.this.wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("wcs:fees", fees);
            String accessConstraints = Wcs10CapsTransformer.this.wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("wcs:accessConstraints", accessConstraints);
            this.end("wcs:Service");
        }

        private void handleMetadataLink(MetadataLinkInfo mdl) {
            if (mdl != null) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
                }
                if (attributes.getLength() > 0) {
                    this.start("wcs:metadataLink", attributes);
                    this.end("wcs:metadataLink");
                }
            }
        }

        private void handleKeywords(List kwords) {
            this.start("wcs:keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("wcs:keyword", it.next().toString());
                }
            }
            this.end("wcs:keywords");
        }

        private void handleContact() {
            GeoServer gs = Wcs10CapsTransformer.this.wcs.getGeoServer();
            String tmp = "";
            if (gs.getGlobal().getContact() != null && gs.getGlobal().getContact().getContactPerson() != "" || gs.getGlobal().getContact().getContactOrganization() != null && gs.getGlobal().getContact().getContactOrganization() != "") {
                this.start("wcs:responsibleParty");
                tmp = gs.getGlobal().getContact().getContactPerson();
                if (tmp != null && tmp != "") {
                    this.element("wcs:individualName", tmp);
                } else {
                    this.element("wcs:individualName", "");
                }
                tmp = gs.getGlobal().getContact().getContactOrganization();
                if (tmp != null && tmp != "") {
                    this.element("wcs:organisationName", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getContactPosition()) != null && tmp != "") {
                    this.element("wcs:positionName", tmp);
                }
                this.start("wcs:contactInfo");
                this.start("wcs:phone");
                tmp = gs.getGlobal().getContact().getContactVoice();
                if (tmp != null && tmp != "") {
                    this.element("wcs:voice", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getContactFacsimile()) != null && tmp != "") {
                    this.element("wcs:facsimile", tmp);
                }
                this.end("wcs:phone");
                this.start("wcs:address");
                tmp = gs.getGlobal().getContact().getAddressType();
                if (tmp != null && tmp != "") {
                    String addr = "";
                    addr = gs.getGlobal().getContact().getAddress();
                    if (addr != null && addr != "") {
                        this.element("wcs:deliveryPoint", String.valueOf(tmp) + " " + addr);
                    }
                } else {
                    tmp = gs.getGlobal().getContact().getAddress();
                    if (tmp != null && tmp != "") {
                        this.element("wcs:deliveryPoint", tmp);
                    }
                }
                if ((tmp = gs.getGlobal().getContact().getAddressCity()) != null && tmp != "") {
                    this.element("wcs:city", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getAddressState()) != null && tmp != "") {
                    this.element("wcs:administrativeArea", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getAddressPostalCode()) != null && tmp != "") {
                    this.element("wcs:postalCode", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getAddressCountry()) != null && tmp != "") {
                    this.element("wcs:country", tmp);
                }
                if ((tmp = gs.getGlobal().getContact().getContactEmail()) != null && tmp != "") {
                    this.element("wcs:electronicMailAddress", tmp);
                }
                this.end("wcs:address");
                tmp = gs.getGlobal().getContact().getOnlineResource();
                if (tmp != null && tmp != "") {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "xlink:href", "xlink:href", "", tmp);
                    this.start("wcs:onlineResource", attributes);
                    this.end("wcs:onlineResource");
                }
                this.end("wcs:contactInfo");
                this.end("wcs:responsibleParty");
            }
        }

        private void handleCapabilities(boolean allSections) {
            this.start("wcs:Capability");
            this.handleRequest();
            this.handleExceptions();
            this.handleVendorSpecifics();
            this.end("wcs:Capability");
        }

        private void handleRequest() {
            this.start("wcs:Request");
            this.handleCapability("wcs:GetCapabilities");
            this.handleCapability("wcs:DescribeCoverage");
            this.handleCapability("wcs:GetCoverage");
            this.end("wcs:Request");
        }

        private void handleCapability(String capabilityName) {
            AttributesImpl attributes = new AttributesImpl();
            this.start(capabilityName);
            this.start("wcs:DCPType");
            this.start("wcs:HTTP");
            String url = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            attributes.addAttribute("", "xlink:href", "xlink:href", "", String.valueOf(url) + "?");
            this.start("wcs:Get");
            this.start("wcs:OnlineResource", attributes);
            this.end("wcs:OnlineResource");
            this.end("wcs:Get");
            this.end("wcs:HTTP");
            this.end("wcs:DCPType");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", String.valueOf(url) + "?");
            this.start("wcs:DCPType");
            this.start("wcs:HTTP");
            this.start("wcs:Post");
            this.start("wcs:OnlineResource", attributes);
            this.end("wcs:OnlineResource");
            this.end("wcs:Post");
            this.end("wcs:HTTP");
            this.end("wcs:DCPType");
            this.end(capabilityName);
        }

        private void handleExceptions() {
            this.start("wcs:Exception");
            List exceptionFormats = Wcs10CapsTransformer.this.wcs.getExceptionFormats();
            if (exceptionFormats == null || exceptionFormats.isEmpty()) {
                exceptionFormats.add("application/vnd.ogc.se_xml");
            }
            for (String format : exceptionFormats) {
                this.element("wcs:Format", format);
            }
            this.end("wcs:Exception");
        }

        private void handleVendorSpecifics() {
        }

        private void handleEnvelope(ReferencedEnvelope referencedEnvelope, String timeMetadata) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "srsName", "srsName", "", "urn:ogc:def:crs:OGC:1.3:CRS84");
            this.start("wcs:lonLatEnvelope", attributes);
            StringBuffer minCP = new StringBuffer(Double.toString(referencedEnvelope.getMinX())).append(" ").append(referencedEnvelope.getMinY());
            StringBuffer maxCP = new StringBuffer(Double.toString(referencedEnvelope.getMaxX())).append(" ").append(referencedEnvelope.getMaxY());
            this.element("gml:pos", minCP.toString());
            this.element("gml:pos", maxCP.toString());
            if (timeMetadata != null && timeMetadata.length() > 0) {
                String[] timePositions = this.orderTimeArray(timeMetadata.split(","));
                this.element("gml:timePosition", timePositions[0]);
                this.element("gml:timePosition", timePositions[timePositions.length - 1]);
            }
            this.end("wcs:lonLatEnvelope");
        }

        private String[] orderDoubleArray(String[] originalArray) {
            List<String> finalArray = Arrays.asList(originalArray);
            Collections.sort(finalArray, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    return Double.parseDouble(o1) > Double.parseDouble(o2) ? 1 : -1;
                }
            });
            return finalArray.toArray(new String[1]);
        }

        private String[] orderTimeArray(String[] originalArray) {
            List<String> finalArray = Arrays.asList(originalArray);
            Collections.sort(finalArray, new Comparator<String>(){
                final String[] PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:sss'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd'T'HH'Z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};

                @Override
                public int compare(String o1, String o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    Date d1 = this.getDate(o1);
                    Date d2 = this.getDate(o2);
                    if (d1 == null || d2 == null) {
                        return 0;
                    }
                    return d1.getTime() > d2.getTime() ? 1 : -1;
                }

                private Date getDate(String value) {
                    if (value.equalsIgnoreCase("current")) {
                        return null;
                    }
                    int i = 0;
                    while (i < this.PATTERNS.length) {
                        SimpleDateFormat format = new SimpleDateFormat(this.PATTERNS[i], Locale.CANADA);
                        ParsePosition pos = new ParsePosition(0);
                        Date time = format.parse(value, pos);
                        if (pos.getIndex() == value.length()) {
                            return time;
                        }
                        ++i;
                    }
                    return null;
                }
            });
            return finalArray.toArray(new String[1]);
        }

        private void handleMetadataLink(MetadataLinkInfo mdl, String linkType) {
            if (mdl != null) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
                }
                if (attributes.getLength() > 0) {
                    this.element("ows:Metadata", null, attributes);
                }
            }
        }

        private void handleContentMetadata(boolean allSections) {
            AttributesImpl attributes = new AttributesImpl();
            if (!allSections) {
                attributes.addAttribute("", "version", "version", "", Wcs10CapsTransformer.CUR_VERSION);
            }
            this.start("wcs:ContentMetadata", attributes);
            List coverages = Wcs10CapsTransformer.this.catalog.getCoverages();
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            for (CoverageInfo cvInfo : coverages) {
                try {
                    this.mark();
                    this.handleCoverageOfferingBrief(cvInfo);
                    this.commit();
                }
                catch (Exception e) {
                    if (Wcs10CapsTransformer.this.skipMisconfigured) {
                        this.reset();
                        LOGGER.log(Level.SEVERE, "Skipping coverage: " + cvInfo.getPrefixedName() + " as its capabilities generation failed", e);
                        continue;
                    }
                    throw new RuntimeException("Capabilities document generation failed on coverage " + cvInfo.getPrefixedName(), e);
                }
            }
            this.end("wcs:ContentMetadata");
        }

        private void handleCoverageOfferingBrief(CoverageInfo cv) {
            if (cv.isEnabled()) {
                this.start("wcs:CoverageOfferingBrief");
                for (MetadataLinkInfo mdl : cv.getMetadataLinks()) {
                    this.handleMetadataLink(mdl);
                }
                String tmp = cv.getDescription();
                if (tmp != null && tmp != "") {
                    this.element("wcs:description", tmp);
                }
                if ((tmp = cv.getPrefixedName()) != null && tmp != "") {
                    this.element("wcs:name", tmp);
                }
                if ((tmp = cv.getTitle()) != null && tmp != "") {
                    this.element("wcs:label", tmp);
                }
                String timeMetadata = null;
                CoverageStoreInfo csinfo = cv.getStore();
                if (csinfo == null) {
                    throw new WcsException("Unable to acquire coverage store resource for coverage: " + cv.getName());
                }
                AbstractGridCoverage2DReader reader = null;
                try {
                    reader = (AbstractGridCoverage2DReader)Wcs10CapsTransformer.this.catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
                }
                catch (IOException e) {
                    LOGGER.severe("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                if (reader == null) {
                    throw new WcsException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
                }
                String[] metadataNames = reader.getMetadataNames();
                if (metadataNames != null && metadataNames.length > 0) {
                    timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
                }
                this.handleEnvelope(cv.getLatLonBoundingBox(), timeMetadata);
                this.handleKeywords(cv.getKeywords());
                this.end("wcs:CoverageOfferingBrief");
            }
        }

        private void elementIfNotEmpty(String elementName, String content) {
            if (content != null && !"".equals(content.trim())) {
                this.element(elementName, content);
            }
        }
    }
}

