/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.opengis.wcs10.GetCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.factory.Hints;
import org.opengis.coverage.grid.GridCoverage;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;

public class Wcs10GetCoverageResponse
extends Response {
    private static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final Hints hints = new Hints(new HashMap(5));
    Catalog catalog;
    CoverageResponseDelegate delegate;

    static {
        hints.add((RenderingHints)LENIENT_HINT);
    }

    public Wcs10GetCoverageResponse(Catalog catalog) {
        super(GridCoverage[].class);
        this.catalog = catalog;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            throw new WcsException("Cannot handle object of type: " + operation.getParameters()[0].getClass());
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = getCoverage.getOutput().getFormat().getValue();
        if (this.delegate == null) {
            this.delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        }
        if (this.delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        return this.delegate.getMimeFormatFor(outputFormat);
    }

    public boolean canHandle(Operation operation) {
        if (!(operation.getParameters()[0] instanceof GetCoverageType)) {
            return false;
        }
        GetCoverageType getCoverage = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = getCoverage.getOutput().getFormat().getValue();
        if (this.delegate == null) {
            this.delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        }
        if (this.delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        return this.delegate.canProduce(outputFormat);
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        GridCoverage[] coverages = (GridCoverage[])value;
        GetCoverageType request = (GetCoverageType)operation.getParameters()[0];
        String outputFormat = request.getOutput().getFormat().getValue();
        if (this.delegate == null) {
            this.delegate = CoverageResponseDelegateFactory.encoderFor((String)outputFormat);
        }
        if (this.delegate == null) {
            throw new WcsException("Could not find encoder for output format " + outputFormat);
        }
        GridCoverage2D coverage = (GridCoverage2D)coverages[0];
        this.delegate.prepare(outputFormat, coverage);
        this.delegate.encode(output);
        output.flush();
    }
}

