/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import java.io.StringReader;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.Ows11Factory;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.RangeSubsetType;
import net.opengis.wcs11.Wcs111Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.wcs.kvp.InterpolationMethod;
import org.geoserver.wcs.kvp.rangesubset.ASTAxisId;
import org.geoserver.wcs.kvp.rangesubset.ASTAxisSubset;
import org.geoserver.wcs.kvp.rangesubset.ASTFieldId;
import org.geoserver.wcs.kvp.rangesubset.ASTFieldSubset;
import org.geoserver.wcs.kvp.rangesubset.ASTInterpolation;
import org.geoserver.wcs.kvp.rangesubset.ASTKey;
import org.geoserver.wcs.kvp.rangesubset.ASTRangeSubset;
import org.geoserver.wcs.kvp.rangesubset.Node;
import org.geoserver.wcs.kvp.rangesubset.RangeSubsetParser;
import org.geoserver.wcs.kvp.rangesubset.RangeSubsetParserVisitor;
import org.geoserver.wcs.kvp.rangesubset.SimpleNode;
import org.vfny.geoserver.wcs.WcsException;

public class RangeSubsetKvpParser
extends KvpParser {
    public RangeSubsetKvpParser() {
        super("RangeSubset", RangeSubsetType.class);
    }

    public Object parse(String value) throws Exception {
        RangeSubsetParser parser = new RangeSubsetParser(new StringReader(value));
        SimpleNode root = parser.RangeSubset();
        RangeSubsetType result = (RangeSubsetType)root.jjtAccept(new RangeSubsetKvpParserVisitor(), null);
        for (FieldSubsetType type : result.getFieldSubset()) {
            String interpolationType = type.getInterpolationType();
            if (interpolationType == null) continue;
            try {
                InterpolationMethod interpolationMethod = InterpolationMethod.valueOf(interpolationType);
            }
            catch (IllegalArgumentException e) {
                throw new WcsException("Unknown interpolation method " + interpolationType, WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
        return result;
    }

    private static class RangeSubsetKvpParserVisitor
    implements RangeSubsetParserVisitor {
        Wcs111Factory wcsf = Wcs111Factory.eINSTANCE;
        Ows11Factory owsf = Ows11Factory.eINSTANCE;

        private RangeSubsetKvpParserVisitor() {
        }

        public Object visit(SimpleNode node, Object data) {
            throw new UnsupportedOperationException("This method should never be reached");
        }

        public Object visit(ASTRangeSubset node, Object data) {
            RangeSubsetType rs = this.wcsf.createRangeSubsetType();
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                ASTFieldSubset fs = (ASTFieldSubset)node.jjtGetChild(i);
                FieldSubsetType fst = (FieldSubsetType)fs.jjtAccept(this, data);
                rs.getFieldSubset().add((Object)fst);
                ++i;
            }
            return rs;
        }

        public Object visit(ASTFieldSubset node, Object data) {
            FieldSubsetType fs = this.wcsf.createFieldSubsetType();
            int i = 0;
            while (i < node.jjtGetNumChildren()) {
                Node child = node.jjtGetChild(i);
                if (child instanceof ASTFieldId) {
                    CodeType id = this.owsf.createCodeType();
                    id.setValue((String)child.jjtAccept(this, null));
                    fs.setIdentifier(id);
                } else if (child instanceof ASTInterpolation) {
                    fs.setInterpolationType((String)child.jjtAccept(this, null));
                } else if (child instanceof ASTAxisSubset) {
                    fs.getAxisSubset().add(child.jjtAccept(this, null));
                }
                ++i;
            }
            return fs;
        }

        public Object visit(ASTAxisSubset node, Object data) {
            AxisSubsetType as = this.wcsf.createAxisSubsetType();
            as.setIdentifier(((SimpleNode)node.jjtGetChild(0)).getContent());
            int i = 1;
            while (i < node.jjtGetNumChildren()) {
                as.getKey().add(node.jjtGetChild(i).jjtAccept(this, null));
                ++i;
            }
            return as;
        }

        public Object visit(ASTFieldId node, Object data) {
            return node.getContent();
        }

        public Object visit(ASTAxisId node, Object data) {
            return node.getContent();
        }

        public Object visit(ASTInterpolation node, Object data) {
            return node.getContent();
        }

        public Object visit(ASTKey node, Object data) {
            return node.getContent();
        }
    }
}

