/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wcs11.DescribeCoverageType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.kvp.GridType;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.vfny.geoserver.wcs.WcsException;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegateFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeCoverageTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)DescribeCoverageTransformer.class.getPackage().getName());
    private static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Map<String, String> METHOD_NAME_MAP = new HashMap<String, String>();
    private WCSInfo wcs;
    private Catalog catalog;

    public DescribeCoverageTransformer(WCSInfo wcs, Catalog catalog) {
        this.wcs = wcs;
        this.catalog = catalog;
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS111DescribeCoverageTranslator(handler);
    }

    static {
        METHOD_NAME_MAP.put("nearest neighbor", "nearest");
        METHOD_NAME_MAP.put("bilinear", "linear");
        METHOD_NAME_MAP.put("bicubic", "cubic");
    }

    private class WCS111DescribeCoverageTranslator
    extends TransformerBase.TranslatorSupport {
        private DescribeCoverageType request;
        private String proxifiedBaseUrl;

        public WCS111DescribeCoverageTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof DescribeCoverageType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (DescribeCoverageType)o;
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", DescribeCoverageTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(DescribeCoverageTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", DescribeCoverageTransformer.XSI_URI);
            String locationAtt = new StringBuffer(DescribeCoverageTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            String locationDef = ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wcs/1.1.1/wcsDescribeCoverage.xsd");
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            this.start("wcs:CoverageDescriptions", attributes);
            for (String coverageId : this.request.getIdentifier()) {
                LayerInfo layer = DescribeCoverageTransformer.this.catalog.getLayerByName(coverageId);
                if (layer == null || layer.getType() != LayerInfo.Type.RASTER) {
                    throw new WcsException("Could not find the specified coverage: " + coverageId, WcsException.WcsExceptionCode.InvalidParameterValue, "identifiers");
                }
                CoverageInfo ci = DescribeCoverageTransformer.this.catalog.getCoverageByName(coverageId);
                try {
                    this.handleCoverageDescription(ci);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error occurred during describe coverage xml encoding", e);
                }
            }
            this.end("wcs:CoverageDescriptions");
        }

        void handleCoverageDescription(CoverageInfo ci) throws Exception {
            this.start("wcs:CoverageDescription");
            this.element("ows:Title", ci.getTitle());
            this.element("ows:Abstract", ci.getDescription());
            this.handleKeywords(ci.getKeywords());
            this.element("wcs:Identifier", ci.getStore().getWorkspace().getName() + ":" + ci.getName());
            this.handleMetadataLinks(ci.getMetadataLinks(), "simple");
            this.handleDomain(ci);
            this.handleRange(ci);
            this.handleSupportedCRSs(ci);
            this.handleSupportedFormats(ci);
            this.end("wcs:CoverageDescription");
        }

        private void handleMetadataLinks(List<MetadataLinkInfo> links, String linkType) {
            for (MetadataLinkInfo mdl : links) {
                if (mdl == null) continue;
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
                }
                if (attributes.getLength() <= 0) continue;
                this.element("ows:Metadata", null, attributes);
            }
        }

        private void handleKeywords(List kwords) {
            this.start("ows:Keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("ows:Keyword", it.next().toString());
                }
            }
            this.end("ows:Keywords");
        }

        private void handleDomain(CoverageInfo ci) throws Exception {
            this.start("wcs:Domain");
            this.start("wcs:SpatialDomain");
            this.handleBoundingBox(ci.getLatLonBoundingBox(), true);
            this.handleBoundingBox(ci.boundingBox(), false);
            this.handleGridCRS(ci);
            this.end("wcs:SpatialDomain");
            this.end("wcs:Domain");
        }

        private void handleGridCRS(CoverageInfo ci) throws Exception {
            this.start("wcs:GridCRS");
            this.element("wcs:GridBaseCRS", this.urnIdentifier(ci.getCRS()));
            this.element("wcs:GridType", GridType.GT2dGridIn2dCrs.getXmlConstant());
            LinearTransform tx = (LinearTransform)ci.getGrid().getGridToCRS();
            Matrix matrix = tx.getMatrix();
            StringBuffer origins = new StringBuffer();
            for (int i = 0; i < matrix.getNumRow() - 1; ++i) {
                origins.append(matrix.getElement(i, matrix.getNumCol() - 1));
                if (i >= matrix.getNumRow() - 2) continue;
                origins.append(" ");
            }
            this.element("wcs:GridOrigin", origins.toString());
            StringBuffer offsets = new StringBuffer();
            for (int i = 0; i < matrix.getNumRow() - 1; ++i) {
                for (int j = 0; j < matrix.getNumCol() - 1; ++j) {
                    offsets.append(matrix.getElement(i, j));
                    if (j >= matrix.getNumCol() - 2) continue;
                    offsets.append(" ");
                }
                if (i >= matrix.getNumRow() - 2) continue;
                offsets.append(" ");
            }
            this.element("wcs:GridOffsets", offsets.toString());
            this.element("wcs:GridCS", "urn:ogc:def:cs:OGC:0.0:Grid2dSquareCS");
            this.end("wcs:GridCRS");
        }

        private void handleBoundingBox(ReferencedEnvelope encodedEnvelope, boolean wgsLonLat) throws Exception {
            AttributesImpl attributes = new AttributesImpl();
            CoordinateReferenceSystem crs = encodedEnvelope.getCoordinateReferenceSystem();
            if (wgsLonLat) {
                attributes.addAttribute("", "crs", "crs", "", "urn:ogc:def:crs:OGC:1.3:CRS84");
            } else {
                String urnIdentifier = this.urnIdentifier(crs);
                CoordinateReferenceSystem latlonCrs = CRS.decode((String)urnIdentifier);
                encodedEnvelope = new ReferencedEnvelope((Envelope)CRS.transform((MathTransform)CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)latlonCrs, (boolean)true), (Envelope)encodedEnvelope));
                attributes.addAttribute("", "crs", "crs", "", urnIdentifier);
            }
            attributes.addAttribute("", "dimensions", "dimensions", "", Integer.toString(crs.getCoordinateSystem().getDimension()));
            this.start("ows:BoundingBox", attributes);
            this.element("ows:LowerCorner", new StringBuffer(Double.toString(encodedEnvelope.getLowerCorner().getOrdinate(0))).append(" ").append(encodedEnvelope.getLowerCorner().getOrdinate(1)).toString());
            this.element("ows:UpperCorner", new StringBuffer(Double.toString(encodedEnvelope.getUpperCorner().getOrdinate(0))).append(" ").append(encodedEnvelope.getUpperCorner().getOrdinate(1)).toString());
            this.end("ows:BoundingBox");
        }

        private void handleRange(CoverageInfo ci) {
            this.start("wcs:Range");
            this.start("wcs:Field");
            List dimensions = ci.getDimensions();
            this.element("wcs:Identifier", "contents");
            this.start("wcs:Definition");
            NumberRange range = this.getCoverageRange(dimensions);
            if (range == null || range.isEmpty()) {
                this.element("wcs:AnyValue", "");
            } else {
                this.start("ows:AllowedValues");
                this.start("ows:Range");
                this.element("ows:MinimumValue", Double.toString(range.getMinimum()));
                this.element("ows:MaximumValue", Double.toString(range.getMaximum()));
                this.end("ows:Range");
                this.end("ows:AllowedValues");
            }
            this.end("wcs:Definition");
            this.handleNullValues(dimensions);
            this.handleInterpolationMethods(ci);
            this.handleAxis(ci);
            this.end("wcs:Field");
            this.end("wcs:Range");
        }

        private void handleAxis(CoverageInfo ci) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "identifier", "identifier", "", "Bands");
            this.start("wcs:Axis", attributes);
            this.start("wcs:AvailableKeys");
            List dimensions = ci.getDimensions();
            for (CoverageDimensionInfo cd : dimensions) {
                this.element("wcs:Key", cd.getName().replace(' ', '_'));
            }
            this.end("wcs:AvailableKeys");
            this.end("wcs:Axis");
        }

        private NumberRange getCoverageRange(List<CoverageDimensionInfo> dimensions) {
            NumberRange range = null;
            for (CoverageDimensionInfo dimension : dimensions) {
                if (dimension.getRange() == null) {
                    return null;
                }
                if (range == null) {
                    range = dimension.getRange();
                    continue;
                }
                range.union((Range)dimension.getRange());
            }
            return range;
        }

        private void handleNullValues(List<CoverageDimensionInfo> dimensions) {
            for (CoverageDimensionInfo cd : dimensions) {
                List nulls = cd.getNullValues();
                if (nulls == null) {
                    return;
                }
                if (nulls.size() == 1) {
                    this.element("wcs:NullValue", ((Double)nulls.get(0)).toString());
                    continue;
                }
                if (nulls.size() < 1) continue;
                throw new IllegalArgumentException("Cannot encode a range of null values, only single values are handled");
            }
        }

        private void handleInterpolationMethods(CoverageInfo ci) {
            this.start("wcs:InterpolationMethods");
            for (String method : ci.getInterpolationMethods()) {
                String converted = (String)METHOD_NAME_MAP.get(method);
                if (converted == null) continue;
                this.element("wcs:InterpolationMethod", converted);
            }
            this.elementIfNotEmpty("wcs:Default", ci.getDefaultInterpolationMethod());
            this.end("wcs:InterpolationMethods");
        }

        private void handleSupportedFormats(CoverageInfo ci) throws Exception {
            HashSet<String> formats = new HashSet<String>();
            for (String format : ci.getSupportedFormats()) {
                try {
                    CoverageResponseDelegate delegate = CoverageResponseDelegateFactory.encoderFor((String)format);
                    String formatMime = delegate.getMimeFormatFor(format);
                    if (formatMime == null) continue;
                    formats.add(formatMime);
                }
                catch (Exception e) {}
            }
            ArrayList sortedFormats = new ArrayList(formats);
            Collections.sort(sortedFormats);
            for (String format : sortedFormats) {
                this.element("wcs:SupportedFormat", format);
            }
        }

        private void handleSupportedCRSs(CoverageInfo ci) throws Exception {
            LinkedHashSet supportedCRSs = new LinkedHashSet();
            if (ci.getRequestSRS() != null) {
                supportedCRSs.addAll(ci.getRequestSRS());
            }
            if (ci.getResponseSRS() != null) {
                supportedCRSs.addAll(ci.getResponseSRS());
            }
            for (String crsName : supportedCRSs) {
                CoordinateReferenceSystem crs = CRS.decode((String)crsName);
                this.element("wcs:SupportedCRS", this.urnIdentifier(crs));
                this.element("wcs:SupportedCRS", crsName);
            }
        }

        private String urnIdentifier(CoordinateReferenceSystem crs) throws FactoryException {
            String authorityAndCode = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            String code = authorityAndCode.substring(authorityAndCode.lastIndexOf(":") + 1);
            return "urn:ogc:def:crs:EPSG::" + code;
        }

        private void elementIfNotEmpty(String elementName, String content) {
            if (content != null && !"".equals(content.trim())) {
                this.element(elementName, content);
            }
        }
    }
}

