/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wicket.test;

import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketServlet;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerResourceStreamLocator;
import org.geoserver.web.GeoServerStringResourceLoader;
import org.geoserver.wicket.test.IComponentFactory;
import org.geoserver.wicket.test.TestHomePage;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketTestApplication
extends WebApplication {
    static String wtapath = WicketTestApplication.class.getPackage().getName().replaceAll("\\.", "/");
    static String gsapath = GeoServerApplication.class.getPackage().getName().replaceAll("\\.", "/");

    static {
        wtapath = String.valueOf(wtapath) + "/" + WicketTestApplication.class.getSimpleName();
        gsapath = String.valueOf(gsapath) + "/" + GeoServerApplication.class.getSimpleName();
    }

    protected void init() {
        this.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new GeoServerResourceStreamLocator());
        this.getResourceSettings().addStringResourceLoader((IStringResourceLoader)new GeoServerStringResourceLoader());
        this.getResourceSettings().addStringResourceLoader((IStringResourceLoader)new ComponentStringResourceLoader());
        this.getResourceSettings().addStringResourceLoader((IStringResourceLoader)new ClassStringResourceLoader(((Object)((Object)this)).getClass()));
        this.getResourceSettings().setPropertiesFactory((IPropertiesFactory)new PropertiesFactory((Application)this){

            public Properties load(Class clazz, String path) {
                if (clazz == WicketTestApplication.class && path.startsWith(wtapath)) {
                    String newPath = path.replace(wtapath, gsapath);
                    return super.load(GeoServerApplication.class, newPath);
                }
                return super.load(clazz, path);
            }
        });
    }

    public Class<?> getHomePage() {
        return TestHomePage.class;
    }

    public static void start(IComponentFactory factory) {
        WicketTestApplication.start(factory, "/", 8080);
    }

    public static void start(IComponentFactory factory, String contextPath, int port) {
        if (factory == null) {
            throw new NullPointerException("You must provide a non null component factory");
        }
        TestHomePage.componentFactory = factory;
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setMaxIdleTime(3600000);
        connector.setSoLingerTime(-1);
        connector.setPort(port);
        server.setConnectors(new Connector[]{connector});
        Context root = new Context((HandlerContainer)server, contextPath, 1);
        ServletHolder wicket = new ServletHolder(WicketServlet.class);
        wicket.setInitParameter("applicationClassName", WicketTestApplication.class.getName());
        root.addServlet(wicket, "/*");
        try {
            System.out.println(">>> STARTING EMBEDDED JETTY SERVER, PRESS ANY KEY TO STOP");
            server.start();
            while (System.in.available() == 0) {
                Thread.sleep(1000L);
            }
            server.stop();
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(100);
        }
    }
}

