/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.DemoRequestsPage;
import org.geotools.test.TestData;

public class DemoRequestsPageTest
extends GeoServerWicketTestSupport {
    private File demoDir;

    protected void setUpInternal() throws Exception {
        this.demoDir = TestData.file((Object)((Object)this), (String)"demo-requests");
        tester.startPage((Page)new DemoRequestsPage(this.demoDir));
    }

    public void testStructure() {
        DemoRequestsPageTest.assertTrue((boolean)(tester.getLastRenderedPage() instanceof DemoRequestsPage));
        tester.assertComponent("demoRequestsForm", Form.class);
        tester.assertComponent("demoRequestsForm:demoRequestsList", DropDownChoice.class);
        tester.assertComponent("demoRequestsForm:url", TextField.class);
        tester.assertComponent("demoRequestsForm:body", TextArea.class);
        tester.assertComponent("demoRequestsForm:username", TextField.class);
        tester.assertComponent("demoRequestsForm:password", PasswordTextField.class);
        tester.assertComponent("demoRequestsForm:submit", AjaxSubmitLink.class);
        tester.assertComponent("responseWindow", ModalWindow.class);
    }

    public void testDemoListLoaded() {
        List<String> expectedList = Arrays.asList("WFS_getFeature-1.1.xml", "WMS_describeLayer.url");
        DropDownChoice dropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("demoRequestsForm:demoRequestsList");
        List choices = dropDown.getChoices();
        DemoRequestsPageTest.assertEquals(expectedList, (Object)choices);
    }

    public void testUrlLinkUnmodified() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        String requestName = "WMS_describeLayer.url";
        requestFormTester.select("demoRequestsList", 1);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "onchange");
        tester.assertModelValue("demoRequestsForm:demoRequestsList", (Object)"WMS_describeLayer.url");
        boolean isAjax = true;
        tester.clickLink("demoRequestsForm:submit", true);
        tester.assertVisible("responseWindow");
        IModel model = tester.getLastRenderedPage().getModel();
        DemoRequestsPageTest.assertTrue((boolean)(model.getObject() instanceof DemoRequestsPage.DemoRequest));
        DemoRequestsPage.DemoRequest req = (DemoRequestsPage.DemoRequest)model.getObject();
        DemoRequestsPageTest.assertEquals((Object)this.demoDir, (Object)req.getDemoDir());
        String requestFileName = req.getRequestFileName();
        String requestUrl = req.getRequestUrl();
        String requestBody = req.getRequestBody();
        DemoRequestsPageTest.assertEquals((String)"WMS_describeLayer.url", (String)requestFileName);
        DemoRequestsPageTest.assertNotNull((Object)requestUrl);
        DemoRequestsPageTest.assertNull((Object)requestBody);
    }

    public void testUrlLinkSelected() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        String requestName = "WMS_describeLayer.url";
        requestFormTester.select("demoRequestsList", 1);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "onchange");
        tester.assertModelValue("demoRequestsForm:demoRequestsList", (Object)"WMS_describeLayer.url");
        boolean isAjax = true;
        tester.clickLink("demoRequestsForm:submit", true);
        tester.assertVisible("responseWindow");
        IModel model = tester.getLastRenderedPage().getModel();
        DemoRequestsPageTest.assertTrue((boolean)(model.getObject() instanceof DemoRequestsPage.DemoRequest));
        DemoRequestsPage.DemoRequest req = (DemoRequestsPage.DemoRequest)model.getObject();
        DemoRequestsPageTest.assertEquals((Object)this.demoDir, (Object)req.getDemoDir());
        String requestFileName = req.getRequestFileName();
        String requestUrl = req.getRequestUrl();
        String requestBody = req.getRequestBody();
        DemoRequestsPageTest.assertEquals((String)"WMS_describeLayer.url", (String)requestFileName);
        DemoRequestsPageTest.assertNotNull((Object)requestUrl);
        DemoRequestsPageTest.assertNull((Object)requestBody);
    }

    public void testUrlLinkModified() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        String requestName = "WMS_describeLayer.url";
        requestFormTester.select("demoRequestsList", 1);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "onchange");
        tester.assertModelValue("demoRequestsForm:demoRequestsList", (Object)"WMS_describeLayer.url");
        String modifiedUrl = "http://modified/url";
        TextField url = (TextField)tester.getComponentFromLastRenderedPage("demoRequestsForm:url");
        url.setModelValue(new String[]{"http://modified/url"});
        DemoRequestsPageTest.assertEquals((String)"http://modified/url", (String)url.getValue());
        boolean isAjax = true;
        tester.clickLink("demoRequestsForm:submit", true);
        tester.assertVisible("responseWindow");
        IModel model = tester.getLastRenderedPage().getModel();
        DemoRequestsPageTest.assertTrue((boolean)(model.getObject() instanceof DemoRequestsPage.DemoRequest));
        DemoRequestsPage.DemoRequest req = (DemoRequestsPage.DemoRequest)model.getObject();
        String requestUrl = req.getRequestUrl();
        DemoRequestsPageTest.assertEquals((String)"http://modified/url", (String)requestUrl);
    }
}

