/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusBar
extends Panel {
    private static final long serialVersionUID = 1L;

    public StatusBar(String id, IModel<Number> limitModel, IModel<Number> progressModel, IModel<String> progressMessageModel) {
        super(id);
        int usedPercentage;
        int excessPercentage;
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{HeaderContributor.forCss(StatusBar.class, (String)"statusbar.css")});
        WebMarkupContainer usageBar = new WebMarkupContainer("statusBarProgress");
        WebMarkupContainer excessBar = new WebMarkupContainer("statusBarExcess");
        double limit = ((Number)limitModel.getObject()).doubleValue();
        double used = ((Number)progressModel.getObject()).doubleValue();
        double excess = used - limit;
        int progressWidth = 200;
        if (excess > 0.0) {
            excessPercentage = (int)Math.round(excess * 200.0 / used);
            usedPercentage = 200 - excessPercentage;
        } else {
            usedPercentage = (int)Math.round(used * 200.0 / limit);
            excessPercentage = 0;
        }
        usageBar.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)("width: " + usedPercentage + "px; left: 5px; border-left: inherit;"))))});
        String redStyle = "width: " + excessPercentage + "px; left: " + (5 + usedPercentage) + "px;";
        excessBar.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)redStyle)))});
        this.add(new Component[]{usageBar});
        this.add(new Component[]{excessBar});
        this.add(new Component[]{new Label("progressLabel", progressMessageModel)});
    }
}

