/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.gwc.web.CachedLayerInfo;
import org.geoserver.gwc.web.CachedLayerProvider;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geowebcache.diskquota.storage.Quota;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedLayersPage
extends GeoServerSecuredPage {
    private CachedLayerProvider provider = new CachedLayerProvider();
    private GeoServerTablePanel<CachedLayerInfo> table;
    private GeoServerDialog dialog;
    private CachedLayerSelectionRemovalLink removal;

    public CachedLayersPage() {
        final GWCIconFactory icons = GWCIconFactory.get();
        this.table = new GeoServerTablePanel<CachedLayerInfo>("table", (GeoServerDataProvider)this.provider, true){
            private static final long serialVersionUID = 1L;

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<CachedLayerInfo> property) {
                if (property == CachedLayerProvider.TYPE) {
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                    CachedLayerInfo layerInfo = (CachedLayerInfo)itemModel.getObject();
                    CachedLayerInfo.TYPE type = layerInfo.getType();
                    ResourceReference layerIcon = icons.getSpecificLayerIcon(type);
                    f.add(new Component[]{new Image("layerIcon", layerIcon)});
                    return f;
                }
                if (property == CachedLayerProvider.NAME) {
                    return CachedLayersPage.this.cachedLayerLink(id, (IModel<CachedLayerInfo>)itemModel);
                }
                if (property == CachedLayerProvider.QUOTA_LIMIT) {
                    IModel quotaLimitModel = property.getModel(itemModel);
                    return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaLimitModel);
                }
                if (property == CachedLayerProvider.QUOTA_USAGE) {
                    IModel quotaUsageModel = property.getModel(itemModel);
                    return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaUsageModel);
                }
                if (property == CachedLayerProvider.ENABLED) {
                    CachedLayerInfo layerInfo = (CachedLayerInfo)itemModel.getObject();
                    boolean enabled = layerInfo.isEnabled();
                    ResourceReference icon = enabled ? icons.getEnabledIcon() : (layerInfo.getConfigErrorMessage() != null ? icons.getErrorIcon() : icons.getDisabledIcon());
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                    f.add(new Component[]{new Image("layerIcon", icon)});
                    return f;
                }
                throw new IllegalArgumentException("Don't know a property named " + property.getName());
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                CachedLayersPage.this.removal.setEnabled(CachedLayersPage.this.table.getSelection().size() > 0);
                target.addComponent((Component)CachedLayersPage.this.removal);
            }
        };
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.setHeaderPanel(this.headerPanel());
    }

    private Component quotaLink(String id, IModel<Quota> quotaModel) {
        Quota quota = (Quota)quotaModel.getObject();
        String formattedQuota = quota == null ? new ResourceModel("CachedLayersPage.quotaLimitNotSet").getObject() : quota.toNiceString();
        return new Label(id, formattedQuota);
    }

    private Component cachedLayerLink(String id, IModel<CachedLayerInfo> itemModel) {
        IModel nameModel = CachedLayerProvider.NAME.getModel(itemModel);
        String layerName = (String)nameModel.getObject();
        Label link = new Label(id, layerName);
        String configErrorMessage = ((CachedLayerInfo)itemModel.getObject()).getConfigErrorMessage();
        if (configErrorMessage != null) {
            link.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)"text-decoration: line-through; font-style: italic;")))});
            link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)configErrorMessage)))});
        }
        return link;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewLayerPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new CachedLayerSelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        header.setVisible(false);
        return header;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedLayerSelectionRemovalLink
    extends AjaxLink<CachedLayerInfo> {
        private static final long serialVersionUID = 1L;

        public CachedLayerSelectionRemovalLink(String string, GeoServerTablePanel<CachedLayerInfo> table, GeoServerDialog dialog) {
            super(string);
        }

        public void onClick(AjaxRequestTarget target) {
        }
    }
}

