/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.MapModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.web.CachingOptionsPanel;
import org.geoserver.gwc.web.DiskQuotaConfigPanel;
import org.geoserver.gwc.web.GWCServicesPanel;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.storage.StorageUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCSettingsPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger(GWCSettingsPage.class);
    private IModel<Map<String, Serializable>> formModel;

    public GWCSettingsPage() {
        DiskQuotaConfig diskQuotaConfig;
        boolean diskQuotaModuleDisabled;
        this.setHeaderPanel(this.headerPanel());
        GWC gwc = this.getGWC();
        boolean bl = diskQuotaModuleDisabled = gwc.getDiskQuotaConfig() == null;
        if (diskQuotaModuleDisabled) {
            diskQuotaConfig = new DiskQuotaConfig();
            diskQuotaConfig.setDefaults();
        } else {
            diskQuotaConfig = gwc.getDiskQuotaConfig().clone();
        }
        GWCConfig gwcConfig = gwc.getConfig().clone();
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("diskQuotaConfig", diskQuotaConfig);
        formData.put("gwcConfig", gwcConfig);
        this.formModel = new MapModel(formData);
        final Form form = new Form("form", this.formModel);
        this.add(new Component[]{form});
        PropertyModel gwcConfigModel = new PropertyModel(this.formModel, "gwcConfig");
        PropertyModel diskQuotaModel = new PropertyModel(this.formModel, "diskQuotaConfig");
        GWCServicesPanel gwcServicesPanel = new GWCServicesPanel("gwcServicesPanel", (IModel<GWCConfig>)gwcConfigModel);
        CachingOptionsPanel defaultCachingOptionsPanel = new CachingOptionsPanel("cachingOptionsPanel", (IModel<GWCConfig>)gwcConfigModel);
        final DiskQuotaConfigPanel diskQuotaConfigPanel = new DiskQuotaConfigPanel("diskQuotaPanel", (IModel<DiskQuotaConfig>)diskQuotaModel);
        if (diskQuotaModuleDisabled) {
            diskQuotaConfigPanel.setVisible(false);
        }
        form.add(new Component[]{gwcServicesPanel});
        form.add(new Component[]{defaultCachingOptionsPanel});
        form.add(new Component[]{diskQuotaConfigPanel});
        form.add(new Component[]{new Button("submit", (IModel)diskQuotaModel){
            private static final long serialVersionUID = 1L;
            private final /* synthetic */ IModel val$diskQuotaModel;
            {
                this.val$diskQuotaModel = iModel;
                super($anonymous0);
            }

            public void onSubmit() {
                GWC gwc = GWCSettingsPage.this.getGWC();
                IModel formModel = form.getModel();
                PropertyModel gwcConfigModel = new PropertyModel((Object)formModel, "gwcConfig");
                GWCConfig gwcConfig = (GWCConfig)gwcConfigModel.getObject();
                try {
                    gwc.saveConfig(gwcConfig);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error saving GWC config", e);
                    form.error((Serializable)((Object)("Error saving GWC config: " + e.getMessage())));
                    return;
                }
                if (!diskQuotaModuleDisabled) {
                    Double chosenQuota;
                    StorageUnit chosenUnit = diskQuotaConfigPanel.getStorageUnit();
                    String chosenQuotaStr = String.valueOf(diskQuotaConfigPanel.getQuotaValue());
                    try {
                        chosenQuota = Double.valueOf(chosenQuotaStr);
                    }
                    catch (NumberFormatException e) {
                        form.error((Serializable)((Object)(String.valueOf(chosenQuotaStr) + " is not a valid floating point number")));
                        return;
                    }
                    if (chosenQuota <= 0.0) {
                        form.error((Serializable)((Object)"Quota has to be > 0"));
                        return;
                    }
                    DiskQuotaConfig dqConfig = (DiskQuotaConfig)this.val$diskQuotaModel.getObject();
                    dqConfig.getGlobalQuota().setValue(chosenQuota.doubleValue(), chosenUnit);
                    gwc.saveDiskQuotaConfig(dqConfig);
                }
                this.setResponsePage(GeoServerHomePage.class);
            }
        }});
        form.add(new Component[]{new Button("cancel"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                this.setResponsePage(GeoServerHomePage.class);
            }
        }});
    }

    private GWC getGWC() {
        GWC gwc = (GWC)this.getGeoServerApplication().getBean("gwcFacade");
        return gwc;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        return header;
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (titleKey != null) {
            AttributeModifier attributeModifier = new AttributeModifier("title", true, (IModel)new StringResourceModel(titleKey, null, null));
            checkBox.add(new IBehavior[]{attributeModifier});
        }
        return checkBox;
    }
}

