/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.catalog;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.security.catalog.CatalogModePage;

public class CatalogModePageTest
extends GeoServerWicketTestSupport {
    private DataAccessRuleDAO dao;
    private CatalogMode catalogMode;

    protected void setUpInternal() throws Exception {
        this.dao = DataAccessRuleDAO.get();
        this.catalogMode = this.dao.getMode();
        this.login();
        tester.startPage(CatalogModePage.class);
    }

    public void testRenders() throws Exception {
        tester.assertRenderedPage(CatalogModePage.class);
    }

    public void testDefaultCatalogMode() throws Exception {
        tester.assertRenderedPage(CatalogModePage.class);
        CatalogModePageTest.assertEquals((String)"HIDE", (String)tester.getComponentFromLastRenderedPage("catalogModeForm:catalogMode").getDefaultModelObject().toString());
    }

    public void testEditCatalogMode() throws Exception {
        tester.assertRenderedPage(CatalogModePage.class);
        CatalogModePageTest.assertFalse((boolean)"CHALLENGE".equals(tester.getComponentFromLastRenderedPage("catalogModeForm:catalogMode").getDefaultModelObject()));
        FormTester form = tester.newFormTester("catalogModeForm");
        form.select("catalogMode", 1);
        form.getForm().visitChildren(RadioChoice.class, new Component.IVisitor(){

            public Object component(Component component) {
                if (component.getId().equals("catalogMode")) {
                    ((RadioChoice)component).onSelectionChanged();
                }
                return CONTINUE_TRAVERSAL;
            }
        });
        CatalogModePageTest.assertEquals((String)"MIXED", (String)tester.getComponentFromLastRenderedPage("catalogModeForm:catalogMode").getDefaultModelObject().toString());
    }
}

