/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.security.RolesFormComponent;
import org.geoserver.web.security.user.UserPage;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;

public abstract class AbstractUserPage
extends GeoServerSecuredPage {
    TextField username;

    protected AbstractUserPage(UserUIModel user) {
        Model userModel = new Model((Serializable)user);
        Form form = new Form("userForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)userModel));
        this.setDefaultModel((IModel)userModel);
        this.add(new Component[]{form});
        this.username = new TextField("username");
        form.add(new Component[]{this.username});
        PasswordTextField pw1 = new PasswordTextField("password").setResetPassword(false);
        PasswordTextField pw2 = new PasswordTextField("confirmPassword").setResetPassword(false);
        form.add(new Component[]{pw1});
        form.add(new Component[]{pw2});
        form.add(new Component[]{new RolesFormComponent("roles", (IModel)new PropertyModel((Object)userModel, "authorities"), form, false)});
        form.add(new Component[]{new BookmarkablePageLink("cancel", UserPage.class)});
        form.add(new Component[]{this.saveLink()});
        form.add((IFormValidator)new EqualInputValidator((FormComponent)pw1, (FormComponent)pw2));
        this.username.setRequired(true);
    }

    SubmitLink saveLink() {
        return new SubmitLink("save"){

            public void onSubmit() {
                AbstractUserPage.this.onFormSubmit();
            }
        };
    }

    protected abstract void onFormSubmit();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UserUIModel
    implements Serializable {
        String username;
        String originalPassword;
        String password;
        String confirmPassword;
        List<String> authorities;
        boolean enabled;

        public UserUIModel(UserDetails springUser) {
            this.username = springUser.getUsername();
            this.password = this.originalPassword = springUser.getPassword();
            this.confirmPassword = this.originalPassword;
            this.authorities = this.toRoleList(springUser);
            this.enabled = springUser.isEnabled();
        }

        public UserUIModel() {
            this.authorities = new ArrayList<String>();
            this.enabled = true;
        }

        public User toSpringUser() {
            return new User(this.username, this.password, this.enabled, true, true, true, this.toGrantedAuthorities(this.authorities));
        }

        List<String> toRoleList(UserDetails springUser) {
            ArrayList<String> result = new ArrayList<String>(springUser.getAuthorities().length);
            GrantedAuthority[] grantedAuthorityArray = springUser.getAuthorities();
            int n = grantedAuthorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrantedAuthority ga = grantedAuthorityArray[n2];
                result.add(ga.getAuthority());
                ++n2;
            }
            return result;
        }

        GrantedAuthority[] toGrantedAuthorities(List<String> roles) {
            GrantedAuthority[] authorities = new GrantedAuthority[roles.size()];
            int i = 0;
            while (i < authorities.length) {
                authorities[i] = new GrantedAuthorityImpl(roles.get(i));
                ++i;
            }
            return authorities;
        }
    }
}

