/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.impl.LayerIdentifier;
import org.geoserver.wms.web.publish.AuthorityURLListEditor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerIdentifierListEditor
extends FormComponentPanel<List<LayerIdentifierInfo>> {
    private static final long serialVersionUID = 5098470663723800345L;
    private ListView<LayerIdentifierInfo> identifiers;
    private Label noMetadata;
    private WebMarkupContainer table;
    private List<AuthorityURLInfo> baseAuthorities;
    private final AuthorityURLListEditor availableAuthoritiesProvider;

    public LayerIdentifierListEditor(String id, IModel<List<LayerIdentifierInfo>> list, AuthorityURLListEditor availableAuthoritiesProvider) {
        super(id, list);
        this.availableAuthoritiesProvider = availableAuthoritiesProvider;
        Assert.notNull((Object)list.getObject());
        Assert.notNull((Object)availableAuthoritiesProvider.getModelObject());
        this.setOutputMarkupId(true);
        this.initUI();
    }

    public void setBaseAuthorities(List<AuthorityURLInfo> baseAuthorities) {
        this.baseAuthorities = baseAuthorities;
    }

    private void initUI() {
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.identifiers = new ListView<LayerIdentifierInfo>("identifiers", new ArrayList((Collection)this.getModelObject())){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<LayerIdentifierInfo> item) {
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd"))});
                PropertyModel authModel = new PropertyModel((Object)item.getModel(), "authority");
                AuthListModel authNamesModel = new AuthListModel();
                DropDownChoice authorities = new DropDownChoice("authority", (IModel)authModel, (List)authNamesModel.getObject());
                authorities.setRequired(true);
                FormComponentFeedbackBorder authFeedbak = new FormComponentFeedbackBorder("authFeedbak");
                authFeedbak.add(new Component[]{authorities});
                item.add(new Component[]{authFeedbak});
                TextField identifier = new TextField("identifier", (IModel)new PropertyModel((Object)item.getModel(), "identifier"));
                identifier.setRequired(true);
                FormComponentFeedbackBorder idFeedbak = new FormComponentFeedbackBorder("idFeedbak");
                idFeedbak.add(new Component[]{identifier});
                item.add(new Component[]{idFeedbak});
                AjaxLink<Integer> link = new AjaxLink<Integer>("removeLink", (IModel)new Model((Serializable)Integer.valueOf(item.getIndex()))){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        ArrayList list = new ArrayList(LayerIdentifierListEditor.this.identifiers.getModelObject());
                        int index = (Integer)this.getModelObject();
                        list.remove(index);
                        LayerIdentifierListEditor.this.identifiers.setModelObject(list);
                        LayerIdentifierListEditor.this.updateLinksVisibility();
                        target.addComponent((Component)container);
                    }
                };
                item.add(new Component[]{link});
            }
        };
        this.identifiers.setOutputMarkupId(true);
        this.identifiers.setReuseItems(true);
        this.table.add(new Component[]{this.identifiers});
        this.noMetadata = new Label("noIdentifiers", (IModel)new ResourceModel("noLayerIdentifiersSoFar"));
        container.add(new Component[]{this.noMetadata});
        this.updateLinksVisibility();
        AjaxButton button = new AjaxButton("addIdentifier"){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                List list = LayerIdentifierListEditor.this.identifiers.getModelObject();
                LayerIdentifier newIdentifier = new LayerIdentifier();
                list.add(newIdentifier);
                LayerIdentifierListEditor.this.identifiers.setModelObject(list);
                LayerIdentifierListEditor.this.updateLinksVisibility();
                target.addComponent((Component)LayerIdentifierListEditor.this);
            }
        };
        this.add(new Component[]{button});
    }

    private void updateLinksVisibility() {
        List list = this.identifiers.getModelObject();
        boolean anyLink = list.size() > 0;
        this.table.setVisible(anyLink);
        this.noMetadata.setVisible(!anyLink);
    }

    protected void convertInput() {
        List info = this.identifiers.getModelObject();
        this.setConvertedInput(info);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthListModel
    extends LoadableDetachableModel<List<String>> {
        private static final long serialVersionUID = 1L;

        private AuthListModel() {
        }

        protected List<String> load() {
            List authorities = (List)LayerIdentifierListEditor.this.availableAuthoritiesProvider.getModelObject();
            ArrayList<String> names = new ArrayList<String>(authorities.size());
            for (AuthorityURLInfo auth : authorities) {
                names.add(auth.getName());
            }
            if (LayerIdentifierListEditor.this.baseAuthorities != null) {
                for (AuthorityURLInfo baseAuth : LayerIdentifierListEditor.this.baseAuthorities) {
                    names.add(baseAuth.getName());
                }
            }
            Collections.sort(names);
            return names;
        }
    }
}

