/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.WfsFactory;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.util.ErrorHandler;
import org.geoserver.util.ReaderUtils;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class CapabilitiesTransformerTest
extends WFSTestSupport {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs.test");

    GetCapabilitiesType request() {
        GetCapabilitiesType type = WfsFactory.eINSTANCE.createGetCapabilitiesType();
        type.setBaseUrl("http://localhost:8080/geoserver");
        return type;
    }

    public void test() throws Exception {
        CapabilitiesTransformer.WFS1_1 tx = new CapabilitiesTransformer.WFS1_1(this.getWFS(), this.getCatalog());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)this.request(), (OutputStream)output);
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(output.toByteArray()));
        File f = new File("../web/src/main/webapp/schemas/wfs/1.1.0/wfs.xsd");
        if (!f.exists()) {
            return;
        }
        ErrorHandler handler = new ErrorHandler(logger, Level.WARNING);
        ReaderUtils.validate((Reader)reader, (DefaultHandler)handler, (String)"http://www.opengis.net/wfs", (String)"../web/src/main/webapp/schemas/wfs/1.1.0/wfs.xsd");
        CapabilitiesTransformerTest.assertTrue((boolean)handler.errors.isEmpty());
    }

    public void testDefaultOutputFormat() throws Exception {
        CapabilitiesTransformer.WFS1_1 tx = new CapabilitiesTransformer.WFS1_1(this.getWFS(), this.getCatalog());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tx.transform((Object)this.request(), (OutputStream)output);
        Document dom = super.dom((InputStream)new ByteArrayInputStream(output.toByteArray()));
        String expected = "text/xml; subtype=gml/3.1.1";
        String xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='DescribeFeatureType']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='GetFeature']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='GetFeatureWithLock']/ows:Parameter[@name='outputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
        xpathExpr = "//wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='Transaction']/ows:Parameter[@name='inputFormat']/ows:Value";
        XMLAssert.assertXpathEvaluatesTo((String)"text/xml; subtype=gml/3.1.1", (String)xpathExpr, (Document)dom);
    }
}

