/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetCapabilitiesTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetCapabilitiesTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities");
        GetCapabilitiesTest.assertEquals((String)"wfs:WFS_Capabilities", (String)doc.getDocumentElement().getNodeName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        GetCapabilitiesTest.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength() > 0 ? 1 : 0) != 0);
    }

    public void testNamespaceFilter() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities&namespace=sf");
        Element e = doc.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"WFS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        GetCapabilitiesTest.assertTrue((xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[starts-with(., sf)]", doc).getLength() > 0 ? 1 : 0) != 0);
        GetCapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wfs:FeatureType/wfs:Name[not(starts-with(., sf))]", doc).getLength());
        doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&namespace=NotThere");
        e = doc.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"WFS_Capabilities", (String)e.getLocalName());
        GetCapabilitiesTest.assertEquals((int)0, (int)xpath.getMatchingNodes("//wfs:FeatureType", doc).getLength());
    }

    public void testPost() throws Exception {
        String xml = "<GetCapabilities service=\"WFS\" version=\"1.0.0\" xmlns=\"http://www.opengis.net/wfs\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://www.opengis.net/wfs  http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\"/>";
        Document doc = this.postAsDOM("wfs", xml);
        GetCapabilitiesTest.assertEquals((String)"WFS_Capabilities", (String)doc.getDocumentElement().getNodeName());
    }

    public void testOutputFormats() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=getCapabilities&version=1.0.0");
        Element outputFormats = this.getFirstElementByTagName(doc, "ResultFormat");
        NodeList formats = outputFormats.getChildNodes();
        TreeSet<String> s1 = new TreeSet<String>();
        int i = 0;
        while (i < formats.getLength()) {
            String format = formats.item(i).getNodeName();
            s1.add(format);
            ++i;
        }
        List extensions = GeoServerExtensions.extensions(WFSGetFeatureOutputFormat.class);
        TreeSet<String> s2 = new TreeSet<String>();
        for (WFSGetFeatureOutputFormat extension : extensions) {
            s2.add(extension.getCapabilitiesElementName());
        }
        GetCapabilitiesTest.assertEquals(s1, s2);
    }

    public void testTypeNameCount() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"WFS_Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        List enabledTypes = this.getCatalog().getFeatureTypes();
        Iterator it = enabledTypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
            if (ft.isEnabled()) continue;
            it.remove();
        }
        int enabledCount = enabledTypes.size();
        GetCapabilitiesTest.assertEquals((int)enabledCount, (int)xpath.getMatchingNodes("/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType", doc).getLength());
    }

    public void testTypeNames() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&version=1.0.0&request=getCapabilities");
        Element e = doc.getDocumentElement();
        GetCapabilitiesTest.assertEquals((String)"WFS_Capabilities", (String)e.getLocalName());
        List enabledTypes = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo ft : enabledTypes) {
            if (!ft.isEnabled()) continue;
            String prefixedName = ft.getPrefixedName();
            String xpathExpr = "/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType/wfs:Name[text()=\"" + prefixedName + "\"]";
            XMLAssert.assertXpathExists((String)xpathExpr, (Document)doc);
        }
    }
}

