/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NumDecimalsTest
extends WFSTestSupport {
    public void testDefaults() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 3);
    }

    public void testGlobal() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setNumDecimals(1);
        this.getGeoServer().save(global);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 1);
    }

    public void testPerFeatureType() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        ft.setNumDecimals(1);
        cat.save((ResourceInfo)ft);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008&version=1.0.0");
        this.runAssertions(dom, 1);
    }

    public void testMultipleFeatureTypes() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo ft1 = cat.getFeatureTypeByName("sf", "PrimitiveGeoFeature");
        FeatureTypeInfo ft2 = cat.getFeatureTypeByName("sf", "AggregateGeoFeature");
        ft1.setNumDecimals(3);
        cat.save((ResourceInfo)ft1);
        ft2.setNumDecimals(1);
        cat.save((ResourceInfo)ft2);
        Document dom = this.getAsDOM("wfs?request=getfeature&featureid=PrimitiveGeoFeature.f008,AggregateGeoFeature.f009&version=1.0.0");
        this.runAssertions(dom, 3);
    }

    void runAssertions(Document dom, int numdecimals) throws Exception {
        NodeList nl = dom.getElementsByTagName("gml:coordinates");
        int x = 0;
        while (x < nl.getLength()) {
            Element e = (Element)nl.item(x);
            String[] tuples = e.getFirstChild().getNodeValue().split(" ");
            int i = 0;
            while (i < tuples.length) {
                String[] coord = tuples[i].split(",");
                int j = 0;
                while (j < coord.length) {
                    int dot = coord[j].indexOf(46);
                    NumDecimalsTest.assertEquals((int)numdecimals, (int)coord[j].substring(dot + 1).length());
                    ++j;
                }
                ++i;
            }
            ++x;
        }
    }
}

