/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.xml.sax.InputSource;

public class WfsXmlReader
extends XmlRequestReader {
    WFSInfo wfs;
    Configuration configuration;
    Catalog catalog;

    public WfsXmlReader(String element, GeoServer gs, Configuration configuration) {
        this(element, gs, configuration, "wfs");
    }

    protected WfsXmlReader(String element, GeoServer gs, Configuration configuration, String serviceId) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.1.0"), serviceId);
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        if (this.wfs.isCiteCompliant()) {
            strict = Boolean.TRUE;
        }
        this.configuration.getProperties().add(Parser.Properties.PARSE_UNKNOWN_ELEMENTS);
        Parser parser = new Parser(this.configuration);
        parser.setValidating(strict.booleanValue());
        List namespaces = this.catalog.getNamespaces();
        for (NamespaceInfo ns : namespaces) {
            if (ns.equals((Object)this.catalog.getDefaultNamespace())) continue;
            parser.getNamespaces().declarePrefix(ns.getPrefix(), ns.getURI());
        }
        InputSource source = new InputSource(reader);
        source.setEncoding(this.wfs.getGeoServer().getGlobal().getCharset());
        Object parsed = parser.parse(source);
        if (!"Transaction".equalsIgnoreCase(this.getElement().getLocalPart()) && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

