/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFeatureWithLockTest
extends WFSTestSupport {
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.getServiceDescriptor11().getOperations().add("ReleaseLock");
    }

    public void testUpdateLockedFeatureWithLockId() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" expiry=\"10\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"><wfs:Query typeName=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertFalse((dom.getElementsByTagName("cdf:Locks").getLength() == 0 ? 1 : 0) != 0);
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:GetFeatureWithLock service=\"WFS\" version=\"1.0.0\" expiry=\"10\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"><wfs:Query typeName=\"cdf:Locks\"><ogc:Filter><ogc:FeatureId fid=\"" + fid + "\"/>" + "</ogc:Filter>" + "</wfs:Query>" + "</wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction   service=\"WFS\"   version=\"1.0.0\"   xmlns:cdf=\"http://www.opengis.net/cite/data\"   xmlns:ogc=\"http://www.opengis.net/ogc\"   xmlns:wfs=\"http://www.opengis.net/wfs\" >   <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"cdf:Locks\"> " + "    <wfs:Property> " + "      <wfs:Name>cdf:id</wfs:Name> " + "      <wfs:Value>gfwlbt0001</wfs:Value> " + "    </wfs:Property> " + "    <ogc:Filter> " + "      <ogc:FeatureId fid=\"" + fid + "\"/> " + "    </ogc:Filter> " + "  </wfs:Update> " + "</wfs:Transaction> ";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&version=1.1.0&lockId=" + lockId);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
    }

    public void testUpdateLockedFeatureWithoutLockId() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" expiry=\"10\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"><wfs:Query typeName=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertFalse((dom.getElementsByTagName("cdf:Locks").getLength() == 0 ? 1 : 0) != 0);
        String fid = ((Element)dom.getElementsByTagName("cdf:Locks").item(0)).getAttribute("fid");
        xml = "<wfs:GetFeatureWithLock service=\"WFS\" version=\"1.0.0\" expiry=\"10\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\"><wfs:Query typeName=\"cdf:Locks\"><ogc:Filter><ogc:FeatureId fid=\"" + fid + "\"/>" + "</ogc:Filter>" + "</wfs:Query>" + "</wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction   service=\"WFS\"   version=\"1.0.0\"   xmlns:cdf=\"http://www.opengis.net/cite/data\"   xmlns:ogc=\"http://www.opengis.net/ogc\"   xmlns:wfs=\"http://www.opengis.net/wfs\" >   <wfs:Update typeName=\"cdf:Locks\">     <wfs:Property>       <wfs:Name>cdf:id</wfs:Name>       <wfs:Value>gfwlbt0001</wfs:Value>     </wfs:Property>     <ogc:Filter>       <ogc:FeatureId fid=\"" + fid + "\"/> " + "    </ogc:Filter> " + "  </wfs:Update> " + "</wfs:Transaction> ";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&lockId=" + lockId);
        GetFeatureWithLockTest.assertTrue((1 == dom.getElementsByTagName("wfs:FAILED").getLength() || "ServiceExceptionReport".equals(dom.getDocumentElement().getNodeName()) ? 1 : 0) != 0);
    }

    public void testGetFeatureWithLockReleaseActionSome() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("fid");
        String fid2 = ((Element)locks.item(1)).getAttribute("fid");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"cdf:Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Query>" + "</wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"cdf:Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0003</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"cdf:Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0004</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("wfs", xml);
        this.get("wfs?request=ReleaseLock&lockId=" + lockId);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
    }

    public void testWorkspaceQualified() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/wfs", xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("fid");
        String fid2 = ((Element)locks.item(1)).getAttribute("fid");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Query>" + "</wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0003</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("cdf/wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0004</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("cdf/wfs", xml);
        this.get("cdf/wfs?request=ReleaseLock&lockId=" + lockId);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
    }

    public void testLayerQualified() throws Exception {
        String xml = "<wfs:GetFeature  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("cdf/Locks/wfs", xml);
        NodeList locks = dom.getElementsByTagName("cdf:Locks");
        String fid1 = ((Element)locks.item(0)).getAttribute("fid");
        String fid2 = ((Element)locks.item(1)).getAttribute("fid");
        xml = "<wfs:GetFeatureWithLock  service=\"WFS\"  version=\"1.0.0\"  expiry=\"10\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:Query typeName=\"Locks\">    <ogc:Filter>      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Query>" + "</wfs:GetFeatureWithLock>";
        dom = this.postAsDOM("cdf/Fifteen/wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ogc:ServiceException)", (Document)dom);
        dom = this.postAsDOM("cdf/Locks/wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        String lockId = dom.getDocumentElement().getAttribute("lockId");
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  releaseAction=\"SOME\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0003</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid1 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("cdf/Locks/wfs", xml);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
        xml = "<wfs:Transaction  service=\"WFS\"  version=\"1.0.0\"  xmlns:cdf=\"http://www.opengis.net/cite/data\"  xmlns:ogc=\"http://www.opengis.net/ogc\"  xmlns:wfs=\"http://www.opengis.net/wfs\">  <wfs:LockId>" + lockId + "</wfs:LockId>" + "  <wfs:Update typeName=\"Locks\">" + "    <wfs:Property>" + "      <wfs:Name>cdf:id</wfs:Name>" + "      <wfs:Value>gfwlrs0004</wfs:Value>" + "    </wfs:Property>" + "    <ogc:Filter>" + "      <ogc:FeatureId fid=\"" + fid2 + "\"/>" + "    </ogc:Filter>" + "  </wfs:Update>" + "</wfs:Transaction>";
        dom = this.postAsDOM("cdf/Locks/wfs", xml);
        this.get("cdf/Locks/wfs?request=ReleaseLock&lockId=" + lockId);
        GetFeatureWithLockTest.assertEquals((String)"wfs:WFS_TransactionResponse", (String)dom.getDocumentElement().getNodeName());
        GetFeatureWithLockTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:SUCCESS").getLength());
    }
}

