/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.mockrunner.mock.web.MockHttpServletResponse;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.response.ShapeZipOutputFormat;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class ShapeZipTest
extends WFSTestSupport {
    private static final QName ALL_TYPES = new QName(MockData.CITE_URI, "AllTypes", MockData.CITE_PREFIX);
    private static final QName ALL_DOTS = new QName(MockData.CITE_URI, "All.Types.Dots", MockData.CITE_PREFIX);
    private static final QName GEOMMID = new QName(MockData.CITE_URI, "geommid", MockData.CITE_PREFIX);
    private static final QName LONGNAMES = new QName(MockData.CITE_URI, "longnames", MockData.CITE_PREFIX);
    private static final QName NULLGEOM = new QName(MockData.CITE_URI, "nullgeom", MockData.CITE_PREFIX);
    private static final QName DOTS = new QName(MockData.CITE_URI, "dots.in.name", MockData.CITE_PREFIX);
    private Operation op;
    private GetFeatureType gft;

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("srs", "4326");
        dataDirectory.addPropertiesType(ALL_TYPES, ShapeZipTest.class.getResource("AllTypes.properties"), params);
        dataDirectory.addPropertiesType(ALL_DOTS, ShapeZipTest.class.getResource("All.Types.Dots.properties"), params);
        dataDirectory.addPropertiesType(GEOMMID, ShapeZipTest.class.getResource("geommid.properties"), params);
        dataDirectory.addPropertiesType(NULLGEOM, ShapeZipTest.class.getResource("nullgeom.properties"), params);
        dataDirectory.addPropertiesType(DOTS, ShapeZipTest.class.getResource("dots.in.name.properties"), params);
        dataDirectory.addPropertiesType(LONGNAMES, ShapeZipTest.class.getResource("longnames.properties"), params);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.gft = WfsFactory.eINSTANCE.createGetFeatureType();
        this.op = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{this.gft});
    }

    public void testNoNativeProjection() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures());
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    public void testCharset() throws Exception {
        SimpleFeatureSource fs = this.getFeatureSource(MockData.BASIC_POLYGONS);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fs.getFeatures());
        HashMap<String, Charset> options = new HashMap<String, Charset>();
        options.put("CHARSET", Charset.forName("ISO-8859-15"));
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(bos.toByteArray()));
        ShapeZipTest.assertEquals((String)"ISO-8859-15", (String)this.getCharset(new ByteArrayInputStream(bos.toByteArray())));
    }

    public void testMultiType() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_TYPES).getFeatures());
        String[] expectedTypes = new String[]{"AllTypesPoint", "AllTypesMPoint", "AllTypesPolygon", "AllTypesLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testMultiTypeDots() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_DOTS).getFeatures());
        String[] expectedTypes = new String[]{"All_Types_DotsPoint", "All_Types_DotsMPoint", "All_Types_DotsPolygon", "All_Types_DotsLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testGeometryInTheMiddle() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(GEOMMID).getFeatures());
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testNullGeometries() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(NULLGEOM).getFeatures());
        String[] expectedTypes = new String[]{"nullgeom"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
    }

    public void testLongNames() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(LONGNAMES).getFeatures());
        SimpleFeatureType schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
        zip = this.writeOut((FeatureCollection)this.getFeatureSource(LONGNAMES).getFeatures());
        schema = this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
        this.checkLongNamesSchema(schema);
    }

    void checkLongNamesSchema(SimpleFeatureType schema) {
        ShapeZipTest.assertEquals((int)4, (int)schema.getAttributeCount());
        ShapeZipTest.assertEquals((String)"the_geom", (String)schema.getDescriptor(0).getName().getLocalPart());
        ShapeZipTest.assertEquals(MultiPolygon.class, (Object)schema.getDescriptor(0).getType().getBinding());
        ShapeZipTest.assertEquals((String)"FID", (String)schema.getDescriptor(1).getName().getLocalPart());
        ShapeZipTest.assertEquals((String)"VERYLONGNA", (String)schema.getDescriptor(2).getName().getLocalPart());
        ShapeZipTest.assertEquals((String)"VERYLONGN0", (String)schema.getDescriptor(3).getName().getLocalPart());
    }

    public void testDots() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(DOTS).getFeatures());
        String[] expectedTypes = new String[]{"dots_in_name"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        this.checkFieldsAreNotEmpty(new ByteArrayInputStream(zip));
    }

    public void testEmptyResult() throws Exception {
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures((Filter)Filter.EXCLUDE));
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(zip));
    }

    public void testEmptyResultMultiGeom() throws Exception {
        ZipEntry entry;
        byte[] zip = this.writeOut((FeatureCollection)this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.EXCLUDE));
        String[] expectedTypes = new String[]{"All_Types_Dots"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(zip));
        boolean foundReadme = false;
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));
        while ((entry = zis.getNextEntry()) != null) {
            foundReadme |= entry.getName().equals("README.TXT");
        }
    }

    public void testTemplateSingleType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(MockData.BASIC_POLYGONS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        SimpleFeatureCollection fc = this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures((Filter)Filter.INCLUDE);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        String[][] headers = zip.getHeaders((Object)fct, this.op);
        ShapeZipTest.assertEquals((int)1, (int)headers.length);
        ShapeZipTest.assertEquals((String)"Content-Disposition", (String)headers[0][0]);
        ShapeZipTest.assertEquals((String)"attachment; filename=shapezip_BasicPolygons.zip", (String)headers[0][1]);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_BasicPolygons"}, new ByteArrayInputStream(zipBytes));
    }

    public void testTemplateMultiType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(MockData.BASIC_POLYGONS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)this.getFeatureSource(MockData.BASIC_POLYGONS).getFeatures((Filter)Filter.INCLUDE));
        fct.getFeature().add((Object)this.getFeatureSource(MockData.BRIDGES).getFeatures((Filter)Filter.INCLUDE));
        String[][] headers = zip.getHeaders((Object)fct, this.op);
        ShapeZipTest.assertEquals((int)1, (int)headers.length);
        ShapeZipTest.assertEquals((String)"Content-Disposition", (String)headers[0][0]);
        ShapeZipTest.assertEquals((String)"attachment; filename=shapezip_BasicPolygons.zip", (String)headers[0][1]);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_BasicPolygons", "theshape_Bridges"}, new ByteArrayInputStream(zipBytes));
    }

    public void testTemplateMultiGeomType() throws Exception {
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName(ALL_DOTS.getPrefix());
        this.getDataDirectory().copyToWorkspaceDir(ws, ((Object)((Object)this)).getClass().getResourceAsStream("shapeziptest.ftl"), "shapezip.ftl");
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.INCLUDE));
        String[][] headers = zip.getHeaders((Object)fct, this.op);
        ShapeZipTest.assertEquals((int)1, (int)headers.length);
        ShapeZipTest.assertEquals((String)"Content-Disposition", (String)headers[0][0]);
        ShapeZipTest.assertEquals((String)"attachment; filename=shapezip_All_Types_Dots.zip", (String)headers[0][1]);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] zipBytes = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"theshape_All_Types_DotsPoint", "theshape_All_Types_DotsMPoint", "theshape_All_Types_DotsPolygon", "theshape_All_Types_DotsLine"}, new ByteArrayInputStream(zipBytes));
    }

    public void testTemplatePOSTRequest10() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" outputFormat=\"shape-zip\" > <wfs:Query typeName=\"cdf:Other\"> </wfs:Query> </wfs:GetFeature>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        ShapeZipTest.assertEquals((String)"application/zip", (String)response.getContentType());
    }

    public void testOutputZipFileNameSpecifiedInFormatOptions() throws Exception {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        FeatureCollectionType mockResult = WfsFactory.eINSTANCE.createFeatureCollectionType();
        mockResult.getFeature().add((Object)this.getFeatureSource(ALL_DOTS).getFeatures((Filter)Filter.INCLUDE));
        GetFeatureType mockRequest = WfsFactory.eINSTANCE.createGetFeatureType();
        Operation mockOperation = new Operation("GetFeature", this.getServiceDescriptor10(), null, new Object[]{mockRequest});
        String[][] headers = zip.getHeaders((Object)mockResult, mockOperation);
        ShapeZipTest.assertEquals((int)1, (int)headers.length);
        ShapeZipTest.assertEquals((String)"Content-Disposition", (String)headers[0][0]);
        ShapeZipTest.assertEquals((String)"attachment; filename=All_Types_Dots.zip", (String)headers[0][1]);
        mockRequest.getFormatOptions().put("FILENAME", "REQUEST_SUPPLIED_FILENAME.zip");
        headers = zip.getHeaders((Object)mockResult, mockOperation);
        ShapeZipTest.assertEquals((int)1, (int)headers.length);
        ShapeZipTest.assertEquals((String)"Content-Disposition", (String)headers[0][0]);
        ShapeZipTest.assertEquals((String)"attachment; filename=REQUEST_SUPPLIED_FILENAME.zip", (String)headers[0][1]);
    }

    public void testTemplatePOSTRequest11() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<GetFeature xmlns=\"http://www.opengis.net/wfs\" xmlns:DigitalGlobe=\"http://www.digitalglobe.com\"\n    xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xmlns:gml=\"http://www.opengis.net/gml\" service=\"WFS\" version=\"1.1.0\"\nxmlns:cdf=\"http://www.opengis.net/cite/data\"     outputFormat=\"shape-zip\" maxFeatures=\"100\" handle=\"\">\n    <Query typeName=\"cdf:Other\" srsName=\"urn:ogc:def:crs:EPSG::4326\"></Query> </GetFeature>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        ShapeZipTest.assertEquals((String)"application/zip", (String)response.getContentType());
    }

    public void testESRIFormat() throws Exception {
        this.setupESRIPropertyFile();
        SimpleFeatureSource fs = this.getFeatureSource(MockData.BASIC_POLYGONS);
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fs.getFeatures());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRJFILEFORMAT", "ESRI");
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(byteArrayZip));
        this.checkFileContent("BasicPolygons.prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
    }

    public void testESRIFormatMultiType() throws Exception {
        this.setupESRIPropertyFile();
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(this.getGeoServer(), this.getCatalog(), this.getResourceLoader());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)this.getFeatureSource(ALL_TYPES).getFeatures());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("PRJFILEFORMAT", "ESRI");
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        String[] expectedTypes = new String[]{"AllTypesPoint", "AllTypesMPoint", "AllTypesPolygon", "AllTypesLine"};
        this.checkShapefileIntegrity(expectedTypes, new ByteArrayInputStream(byteArrayZip));
        String[] stringArray = expectedTypes;
        int n = expectedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.checkFileContent(String.valueOf(fileName) + ".prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
            ++n2;
        }
    }

    public void testESRIFormatFromDefaultValue() throws Exception {
        this.setupESRIPropertyFile();
        GeoServer geoServer = this.getGeoServer();
        this.setupESRIFormatByDefault(geoServer, true);
        SimpleFeatureSource fs = this.getFeatureSource(MockData.BASIC_POLYGONS);
        Catalog catalog = this.getCatalog();
        GeoServerResourceLoader resourceLoader = this.getResourceLoader();
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat(geoServer, catalog, resourceLoader);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fs.getFeatures());
        HashMap options = new HashMap();
        this.gft.setFormatOptions(options);
        zip.write(fct, (OutputStream)bos, this.op);
        byte[] byteArrayZip = bos.toByteArray();
        this.checkShapefileIntegrity(new String[]{"BasicPolygons"}, new ByteArrayInputStream(byteArrayZip));
        this.checkFileContent("BasicPolygons.prj", new ByteArrayInputStream(byteArrayZip), this.get4326_ESRI_WKTContent());
    }

    byte[] writeOut(FeatureCollection fc) throws IOException {
        ShapeZipOutputFormat zip = new ShapeZipOutputFormat();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FeatureCollectionType fct = WfsFactory.eINSTANCE.createFeatureCollectionType();
        fct.getFeature().add((Object)fc);
        zip.write(fct, (OutputStream)bos, this.op);
        return bos.toByteArray();
    }

    private File createTempFolder(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, null);
        temp.delete();
        temp.mkdir();
        return temp;
    }

    private void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        int count = 0;
        byte[] buf = new byte[8192];
        while ((count = inStream.read(buf, 0, 8192)) != -1) {
            outStream.write(buf, 0, count);
        }
    }

    private SimpleFeatureType checkFieldsAreNotEmpty(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        File tempFolder = this.createTempFolder("shp_");
        String shapeFileName = "";
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            String outName = String.valueOf(tempFolder.getAbsolutePath()) + File.separatorChar + name;
            if (name.toLowerCase().endsWith("shp")) {
                shapeFileName = outName;
            }
            FileOutputStream outFile = new FileOutputStream(outName);
            this.copyStream(zis, outFile);
            outFile.close();
            zis.closeEntry();
        }
        zis.close();
        File shapeFile = new File(shapeFileName);
        ShapefileDataStore ds = new ShapefileDataStore(shapeFile.toURL());
        SimpleFeatureSource fs = ds.getFeatureSource();
        SimpleFeatureCollection fc = fs.getFeatures();
        SimpleFeatureType schema = (SimpleFeatureType)fc.getSchema();
        Iterator iter = fc.iterator();
        try {
            while (iter.hasNext()) {
                SimpleFeature f = (SimpleFeature)iter.next();
                for (Object attrValue : f.getAttributes()) {
                    ShapeZipTest.assertNotNull(attrValue);
                    if (Geometry.class.isAssignableFrom(attrValue.getClass())) {
                        ShapeZipTest.assertFalse((String)"Empty geometry", (boolean)((Geometry)attrValue).isEmpty());
                        continue;
                    }
                    ShapeZipTest.assertFalse((String)"Empty value for attribute", (boolean)attrValue.toString().trim().equals(""));
                }
            }
        }
        finally {
            fc.close(iter);
            tempFolder.delete();
        }
        return schema;
    }

    private void setupESRIPropertyFile() throws IOException {
        String esri_properties = "4326=" + this.get4326_ESRI_WKTContent();
        ByteArrayInputStream input = new ByteArrayInputStream(esri_properties.getBytes());
        File directory = this.getResourceLoader().findOrCreateDirectory("user_projections");
        File file = new File(directory, "esri.properties");
        if (file.exists()) {
            file.delete();
        }
        IOUtils.copy((InputStream)input, (File)file);
    }

    private void setupESRIFormatByDefault(GeoServer geoServer, Boolean value) throws IOException {
        WFSInfo wfsInfo = (WFSInfo)geoServer.getService(WFSInfo.class);
        MetadataMap metadata = wfsInfo.getMetadata();
        metadata.put("SHAPE-ZIP_DEFAULT_PRJ_IS_ESRI", (Serializable)value);
        geoServer.save((ServiceInfo)wfsInfo);
    }

    private void checkShapefileIntegrity(String[] typeNames, InputStream in) throws IOException {
        String name;
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        String[] extensions = new String[]{".shp", ".shx", ".dbf", ".prj", ".cst"};
        HashSet<String> names = new HashSet<String>();
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            String[] stringArray2 = extensions;
            int n3 = extensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String extension = stringArray2[n4];
                names.add(String.valueOf(name) + extension);
                ++n4;
            }
            ++n2;
        }
        while ((entry = zis.getNextEntry()) != null) {
            name = entry.getName();
            ShapeZipTest.assertTrue((String)("Missing " + name), (boolean)names.contains(name));
            names.remove(name);
            zis.closeEntry();
        }
        zis.close();
    }

    /*
     * Exception decompiling
     */
    private void checkFileContent(String fileName, InputStream zippedIn, String expectedContent) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCharset(InputStream in) throws IOException {
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry entry = null;
        byte[] bytes = new byte[1024];
        while ((entry = zis.getNextEntry()) != null) {
            if (!entry.getName().endsWith(".cst")) continue;
            zis.read(bytes);
        }
        zis.close();
        if (bytes == null) {
            // empty if block
        }
        return new String(bytes).trim();
    }

    private String get4326_ESRI_WKTContent() {
        return "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    }
}

