/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.geoserver.wfs.response.GeoJSONBuilder;

public class GeoJSONBuilderTest
extends TestCase {
    StringWriter writer;
    GeoJSONBuilder builder;

    protected void setUp() throws Exception {
        this.writer = new StringWriter();
        this.builder = new GeoJSONBuilder((Writer)this.writer);
    }

    public void testWriteNormal() throws Exception {
        Geometry g = new WKTReader().read("MULTILINESTRING((0 0, 1 1))");
        this.builder.writeGeom(g);
        GeoJSONBuilderTest.assertEquals((String)"{\"type\":\"MultiLineString\",\"coordinates\":[[[0,0],[1,1]]]}", (String)this.writer.toString());
    }

    public void testWriteGeometrySubclass() throws Exception {
        this.builder.writeGeom((Geometry)new MyPoint(1.0, 2.0));
        GeoJSONBuilderTest.assertEquals((String)"{\"type\":\"Point\",\"coordinates\":[1,2]}", (String)this.writer.toString());
    }

    class MyPoint
    extends Point {
        public MyPoint(double x, double y) {
            super(new Coordinate(x, y), new PrecisionModel(), -1);
        }
    }
}

