/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.wfs.WFSInfo;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class XmlPostRequestLogBufferSize
implements HandlerInterceptor {
    GeoServer gs;

    public XmlPostRequestLogBufferSize(GeoServer gs) {
        this.gs = gs;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof Dispatcher) {
            Dispatcher dispatcher = (Dispatcher)handler;
            Integer xmlLogBufferSize = this.getInfo().getGeoServer().getGlobal().getXmlPostRequestLogBufferSize();
            if (xmlLogBufferSize != null) {
                dispatcher.setXMLPostRequestLogBufferSize(xmlLogBufferSize.intValue());
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    WFSInfo getInfo() {
        return (WFSInfo)this.gs.getService(WFSInfo.class);
    }
}

