/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.sf.json.JSONException;
import org.eclipse.emf.common.util.EList;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.response.GeoJSONBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONOutputFormat
extends WFSGetFeatureOutputFormat {
    private final Logger LOGGER = Logging.getLogger((String)((Object)((Object)this)).getClass().toString());
    public static final String FORMAT = "json";

    public GeoJSONOutputFormat(GeoServer gs) {
        super(gs, FORMAT);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        GetFeatureType gft = (GetFeatureType)operation.getParameters()[0];
        String callback = (String)gft.getFormatOptions().get("CALLBACK");
        if (callback != null && !"".equals(callback)) {
            return "text/javascript";
        }
        return "application/json";
    }

    public String getCapabilitiesElementName() {
        return "GEOJSON";
    }

    protected String getContentDisposition(FeatureCollectionType featureCollection) {
        StringBuffer sb = new StringBuffer();
        for (FeatureCollection fc : featureCollection.getFeature()) {
            sb.append(String.valueOf(fc.getSchema().getName().getLocalPart()) + "_");
        }
        sb.setLength(sb.length() - 1);
        return "inline; filename=" + sb.toString() + ".txt";
    }

    protected void write(FeatureCollectionType featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        WFSInfo wfs = this.getInfo();
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(output, wfs.getGeoServer().getGlobal().getCharset()));
        GetFeatureType gft = (GetFeatureType)getFeature.getParameters()[0];
        String callback = (String)gft.getFormatOptions().get("CALLBACK");
        if (callback != null && !"".equals(callback)) {
            outWriter.write(String.valueOf(callback) + "(");
        }
        GeoJSONBuilder jsonWriter = new GeoJSONBuilder(outWriter);
        EList resultsList = featureCollection.getFeature();
        this.LOGGER.info("about to encode JSON");
        boolean featureBounding = wfs.isFeatureBounding();
        boolean hasGeom = false;
        try {
            NamedIdentifier namedIdent;
            String csStr;
            Set ids;
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            jsonWriter.key("features");
            jsonWriter.array();
            CoordinateReferenceSystem crs = null;
            int i = 0;
            while (i < resultsList.size()) {
                FeatureCollection collection = (FeatureCollection)resultsList.get(i);
                FeatureIterator iterator = collection.features();
                try {
                    while (iterator.hasNext()) {
                        Object value;
                        int j;
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        jsonWriter.object();
                        jsonWriter.key("type").value((Object)"Feature");
                        jsonWriter.key("id").value((Object)feature.getID());
                        SimpleFeatureType fType = feature.getFeatureType();
                        List types = fType.getAttributeDescriptors();
                        GeometryDescriptor defaultGeomType = fType.getGeometryDescriptor();
                        if (crs == null && defaultGeomType != null) {
                            crs = fType.getGeometryDescriptor().getCoordinateReferenceSystem();
                        }
                        jsonWriter.key("geometry");
                        Geometry aGeom = (Geometry)feature.getDefaultGeometry();
                        if (aGeom == null) {
                            j = 0;
                            while (j < types.size() && aGeom == null) {
                                value = feature.getAttribute(j);
                                if (value != null && value instanceof Geometry) {
                                    aGeom = (Geometry)value;
                                }
                                ++j;
                            }
                        }
                        if (aGeom != null) {
                            jsonWriter.writeGeom(aGeom);
                            hasGeom = true;
                        } else {
                            jsonWriter.value(null);
                        }
                        if (defaultGeomType != null) {
                            jsonWriter.key("geometry_name").value((Object)defaultGeomType.getLocalName());
                        }
                        jsonWriter.key("properties");
                        jsonWriter.object();
                        j = 0;
                        while (j < types.size()) {
                            value = feature.getAttribute(j);
                            AttributeDescriptor ad = (AttributeDescriptor)types.get(j);
                            if (value != null) {
                                if (value instanceof Geometry) {
                                    if (!ad.equals(defaultGeomType)) {
                                        jsonWriter.key(ad.getLocalName());
                                        jsonWriter.writeGeom((Geometry)value);
                                    }
                                } else {
                                    jsonWriter.key(ad.getLocalName());
                                    jsonWriter.value(value);
                                }
                            } else {
                                jsonWriter.key(ad.getLocalName());
                                jsonWriter.value(null);
                            }
                            ++j;
                        }
                        ReferencedEnvelope refenv = new ReferencedEnvelope(feature.getBounds());
                        if (featureBounding && !refenv.isEmpty()) {
                            jsonWriter.writeBoundingBox((Envelope)refenv);
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                    }
                }
                finally {
                    collection.close(iterator);
                }
                ++i;
            }
            jsonWriter.endArray();
            if (crs != null && (ids = crs.getIdentifiers()) != null && ids.size() > 0 && (csStr = (namedIdent = (NamedIdentifier)ids.iterator().next()).getCodeSpace().toUpperCase()).equals("EPSG")) {
                jsonWriter.key("crs");
                jsonWriter.object();
                jsonWriter.key("type").value((Object)csStr);
                jsonWriter.key("properties");
                jsonWriter.object();
                jsonWriter.key("code");
                jsonWriter.value(namedIdent.getCode());
                jsonWriter.endObject();
                jsonWriter.endObject();
            }
            if (hasGeom) {
                ReferencedEnvelope e = null;
                int i2 = 0;
                while (i2 < resultsList.size()) {
                    FeatureCollection collection = (FeatureCollection)resultsList.get(i2);
                    if (e == null) {
                        e = collection.getBounds();
                    } else {
                        e.expandToInclude((Envelope)collection.getBounds());
                    }
                    ++i2;
                }
                if (e != null) {
                    jsonWriter.writeBoundingBox((Envelope)e);
                }
            }
            jsonWriter.endObject();
            ((Writer)outWriter).flush();
            if (callback != null && !"".equals(callback)) {
                outWriter.write(")");
                ((Writer)outWriter).flush();
            }
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }
}

