/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReprojectionTest
extends WFSTestSupport {
    private static final String TARGET_CRS_CODE = "EPSG:900913";
    public static QName NULL_GEOMETRIES = new QName(MockData.CITE_URI, "NullGeometries", MockData.CITE_PREFIX);
    public static QName GOOGLE = new QName(MockData.CITE_URI, "GoogleFeatures", MockData.CITE_PREFIX);
    static MathTransform tx;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new ReprojectionTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CoordinateReferenceSystem epsg4326 = CRS.decode((String)TARGET_CRS_CODE);
        CoordinateReferenceSystem epsg32615 = CRS.decode((String)"EPSG:32615");
        tx = CRS.findMathTransform((CoordinateReferenceSystem)epsg32615, (CoordinateReferenceSystem)epsg4326);
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addPropertiesType(NULL_GEOMETRIES, ReprojectionTest.class.getResource("NullGeometries.properties"), Collections.EMPTY_MAP);
        HashMap<String, Integer> extra = new HashMap<String, Integer>();
        extra.put("srsHandling", ProjectionPolicy.REPROJECT_TO_DECLARED.getCode());
        extra.put("srs", 900913);
        dataDirectory.addPropertiesType(GOOGLE, ReprojectionTest.class.getResource("GoogleFeatures.properties"), extra);
    }

    public void testGetFeatureGet() throws Exception {
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart() + "&srsName=" + TARGET_CRS_CODE);
        this.runTest(dom1, dom2, tx);
    }

    public void testGetFeatureGetAutoCRS() throws Exception {
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart() + "&srsName=AUTO:42001,9001,-93,0");
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:32615"), (CoordinateReferenceSystem)CRS.decode((String)"AUTO:42001,9001,-93,0"));
        this.runTest(dom1, dom2, tx);
    }

    public void testGetFeatureAutoCRSBBox() throws Exception {
        CoordinateReferenceSystem auto = CRS.decode((String)"AUTO:42001,9001,-93,0");
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.POLYGONS));
        ReferencedEnvelope nativeEnv = ftInfo.getFeatureSource(null, null).getBounds();
        ReferencedEnvelope reprojectedEnv = nativeEnv.transform(auto, true);
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart());
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart() + "&srsName=AUTO:42001,9001,-93,00&bbox=" + reprojectedEnv.getMinX() + "," + reprojectedEnv.getMinY() + "," + reprojectedEnv.getMaxX() + "," + reprojectedEnv.getMaxY() + ",AUTO:42001,9001,-93,0");
        MathTransform tx = CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)"EPSG:32615"), (CoordinateReferenceSystem)auto);
        this.runTest(dom1, dom2, tx);
    }

    public void testGetFeatureReprojectedFeatureType() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + GOOGLE.getLocalPart() + "&bbox=445000,445000,668000,668000");
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cite:GoogleFeatures)", (Document)dom);
    }

    public void testGetFeaturePost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\"> " + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom1 = this.postAsDOM("wfs", xml);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query srsName=\"EPSG:900913\" typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\"> " + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom2 = this.postAsDOM("wfs", xml);
        this.runTest(dom1, dom2, tx);
    }

    public void testReprojectNullGeometries() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query srsName=\"EPSG:900913\" typeName=\"" + NULL_GEOMETRIES.getPrefix() + ":" + NULL_GEOMETRIES.getLocalPart() + "\"> " + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        ReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName("wfs:FeatureCollection").getLength());
    }

    public void testGetFeatureWithProjectedBoxGet() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + MockData.POLYGONS.getLocalPart() + "&bbox=" + cr[0] + "," + cr[1] + "," + cr[2] + "," + cr[3] + "," + TARGET_CRS_CODE;
        Document dom = this.getAsDOM(q);
        ReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(String.valueOf(MockData.POLYGONS.getPrefix()) + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }

    public void testGetFeatureWithProjectedBoxPost() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:" + MockData.POLYGONS.getPrefix() + "=\"" + MockData.POLYGONS.getNamespaceURI() + "\"" + " xmlns:ogc=\"http://www.opengis.net/ogc\" " + " xmlns:gml=\"http://www.opengis.net/gml\" " + " xmlns:wfs=\"http://www.opengis.net/wfs\" " + "> " + "<wfs:Query typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\">" + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "<ogc:Filter>" + "<ogc:BBOX>" + "<ogc:PropertyName>polygonProperty</ogc:PropertyName>" + "<gml:Box srsName=\"" + TARGET_CRS_CODE + "\">" + "<gml:coord>" + "<gml:X>" + cr[0] + "</gml:X>" + "<gml:Y>" + cr[1] + "</gml:Y>" + "</gml:coord>" + "<gml:coord>" + "<gml:X>" + cr[2] + "</gml:X>" + "<gml:Y>" + cr[3] + "</gml:Y>" + "</gml:coord>" + "</gml:Box>" + "</ogc:BBOX>" + "</ogc:Filter>" + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        ReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(String.valueOf(MockData.POLYGONS.getPrefix()) + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }

    public void testGetFeatureWithProjectedBoxIntersectsPost() throws Exception {
        double[] cr = this.getTransformedPolygonsLayerBBox();
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:" + MockData.POLYGONS.getPrefix() + "=\"" + MockData.POLYGONS.getNamespaceURI() + "\"" + " xmlns:ogc=\"http://www.opengis.net/ogc\" " + " xmlns:gml=\"http://www.opengis.net/gml\" " + " xmlns:wfs=\"http://www.opengis.net/wfs\" " + "> " + "<wfs:Query typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\" srsName=\"" + TARGET_CRS_CODE + "\">" + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "<ogc:Filter>" + "<ogc:Intersects>" + "<ogc:PropertyName>polygonProperty</ogc:PropertyName>" + "<gml:Box>" + "<gml:coord>" + "<gml:X>" + cr[0] + "</gml:X>" + "<gml:Y>" + cr[1] + "</gml:Y>" + "</gml:coord>" + "<gml:coord>" + "<gml:X>" + cr[2] + "</gml:X>" + "<gml:Y>" + cr[3] + "</gml:Y>" + "</gml:coord>" + "</gml:Box>" + "</ogc:Intersects>" + "</ogc:Filter>" + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        ReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(String.valueOf(MockData.POLYGONS.getPrefix()) + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }

    private double[] getTransformedPolygonsLayerBBox() throws Exception, TransformException {
        String q = "wfs?request=getfeature&service=wfs&version=1.0&typeName=" + MockData.POLYGONS.getLocalPart();
        Document dom = this.getAsDOM(q);
        Element envelope = this.getFirstElementByTagName(dom, "gml:Box");
        String coordinates = this.getFirstElementByTagName(envelope, "gml:coordinates").getFirstChild().getNodeValue();
        String lc = coordinates.split(" ")[0];
        String uc = coordinates.split(" ")[1];
        double[] c = new double[]{Double.parseDouble(lc.split(",")[0]), Double.parseDouble(lc.split(",")[1]), Double.parseDouble(uc.split(",")[0]), Double.parseDouble(uc.split(",")[1])};
        double[] cr = new double[4];
        tx.transform(c, 0, cr, 0, 2);
        return cr;
    }

    private void runTest(Document dom1, Document dom2, MathTransform tx) throws Exception {
        Element box = this.getFirstElementByTagName(dom1.getDocumentElement(), "gml:Box");
        Element coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d1 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        box = this.getFirstElementByTagName(dom2.getDocumentElement(), "gml:Box");
        coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d2 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        double[] d3 = new double[d1.length];
        tx.transform(d1, 0, d3, 0, d1.length / 2);
        int i = 0;
        while (i < d2.length) {
            ReprojectionTest.assertEquals((double)d2[i], (double)d3[i], (double)0.001);
            ++i;
        }
    }

    private double[] coordinates(String string) {
        StringTokenizer st = new StringTokenizer(string, " ");
        double[] coordinates = new double[st.countTokens() * 2];
        int i = 0;
        while (st.hasMoreTokens()) {
            String tuple = st.nextToken();
            coordinates[i++] = Double.parseDouble(tuple.split(",")[0]);
            coordinates[i++] = Double.parseDouble(tuple.split(",")[1]);
        }
        return coordinates;
    }
}

