/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.opengis.wfs.DescribeFeatureTypeType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class DescribeFeatureType {
    private Catalog catalog;
    private WFSInfo wfs;

    public DescribeFeatureType(WFSInfo wfs, Catalog catalog) {
        this.catalog = catalog;
        this.wfs = wfs;
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setWFS(WFSInfo wfs) {
        this.wfs = wfs;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public FeatureTypeInfo[] run(DescribeFeatureTypeType request) throws WFSException {
        ArrayList names = new ArrayList(request.getTypeName());
        boolean citeConformance = this.getWFS().isCiteCompliant();
        if (!citeConformance) {
            ArrayList<QName> hackedNames = new ArrayList<QName>(names.size());
            NamespaceInfo defaultNameSpace = this.catalog.getDefaultNamespace();
            if (defaultNameSpace == null) {
                throw new IllegalStateException("No default namespace configured in GeoServer");
            }
            String defaultNsUri = defaultNameSpace.getURI();
            for (QName name : names) {
                String nsUri = name.getNamespaceURI();
                if ("".equals(nsUri) || "http://www.opengis.net/wfs".equals(nsUri)) {
                    name = new QName(defaultNsUri, name.getLocalPart());
                }
                hackedNames.add(name);
            }
            names = hackedNames;
        }
        ArrayList<FeatureTypeInfo> requested = new ArrayList<FeatureTypeInfo>(names.size());
        if (names.isEmpty()) {
            for (FeatureTypeInfo ftInfo : new ArrayList(this.catalog.getFeatureTypes())) {
                if (!ftInfo.enabled()) continue;
                requested.add(ftInfo);
            }
        } else {
            for (QName name : names) {
                String namespaceURI = name.getNamespaceURI();
                String typeName = name.getLocalPart();
                FeatureTypeInfo typeInfo = citeConformance && "".equals(namespaceURI) ? null : this.catalog.getFeatureTypeByName(namespaceURI, typeName);
                if (typeInfo != null && typeInfo.enabled()) {
                    requested.add(typeInfo);
                    continue;
                }
                String msg = "Could not find type: " + name;
                if (citeConformance) {
                    msg = String.valueOf(msg) + ". \nStrict WFS protocol conformance is being applied.\nMake sure the type name is correctly qualified";
                }
                throw new WFSException(msg);
            }
        }
        return requested.toArray(new FeatureTypeInfo[requested.size()]);
    }
}

