/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.HashMap;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeFeatureTest
extends WFSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.disableDataStore(MockData.CITE_PREFIX);
    }

    public void testGet() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testSkipMisconfiguredLayers() throws Exception {
        Document doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//xsd:import[contains(@schemaLocation, 'AggregateGeoFeature')])", (Document)doc);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        FeatureTypeInfo ftype = this.getCatalog().getFeatureTypeByName(MockData.AGGREGATEGEOFEATURE.getLocalPart());
        ftype.setNativeName("NOT ACTUALLY THERE");
        this.getCatalog().save((ResourceInfo)ftype);
        doc = this.getAsDOM("wfs?service=WFS&request=DescribeFeatureType&version=1.0.0");
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//xsd:import[contains(@schemaLocation, 'AggregateGeoFeature')])", (Document)doc);
    }

    public void testPost() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" />";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
    }

    public void testPostDummyFeature() throws Exception {
        String xml = "<wfs:DescribeFeatureType service=\"WFS\" version=\"1.0.0\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:TypeName>cgf:DummyFeature</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"ServiceExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testWithoutExplicitMapping() throws Exception {
        String xml = "<DescribeFeatureType xmlns='http://www.opengis.net/wfs' xmlns:gml='http://www.opengis.net/gml' xmlns:ogc='http://www.opengis.net/ogc' version='1.0.0' service='WFS'> <TypeName>cdf:Locks</TypeName> </DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        DescribeFeatureTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        DescribeFeatureTest.assertEquals((int)1, (int)doc.getElementsByTagName("xsd:complexType").getLength());
    }

    public void testWithoutTypeName() throws Exception {
        String[] expected;
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&version=1.0.0");
        NodeList nl = doc.getElementsByTagName("xsd:import");
        DescribeFeatureTest.assertEquals((int)3, (int)nl.getLength());
        HashMap imprts = new HashMap();
        int i = 0;
        while (i < nl.getLength()) {
            Element imprt = (Element)nl.item(i);
            String namespace = imprt.getAttribute("namespace");
            String schemaLocation = imprt.getAttribute("schemaLocation");
            int query = schemaLocation.indexOf("?");
            schemaLocation = schemaLocation.substring(query + 1);
            String[] sp = schemaLocation.split("&");
            HashMap<String, String> params = new HashMap<String, String>();
            int j = 0;
            while (j < sp.length) {
                String[] sp1 = sp[j].split("=");
                params.put(sp1[0].toLowerCase(), sp1[1].toLowerCase());
                ++j;
            }
            imprts.put(namespace, params);
            ++i;
        }
        String[] stringArray = expected = new String[]{MockData.SF_URI, MockData.CDF_URI, MockData.CGF_URI};
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            DescribeFeatureTest.assertNotNull(imprts.get(namespace));
            HashMap params = (HashMap)imprts.get(namespace);
            DescribeFeatureTest.assertEquals((Object)"wfs", params.get("service"));
            DescribeFeatureTest.assertEquals((Object)"1.0.0", params.get("version"));
            DescribeFeatureTest.assertEquals((Object)"describefeaturetype", params.get("request"));
            String types = (String)params.get("typename");
            DescribeFeatureTest.assertNotNull((Object)types);
            Catalog cat = this.getCatalog();
            NamespaceInfo ns = cat.getNamespaceByURI(namespace);
            System.out.println(ns.getPrefix());
            DescribeFeatureTest.assertEquals((int)cat.getFeatureTypesByNamespace(ns).size(), (int)types.split("%2c").length);
            ++n2;
        }
    }

    public void testWorkspaceQualified() throws Exception {
        Document doc = this.getAsDOM("sf/wfs?request=DescribeFeatureType&version=1.0.0");
        NodeList nl = doc.getElementsByTagName("xsd:complexType");
        DescribeFeatureTest.assertEquals((int)3, (int)nl.getLength());
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'AggregateGeoFeatureType']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'PrimitiveGeoFeatureType']", (Document)doc);
        XMLAssert.assertXpathExists((String)"//xsd:complexType[@name = 'GenericEntityType']", (Document)doc);
        doc = this.getAsDOM("sf/wfs?request=DescribeFeatureType&version=1.0.0&typename=cdf:Fifteen");
        XMLAssert.assertXpathExists((String)"//ogc:ServiceException", (Document)doc);
    }
}

