/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.ows10.GetCapabilitiesType;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.LockType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Request;
import org.geoserver.ows.WorkspaceQualifyingCallback;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSException;
import org.opengis.feature.Feature;
import org.opengis.feature.type.Name;

public class WFSWorkspaceQualifier
extends WorkspaceQualifyingCallback {
    public WFSWorkspaceQualifier(Catalog catalog) {
        super(catalog);
    }

    protected void qualifyRequest(WorkspaceInfo workspace, LayerInfo layer, Service service, Request request) {
    }

    protected void qualifyRequest(WorkspaceInfo workspace, LayerInfo layer, Operation operation, Request request) {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(workspace.getName());
        GetCapabilitiesType caps = (GetCapabilitiesType)OwsUtils.parameter((Object[])operation.getParameters(), GetCapabilitiesType.class);
        if (caps != null) {
            caps.setNamespace(workspace.getName());
            return;
        }
        DescribeFeatureTypeType dft = (DescribeFeatureTypeType)OwsUtils.parameter((Object[])operation.getParameters(), DescribeFeatureTypeType.class);
        if (dft != null) {
            this.qualifyTypeNames((List)dft.getTypeName(), workspace, ns);
            return;
        }
        GetFeatureType gf = (GetFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureType.class);
        if (gf != null) {
            for (QueryType q : gf.getQuery()) {
                this.qualifyTypeNames(q.getTypeName(), workspace, ns);
            }
            return;
        }
        GetFeatureWithLockType gfwl = (GetFeatureWithLockType)OwsUtils.parameter((Object[])operation.getParameters(), GetFeatureWithLockType.class);
        if (gfwl != null) {
            for (QueryType q : gfwl.getQuery()) {
                this.qualifyTypeNames(q.getTypeName(), workspace, ns);
            }
            return;
        }
        LockFeatureType lf = (LockFeatureType)OwsUtils.parameter((Object[])operation.getParameters(), LockFeatureType.class);
        if (lf != null) {
            for (LockType lock : lf.getLock()) {
                lock.setTypeName(this.qualifyTypeName(lock.getTypeName(), workspace, ns));
            }
            return;
        }
        TransactionType t = (TransactionType)OwsUtils.parameter((Object[])operation.getParameters(), TransactionType.class);
        if (t != null) {
            for (UpdateElementType up : t.getUpdate()) {
                up.setTypeName(this.qualifyTypeName(up.getTypeName(), workspace, ns));
            }
            for (DeleteElementType del : t.getDelete()) {
                del.setTypeName(this.qualifyTypeName(del.getTypeName(), workspace, ns));
            }
            for (InsertElementType in : t.getInsert()) {
                for (Feature f : in.getFeature()) {
                    Name n = f.getType().getName();
                    if (n.getNamespaceURI() == null || ns.getURI().equals(n.getNamespaceURI())) continue;
                    throw new WFSException("No such feature type " + n);
                }
            }
        }
    }

    void qualifyTypeNames(List names, WorkspaceInfo ws, NamespaceInfo ns) {
        int i = 0;
        while (i < names.size()) {
            QName name = (QName)names.get(i);
            names.set(i, this.qualifyTypeName(name, ws, ns));
            ++i;
        }
    }

    QName qualifyTypeName(QName name, WorkspaceInfo ws, NamespaceInfo ns) {
        return new QName(ns.getURI(), name.getLocalPart(), ws.getName());
    }
}

