/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.response.WFSResponse;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.filter.identity.FeatureId;

public class LockFeatureTypeResponse
extends WFSResponse {
    Catalog catalog;
    WFSConfiguration configuration;

    public LockFeatureTypeResponse(GeoServer gs, WFSConfiguration configuration) {
        super(gs, LockFeatureResponseType.class);
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        FeatureId featureId;
        Iterator i;
        WFSInfo wfs = this.getInfo();
        LockFeatureResponseType lockResponse = (LockFeatureResponseType)value;
        if (new Version("1.1.0").equals((Object)operation.getService().getVersion())) {
            this.write1_1(lockResponse, output, operation);
            return;
        }
        String indent = wfs.isVerbose() ? "   " : "";
        Charset charset = Charset.forName(wfs.getGeoServer().getGlobal().getCharset());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, charset));
        LockFeatureType lft = (LockFeatureType)operation.getParameters()[0];
        writer.write("<?xml version=\"1.0\" encoding=\"" + charset.name() + "\"?>");
        writer.write("<WFS_LockFeatureResponse \n");
        writer.write(String.valueOf(indent) + "xmlns=\"http://www.opengis.net/wfs\" " + "\n");
        writer.write(String.valueOf(indent) + "xmlns:ogc=\"http://www.opengis.net/ogc\" " + "\n");
        writer.write(String.valueOf(indent) + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " + "\n");
        writer.write(String.valueOf(indent) + "xsi:schemaLocation=\"http://www.opengis.net/wfs ");
        writer.write(ResponseUtils.buildSchemaURL((String)lft.getBaseUrl(), (String)"wfs/1.0.0/WFS-transaction.xsd"));
        writer.write("\">\n");
        writer.write(String.valueOf(indent) + "<LockId>" + lockResponse.getLockId() + "</LockId>" + "\n");
        EList featuresLocked = null;
        if (lockResponse.getFeaturesLocked() != null) {
            featuresLocked = lockResponse.getFeaturesLocked().getFeatureId();
        }
        EList featuresNotLocked = null;
        if (lockResponse.getFeaturesNotLocked() != null) {
            featuresNotLocked = lockResponse.getFeaturesNotLocked().getFeatureId();
        }
        if (featuresLocked != null && !featuresLocked.isEmpty()) {
            writer.write(String.valueOf(indent) + "<FeaturesLocked>" + "\n");
            i = featuresLocked.iterator();
            while (i.hasNext()) {
                writer.write(String.valueOf(indent) + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write(String.valueOf(indent) + "</FeaturesLocked>" + "\n");
        }
        if (featuresNotLocked != null && !featuresNotLocked.isEmpty()) {
            writer.write("<FeaturesNotLocked>\n");
            i = featuresNotLocked.iterator();
            while (i.hasNext()) {
                writer.write(String.valueOf(indent) + indent);
                featureId = (FeatureId)i.next();
                writer.write("<ogc:FeatureId fid=\"" + featureId + "\"/>" + "\n");
            }
            writer.write("</FeaturesNotLocked>\n");
        }
        writer.write("</WFS_LockFeatureResponse>");
        writer.flush();
    }

    void write1_1(LockFeatureResponseType lockResponse, OutputStream output, Operation operation) throws IOException {
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(Charset.forName(this.getInfo().getGeoServer().getGlobal().getCharset()));
        LockFeatureType req = (LockFeatureType)operation.getParameters()[0];
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.buildSchemaURL((String)req.getBaseUrl(), (String)"schemas/wfs/1.1.0/wfs.xsd"));
        encoder.encode((Object)lockResponse, WFS.LOCKFEATURERESPONSE, output);
        output.flush();
    }
}

