/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_0_0;

import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.xml.WFSURIHandler;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

public class WfsXmlReader
extends XmlRequestReader {
    Configuration configuration;
    GeoServer geoServer;

    public WfsXmlReader(String element, Configuration configuration, GeoServer geoServer) {
        this(element, configuration, geoServer, "wfs");
    }

    protected WfsXmlReader(String element, Configuration configuration, GeoServer geoServer, String serviceId) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.0.0"), serviceId);
        this.configuration = configuration;
        this.geoServer = geoServer;
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        Catalog catalog = this.geoServer.getCatalog();
        Boolean strict = (Boolean)kvp.get("strict");
        if (strict == null) {
            strict = Boolean.FALSE;
        }
        Parser parser = new Parser(this.configuration);
        List namespaces = catalog.getNamespaces();
        for (NamespaceInfo ns : namespaces) {
            parser.getNamespaces().declarePrefix(ns.getPrefix(), ns.getURI());
        }
        parser.setValidating(strict.booleanValue());
        parser.getURIHandlers().add(new WFSURIHandler(this.geoServer));
        Object parsed = parser.parse(reader);
        if (strict.booleanValue() && !parser.getValidationErrors().isEmpty()) {
            WFSException exception = new WFSException("Invalid request", "InvalidParameterValue");
            for (Exception error : parser.getValidationErrors()) {
                exception.getExceptionText().add(error.getLocalizedMessage());
            }
            throw exception;
        }
        return parsed;
    }
}

