/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import junit.framework.Test;
import org.geoserver.config.ServiceInfo;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GeometrylessTest
extends WFSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GeometrylessTest());
    }

    public void testGetFeature10() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs");
        GeometrylessTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GeometrylessTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        GeometrylessTest.assertEquals((int)3, (int)featureMembers.getLength());
    }

    public void testGetFeatureReproject10() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.0.0&service=wfs&srsName=EPSG:900913");
        GeometrylessTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GeometrylessTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        GeometrylessTest.assertEquals((int)3, (int)featureMembers.getLength());
    }

    public void testGetFeature11() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.1.0&service=wfs");
        GeometrylessTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMembers");
        GeometrylessTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        GeometrylessTest.assertEquals((int)3, (int)features.getLength());
    }

    public void testGetFeatureReproject11() throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cite:Geometryless&version=1.1.0&service=wfs&srsName=EPSG:900913");
        GeometrylessTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMembers");
        GeometrylessTest.assertFalse((featureMembers.getLength() == 0 ? 1 : 0) != 0);
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        GeometrylessTest.assertEquals((int)3, (int)features.getLength());
    }

    public void testGetFeatureReprojectPost() throws Exception {
        String request = "<wfs:GetFeature service=\"WFS\" xmlns:wfs=\"http://www.opengis.net/wfs\" version=\"1.0.0\"  outputFormat=\"GML2\" xmlns:topp=\"http://www.openplans.org/topp\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.0.0/WFS-basic.xsd\"><wfs:Query typeName=\"cite:Geometryless\" srsName=\"EPSG:900913\"/></wfs:GetFeature>";
        System.out.println(request);
        Document doc = this.postAsDOM("wfs", request);
        GeometrylessTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList featureMembers = doc.getElementsByTagName("gml:featureMember");
        GeometrylessTest.assertEquals((int)3, (int)featureMembers.getLength());
        NodeList features = doc.getElementsByTagName("cite:Geometryless");
        GeometrylessTest.assertEquals((int)3, (int)features.getLength());
    }
}

