/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.gml2.GML;
import org.geotools.xml.Schemas;

public class FeatureTypeInfoSchemaBuilderTest
extends WFSTestSupport {
    public void testBuildGml2() throws Exception {
        FeatureTypeSchemaBuilder.GML2 builder = new FeatureTypeSchemaBuilder.GML2(this.getGeoServer());
        FeatureTypeInfo lines = this.getFeatureTypeInfo(MockData.LINES);
        XSDSchema schema = builder.build(new FeatureTypeInfo[]{lines}, null);
        FeatureTypeInfoSchemaBuilderTest.assertNotNull((Object)schema);
        XSDElementDeclaration element = Schemas.getElementDeclaration((XSDSchema)schema, (QName)MockData.LINES);
        FeatureTypeInfoSchemaBuilderTest.assertNotNull((Object)element);
        FeatureTypeInfoSchemaBuilderTest.assertTrue((boolean)(element.getType() instanceof XSDComplexTypeDefinition));
        XSDElementDeclaration id = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(MockData.CGF_URI, "id"));
        FeatureTypeInfoSchemaBuilderTest.assertNotNull((Object)id);
        XSDElementDeclaration lineStringProperty = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(MockData.CGF_URI, "lineStringProperty"));
        FeatureTypeInfoSchemaBuilderTest.assertNotNull((Object)lineStringProperty);
        XSDTypeDefinition lineStringPropertyType = lineStringProperty.getType();
        FeatureTypeInfoSchemaBuilderTest.assertEquals((String)"http://www.opengis.net/gml", (String)lineStringPropertyType.getTargetNamespace());
        FeatureTypeInfoSchemaBuilderTest.assertEquals((String)GML.LINESTRINGPROPERTYTYPE.getLocalPart(), (String)lineStringPropertyType.getName());
        XSDTypeDefinition geometryAssociationType = lineStringPropertyType.getBaseType();
        FeatureTypeInfoSchemaBuilderTest.assertNotNull((Object)geometryAssociationType);
        FeatureTypeInfoSchemaBuilderTest.assertEquals((String)"http://www.opengis.net/gml", (String)geometryAssociationType.getTargetNamespace());
        FeatureTypeInfoSchemaBuilderTest.assertEquals((String)GML.GEOMETRYASSOCIATIONTYPE.getLocalPart(), (String)geometryAssociationType.getName());
    }
}

