/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class RemappingFeatureCollection
extends DecoratingFeatureCollection<SimpleFeatureType, SimpleFeature> {
    Map<String, String> attributesMapping;

    public RemappingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, Map<String, String> attributesMapping) {
        super(delegate);
        this.attributesMapping = attributesMapping;
    }

    public SimpleFeatureType getSchema() {
        return this.remapSchema((SimpleFeatureType)this.delegate.getSchema());
    }

    static Map<String, String> invertMappings(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : map.keySet()) {
            result.put(map.get(key), key);
        }
        return result;
    }

    private SimpleFeatureType remapSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                GeometryDescriptor geoDesc = (GeometryDescriptor)attDesc;
                builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding(), geoDesc.getCoordinateReferenceSystem());
                continue;
            }
            builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding());
        }
        return builder.buildFeatureType();
    }

    public Iterator<SimpleFeature> iterator() {
        return new RemappingIterator(this.delegate.iterator(), this.attributesMapping, this.getSchema());
    }

    public void close(Iterator<SimpleFeature> iterator) {
        RemappingIterator remapping = (RemappingIterator)iterator;
        this.delegate.close(remapping.delegate);
    }

    public FeatureIterator<SimpleFeature> features() {
        return new DelegateFeatureIterator((FeatureCollection)this, this.iterator());
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        DelegateFeatureIterator delegate = (DelegateFeatureIterator)iterator;
        delegate.close();
    }

    static SimpleFeature remap(SimpleFeature source, Map<String, String> attributeMappings, SimpleFeatureBuilder builder) {
        SimpleFeatureType target = builder.getFeatureType();
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            String mappedName = attributeMappings.get(attributeType.getLocalName());
            if (source.getFeatureType().getDescriptor(mappedName) != null) {
                value = source.getAttribute(mappedName);
            }
            builder.add(value);
        }
        return builder.buildFeature(source.getIdentifier().getID());
    }

    public static class RemappingIterator
    implements Iterator<SimpleFeature> {
        Map<String, String> attributesMapping;
        Iterator<SimpleFeature> delegate;
        SimpleFeatureBuilder builder;

        public RemappingIterator(Iterator<SimpleFeature> delegate, Map attributesMapping, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.attributesMapping = RemappingFeatureCollection.invertMappings(attributesMapping);
            this.builder = new SimpleFeatureBuilder(schema);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            return RemappingFeatureCollection.remap(this.delegate.next(), this.attributesMapping, this.builder);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

