/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.responses;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wms.responses.MapDecoration;
import org.geoserver.wms.responses.MetatiledMapDecorationLayout;
import org.geotools.util.logging.Logging;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;

public class MapDecorationLayout {
    private static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private List<Block> blocks = new ArrayList<Block>();

    public static MapDecorationLayout fromFile(File f, boolean tiled) throws Exception {
        MapDecorationLayout dl = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        Document confFile = new SAXBuilder().build(f);
        for (Element e : confFile.getRootElement().getChildren("decoration")) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Element option : e.getChildren("option")) {
                m.put(option.getAttributeValue("name"), option.getAttributeValue("value"));
            }
            MapDecoration decoration = MapDecorationLayout.getDecoration(e.getAttributeValue("type"));
            if (decoration == null) {
                LOGGER.log(Level.WARNING, "Unknown decoration type: " + e.getAttributeValue("type") + " requested.");
                continue;
            }
            decoration.loadOptions(m);
            Block.Position pos = Block.Position.fromString(e.getAttributeValue("affinity"));
            if (pos == null) {
                LOGGER.log(Level.WARNING, "Unknown affinity: " + e.getAttributeValue("affinity") + " requested.");
                continue;
            }
            Dimension size = null;
            try {
                if (e.getAttributeValue("size") != null && !e.getAttributeValue("size").equalsIgnoreCase("auto")) {
                    String[] sizeArr = e.getAttributeValue("size").split(",");
                    size = new Dimension(Integer.valueOf(sizeArr[0]), Integer.valueOf(sizeArr[1]));
                }
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret size parameter: " + e.getAttributeValue("size"), e);
            }
            Point offset = null;
            try {
                String[] offsetArr = e.getAttributeValue("offset").split(",");
                offset = new Point(Integer.valueOf(offsetArr[0]), Integer.valueOf(offsetArr[1]));
            }
            catch (Exception exc) {
                LOGGER.log(Level.WARNING, "Couldn't interpret size parameter: " + e.getAttributeValue("offset"));
                offset = new Point(0, 0);
            }
            dl.addBlock(new Block(decoration, pos, size, offset));
        }
        return dl;
    }

    public void addBlock(Block b) {
        this.blocks.add(b);
    }

    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContext mapContext) {
        for (Block b : this.blocks) {
            try {
                b.paint(g2d, paintArea, mapContext);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "couldn't paint due to: ", e);
            }
        }
    }

    private static MapDecoration getDecoration(String name) {
        Object o = GeoServerExtensions.bean((String)name);
        if (o instanceof MapDecoration) {
            return (MapDecoration)o;
        }
        return null;
    }

    public static class Block {
        final MapDecoration decoration;
        final Position position;
        final Dimension dimension;
        final Point offset;

        public static Rectangle findBounds(Position p, Rectangle container, Dimension dim, Point o) {
            if (p == null || container == null || dim == null || o == null) {
                throw new WmsException("Bad params for decoration sizing.");
            }
            int x = 0;
            int y = 0;
            int height = dim.height;
            int width = dim.width;
            switch (p) {
                case UL: 
                case UC: 
                case UR: {
                    y = (int)(container.getMinY() + (double)o.y);
                    break;
                }
                case CL: 
                case CC: 
                case CR: {
                    y = (int)(container.getMinY() + container.getMaxY() - (double)dim.height) / 2;
                    break;
                }
                case LL: 
                case LC: 
                case LR: {
                    y = (int)(container.getMaxY() - (double)o.y - (double)dim.height);
                }
            }
            switch (p) {
                case UL: 
                case CL: 
                case LL: {
                    x = (int)(container.getMinX() + (double)o.x);
                    break;
                }
                case UC: 
                case CC: 
                case LC: {
                    x = (int)(container.getMinX() + container.getMaxX()) / 2;
                    break;
                }
                case UR: 
                case CR: 
                case LR: {
                    x = (int)(container.getMaxX() - (double)o.x - (double)dim.width);
                }
            }
            if (dim.width + 2 * o.x > container.width) {
                x = (int)container.getMinX() + o.x;
                width = container.width - 2 * o.x;
            }
            if (dim.height + 2 * o.y > container.height) {
                y = (int)container.getMinY() + o.y;
                height = container.height - 2 * o.y;
            }
            return new Rectangle(x, y, width, height);
        }

        public Block(MapDecoration d, Position p, Dimension dim, Point o) {
            this.decoration = d;
            this.position = p;
            this.dimension = dim;
            this.offset = o;
        }

        public Dimension findOptimalSize(Graphics2D g2d, WMSMapContext mapContext) {
            return this.dimension != null ? this.dimension : this.decoration.findOptimalSize(g2d, mapContext);
        }

        public void paint(Graphics2D g2d, Rectangle rect, WMSMapContext mapContext) throws Exception {
            Dimension desiredSize = this.findOptimalSize(g2d, mapContext);
            Rectangle box = Block.findBounds(this.position, rect, desiredSize, this.offset);
            Shape oldClip = g2d.getClip();
            g2d.setClip(box);
            this.decoration.paint(g2d, box, mapContext);
            g2d.setClip(oldClip);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Position {
            UL("top,left"),
            UC("top,center"),
            UR("top,right"),
            CL("center,left"),
            CC("center,center"),
            CR("center,right"),
            LL("bottom,left"),
            LC("bottom,center"),
            LR("bottom,right");

            private final String name;

            private Position(String name) {
                this.name = name;
            }

            public static Position fromString(String str) {
                Position[] positionArray = Position.values();
                int n = positionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Position p = positionArray[n2];
                    if (p.name.equalsIgnoreCase(str)) {
                        return p;
                    }
                    ++n2;
                }
                return null;
            }
        }
    }
}

