/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.kvp.GetMapKvpRequestReader;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.FeatureTypes;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.GETMAPValidator;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMapXmlReader
extends XmlRequestReader {
    private static final StyleFactory styleFactory = StyleFactoryFinder.createStyleFactory();
    private WMS wms;

    public GetMapXmlReader(WMS wms) {
        super((ServiceInfo)wms.getServiceInfo());
        this.wms = wms;
    }

    public WMS getWMS() {
        return this.wms;
    }

    public Request read(Reader reader, HttpServletRequest req) throws WmsException {
        GetMapRequest getMapRequest = new GetMapRequest(this.getWMS());
        getMapRequest.setHttpServletRequest(req);
        boolean validateSchema = this.wantToValidate(req);
        try {
            this.parseGetMapXML(reader, getMapRequest, validateSchema);
        }
        catch (UnknownHostException unh) {
            throw new WmsException("unknown host - " + unh.getLocalizedMessage() + " - if its in a !DOCTYPE, remove the !DOCTYPE tag.");
        }
        catch (SAXParseException se) {
            throw new WmsException("line " + se.getLineNumber() + " column " + se.getColumnNumber() + " -- " + se.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new WmsException(e);
        }
        return getMapRequest;
    }

    private void parseGetMapXML(Reader xml, GetMapRequest getMapRequest, boolean validateSchema) throws Exception {
        File temp = null;
        try {
            NamedNodeMap atts;
            Node wmsVersion;
            Element rootNode;
            if (validateSchema) {
                int c;
                temp = File.createTempFile("getMapPost", "xml");
                FileOutputStream fos = new FileOutputStream(temp);
                BufferedOutputStream out = new BufferedOutputStream(fos);
                while (-1 != (c = xml.read())) {
                    out.write(c);
                }
                xml.close();
                out.flush();
                out.close();
                xml = new BufferedReader(new FileReader(temp));
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource input = new InputSource(xml);
            Document dom = db.parse(input);
            SLDParser sldParser = new SLDParser(styleFactory);
            Element nodeGetMap = rootNode = dom.getDocumentElement();
            if (!this.nodeNameEqual(nodeGetMap, "getmap")) {
                if (this.nodeNameEqual(nodeGetMap, "StyledLayerDescriptor")) {
                    if (validateSchema) {
                        this.validateSchemaSLD(temp, getMapRequest);
                    }
                    this.handlePostGet(rootNode, sldParser, getMapRequest);
                    return;
                }
                throw new Exception("GetMap XML parser - start node isnt 'GetMap' or 'StyledLayerDescriptor' tag");
            }
            if (validateSchema) {
                this.validateSchemaGETMAP(temp, getMapRequest);
            }
            if ((wmsVersion = (atts = nodeGetMap.getAttributes()).getNamedItem("version")) == null) {
                throw new Exception("GetMap XML parser - couldnt find attribute 'version' in GetMap tag");
            }
            getMapRequest.setVersion(wmsVersion.getNodeValue());
            this.parseBBox(getMapRequest, nodeGetMap);
            StyledLayerDescriptor sld = sldParser.parseDescriptor(this.getNode(rootNode, "StyledLayerDescriptor"));
            this.processStyles(getMapRequest, sld);
            this.parseXMLOutput(nodeGetMap, getMapRequest);
            getMapRequest.setExceptions(this.getNodeValue(nodeGetMap, "Exceptions"));
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private void handlePostGet(Node rootNode, SLDParser sldParser, GetMapRequest getMapRequest) throws Exception {
        HttpServletRequest request = getMapRequest.getHttpServletRequest();
        String qString = request.getQueryString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("reading request: ").append(qString).toString());
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        GetMapKvpRequestReader kvpReader = new GetMapKvpRequestReader(this.getWMS());
        StyledLayerDescriptor sld = sldParser.parseDescriptor(rootNode);
        this.processStyles(getMapRequest, sld);
    }

    private void processStyles(GetMapRequest getMapRequest, StyledLayerDescriptor sld) throws Exception {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        StyledLayer sl = null;
        int i = 0;
        while (i < slCount) {
            MapLayerInfo currLayer;
            sl = styledLayers[i];
            String layerName = sl.getName();
            if (layerName == null) {
                throw new WmsException("A UserLayer without layer name was passed");
            }
            boolean isBaseMap = false;
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                UserLayer ul = (UserLayer)sl;
                DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
                currLayer = GetMapXmlReader.initializeInlineFeatureLayer(ul, (CoordinateReferenceSystem)crs);
                GetMapXmlReader.addStyles(getMapRequest, currLayer, styledLayers[i], layers, styles);
            } else {
                LayerGroupInfo layerGroup = this.getWMS().getLayerGroupByName(layerName);
                if (layerGroup != null) {
                    for (LayerInfo layer : layerGroup.getLayers()) {
                        currLayer = new MapLayerInfo(layer);
                        GetMapXmlReader.addStyles(getMapRequest, currLayer, styledLayers[i], layers, styles);
                    }
                } else {
                    LayerInfo layerInfo = this.getWMS().getLayerByName(layerName);
                    if (layerInfo == null) {
                        throw new WmsException("Layer not found: " + layerName);
                    }
                    currLayer = new MapLayerInfo(layerInfo);
                    GetMapXmlReader.addStyles(getMapRequest, currLayer, styledLayers[i], layers, styles);
                }
            }
            ++i;
        }
        getMapRequest.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        getMapRequest.setStyles(styles);
    }

    public static void addStyles(GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List<MapLayerInfo> layers, List<Style> styles) throws WmsException, IOException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            t = 0;
            while (t < length) {
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() != null) {
                    boolean matches;
                    String ftc_name = ftc.getFeatureTypeName();
                    try {
                        FeatureType currSchema = currLayer.getFeature().getFeatureType();
                        matches = currSchema.getName().getLocalPart().equalsIgnoreCase(ftc_name) || FeatureTypes.isDecendedFrom((FeatureType)currSchema, null, (String)ftc_name);
                    }
                    catch (Exception e) {
                        matches = false;
                    }
                    if (!matches) {
                        // empty if block
                    }
                }
                ++t;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        t = 0;
        while (t < length) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                String styleName = ((NamedStyle)layerStyles[t]).getName();
                Style s = request.getWMS().getStyleByName(styleName);
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + styleName + "'");
                }
                styles.add(s);
            } else {
                layers.add(currLayer);
                styles.add(layerStyles[t]);
            }
            ++t;
        }
    }

    private static MapLayerInfo initializeInlineFeatureLayer(UserLayer ul, CoordinateReferenceSystem requestCrs) throws Exception {
        FeatureSource source;
        DataStore inlineDatastore = ul.getInlineFeatureDatastore();
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            DefaultQuery q = new DefaultQuery(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            FeatureReader ilReader = inlineDatastore.getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
            ForceCoordinateSystemFeatureReader reader = new ForceCoordinateSystemFeatureReader(ilReader, requestCrs);
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)reader);
            source = reTypedDS.getFeatureSource(reTypedDS.getTypeNames()[0]);
        } else {
            source = inlineDatastore.getFeatureSource(inlineDatastore.getTypeNames()[0]);
        }
        MapLayerInfo mapLayer = new MapLayerInfo((FeatureSource<SimpleFeatureType, SimpleFeature>)source);
        return mapLayer;
    }

    private void parseBBox(GetMapRequest getMapRequest, Node nodeGetMap) throws Exception {
        Node bboxNode = this.getNode(nodeGetMap, "BoundingBox");
        if (bboxNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'BoundingBox' in GetMap tag");
        }
        List coordList = ExpressionDOMParser.parseCoords((Node)bboxNode);
        if (coordList.size() != 2) {
            throw new Exception("GetMap XML parser - node 'BoundingBox' in GetMap tag should have 2 coordinates in it");
        }
        Envelope env = new Envelope();
        int size = coordList.size();
        int i = 0;
        while (i < size) {
            env.expandToInclude((Coordinate)coordList.get(i));
            ++i;
        }
        getMapRequest.setBbox(env);
        NamedNodeMap atts = bboxNode.getAttributes();
        Node srsNode = atts.getNamedItem("srsName");
        if (srsNode != null) {
            String srs = srsNode.getNodeValue();
            String epsgCode = srs.substring(srs.indexOf(35) + 1);
            epsgCode = "EPSG:" + epsgCode;
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMapRequest.setCrs(mapcrs);
                getMapRequest.setSRS(epsgCode);
            }
            catch (Exception e) {
                throw new WmsException(e.getLocalizedMessage(), "InvalidSRS");
            }
        }
    }

    private void parseXMLOutput(Node nodeGetMap, GetMapRequest getMapRequest) throws Exception {
        Node sizeNode;
        String bgColor;
        String bufferValue;
        Node outputNode = this.getNode(nodeGetMap, "Output");
        if (outputNode == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Output' in GetMap tag");
        }
        String format = this.getNodeValue(outputNode, "Format");
        if (format == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Format' in GetMap/Output tag");
        }
        getMapRequest.setFormat(format);
        String trans = this.getNodeValue(outputNode, "Transparent");
        if (trans != null) {
            if (trans.equalsIgnoreCase("false") || trans.equalsIgnoreCase("0")) {
                getMapRequest.setTransparent(false);
            } else {
                getMapRequest.setTransparent(true);
            }
        }
        if ((bufferValue = this.getNodeValue(outputNode, "Buffer")) == null) {
            this.getNodeValue(outputNode, "Radius");
        }
        if (bufferValue != null) {
            getMapRequest.setBuffer(Integer.parseInt(bufferValue));
        }
        if ((bgColor = this.getNodeValue(outputNode, "BGcolor")) != null) {
            getMapRequest.setBgColor(Color.decode(bgColor));
        }
        if ((sizeNode = this.getNode(outputNode, "Size")) == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Size' in GetMap/Output tag");
        }
        String width = this.getNodeValue(sizeNode, "Width");
        if (width == null) {
            throw new Exception("GetMap XML parser - couldnt find node 'Width' in GetMap/Output/Size tag");
        }
        getMapRequest.setWidth(Integer.parseInt(width));
        String height = this.getNodeValue(sizeNode, "Height");
        if (width == null) {
            // empty if block
        }
        getMapRequest.setHeight(Integer.parseInt(height));
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    public String getNodeValue(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child != null && child.getNodeType() == 1) {
                String childName = child.getLocalName();
                if (childName == null) {
                    childName = child.getNodeName();
                }
                if (childName.equalsIgnoreCase(wantedChildName)) {
                    return child.getChildNodes().item(0).getNodeValue();
                }
            }
            ++i;
        }
        return null;
    }

    public boolean nodeNameEqual(Node n, String name) {
        if (n.getNodeName().equalsIgnoreCase(name)) {
            return true;
        }
        String nname = n.getNodeName();
        int idx = nname.indexOf(58);
        if (idx == -1) {
            return false;
        }
        return nname.substring(idx + 1).equalsIgnoreCase(name);
    }

    public void validateSchemaSLD(File f, GetMapRequest getMapRequest) throws Exception {
        SLDValidator validator = new SLDValidator();
        List errors = null;
        try {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                errors = validator.validateSLD((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (errors.size() != 0) {
                in = new FileInputStream(f);
                throw new WmsException(SLDValidator.getErrorMessage((InputStream)in, (List)errors));
            }
        }
        catch (IOException e) {
            String msg = new StringBuffer("Creating remote SLD url: ").append(e.getMessage()).toString();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new WmsException(e, msg, "parseSldParam");
        }
    }

    public void validateSchemaGETMAP(File f, GetMapRequest getMapRequest) throws Exception {
        GETMAPValidator validator = new GETMAPValidator();
        List errors = null;
        try {
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                errors = validator.validateGETMAP((InputStream)in, getMapRequest.getHttpServletRequest().getSession().getServletContext());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            if (errors.size() != 0) {
                in = new FileInputStream(f);
                throw new WmsException(GETMAPValidator.getErrorMessage((InputStream)in, (List)errors));
            }
        }
        catch (IOException e) {
            String msg = new StringBuffer("Creating remote GETMAP url: ").append(e.getMessage()).toString();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw new WmsException(e, msg, "GETMAP validator");
        }
    }

    private boolean wantToValidate(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return (queryString = queryString.toLowerCase()).startsWith("validateschema") || queryString.indexOf("&validateschema") != -1;
    }
}

