/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.helpers.WMSCapsTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSCapabilitiesResponse
implements Response {
    private static final Logger LOGGER = Logging.getLogger((String)WMSCapabilitiesResponse.class.getPackage().getName());
    private byte[] rawResponse;
    private Set<String> mapFormats;
    private ApplicationContext applicationContext;

    public WMSCapabilitiesResponse(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.mapFormats = WMSCapabilitiesResponse.loadImageFormats(applicationContext);
    }

    private static Set<String> loadImageFormats(ApplicationContext applicationContext) {
        List<GetMapProducer> producers = WMSExtensions.findMapProducers(applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapProducer producer : producers) {
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        long geoUS;
        if (!(request instanceof CapabilitiesRequest)) {
            throw new IllegalArgumentException("Not a GetCapabilities Request");
        }
        WMSCapabilitiesRequest capreq = (WMSCapabilitiesRequest)request;
        WMS wmsConfig = capreq.getWMS();
        long reqUS = -1L;
        if (capreq.getUpdateSequence() != null && !"".equals(capreq.getUpdateSequence().trim())) {
            try {
                reqUS = Long.parseLong(capreq.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = wmsConfig.getUpdateSequence())) {
            throw new ServiceException("Client supplied an updateSequence that is greater than the current sever updateSequence", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new ServiceException("WMS capabilities document is current (updateSequence = " + geoUS + ")", "CurrentUpdateSequence");
        }
        Set legendFormats = GetLegendGraphicResponse.getFormats();
        WMSCapsTransformer transformer = new WMSCapsTransformer(request.getBaseUrl(), this.mapFormats, legendFormats);
        transformer.setIndentation(2);
        WMS wms = (WMS)this.applicationContext.getBean("wms");
        Charset encoding = wms.getCharSet();
        transformer.setEncoding(encoding);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            transformer.transform(request, out);
        }
        catch (TransformerException e) {
            throw new WmsException(e);
        }
        this.rawResponse = out.toByteArray();
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        return "application/vnd.ogc.wms_xml";
    }

    public String getContentEncoding() {
        return null;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("No raw response presents!");
        }
        out.write(this.rawResponse);
    }

    public void abort(ServiceInfo gs) {
    }

    public String getContentDisposition() {
        return null;
    }
}

