/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.raster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.util.NumberRange;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.LegendUtils;
import org.vfny.geoserver.wms.responses.legend.raster.ColorMapLegendCreator;
import org.vfny.geoserver.wms.responses.legend.raster.PackagedUtils;

public class RasterLayerLegendHelper {
    private static final BufferedImage defaultLegend;
    private BufferedImage image;
    private RasterSymbolizer rasterSymbolizer;
    private int width;
    private int height;
    private boolean transparent;
    private Color bgColor;
    private ColorMapLegendCreator cMapLegendCreator;

    static {
        BufferedImage imgShape = null;
        try {
            File stylesDirectory = GeoserverDataDirectory.findCreateConfigDir((String)"styles");
            File rasterLegend = new File(stylesDirectory, "rasterLegend.png");
            if (rasterLegend.exists()) {
                imgShape = ImageIO.read(rasterLegend);
            }
        }
        catch (Throwable e) {
            imgShape = null;
        }
        defaultLegend = imgShape;
    }

    public RasterLayerLegendHelper(GetLegendGraphicRequest request) {
        PackagedUtils.ensureNotNull((Object)request, "The provided GetLegendGraphicRequest is null");
        this.parseRequest(request);
    }

    private void parseRequest(GetLegendGraphicRequest request) {
        Style gt2Style = request.getStyle();
        FeatureTypeStyle[] ftStyles = gt2Style.getFeatureTypeStyles();
        double scaleDenominator = request.getScale();
        Rule[] applicableRules = request.getRule() != null ? new Rule[]{request.getRule()} : LegendUtils.getApplicableRules(ftStyles, scaleDenominator);
        if (applicableRules.length != 1) {
            throw new IllegalArgumentException("Unable to create a legend for this style, we need exactly 1 rule");
        }
        NumberRange scaleRange = NumberRange.create((double)scaleDenominator, (double)scaleDenominator);
        this.width = request.getWidth();
        this.height = request.getHeight();
        if (this.width <= 0 || this.height <= 0) {
            throw new IllegalArgumentException("Invalid widht and or height for the GetLegendGraphicRequest");
        }
        Symbolizer[] symbolizers = applicableRules[0].getSymbolizers();
        if (symbolizers == null || symbolizers.length != 1 | symbolizers[0] == null) {
            throw new IllegalArgumentException("Unable to create a legend for this style, we need exactly 1 Symbolizer");
        }
        Symbolizer symbolizer = symbolizers[0];
        if (!(symbolizer instanceof RasterSymbolizer)) {
            throw new IllegalArgumentException("Unable to create a legend for this style, we need a RasterSymbolizer");
        }
        this.rasterSymbolizer = (RasterSymbolizer)symbolizer;
        this.transparent = request.isTransparent();
        this.bgColor = LegendUtils.getBackgroundColor(request);
        ColorMap cmap = this.rasterSymbolizer.getColorMap();
        ColorMapLegendCreator.Builder cmapLegendBuilder = new ColorMapLegendCreator.Builder();
        if (cmap != null && cmap.getColorMapEntries() != null && cmap.getColorMapEntries().length > 0) {
            ColorMapEntry[] colorMapEntries;
            cmapLegendBuilder.setAdditionalOptions(request.getLegendOptions());
            cmapLegendBuilder.setColorMapType(cmap.getType());
            cmapLegendBuilder.setExtended(cmap.getExtendedColors());
            cmapLegendBuilder.setRequestedDimension(new Dimension(this.width, this.height));
            cmapLegendBuilder.setTransparent(this.transparent);
            cmapLegendBuilder.setBackgroundColor(this.bgColor);
            cmapLegendBuilder.setLabelFont(LegendUtils.getLabelFont(request));
            cmapLegendBuilder.setLabelFontColor(LegendUtils.getLabelFontColor(request));
            ChannelSelection channelSelection = this.rasterSymbolizer.getChannelSelection();
            cmapLegendBuilder.setBand(channelSelection != null ? channelSelection.getGrayChannel() : null);
            ColorMapEntry[] colorMapEntryArray = colorMapEntries = cmap.getColorMapEntries();
            int n = colorMapEntries.length;
            int n2 = 0;
            while (n2 < n) {
                ColorMapEntry ce = colorMapEntryArray[n2];
                if (ce != null) {
                    cmapLegendBuilder.addColorMapEntry(ce);
                }
                ++n2;
            }
            cmapLegendBuilder.checkAdditionalOptions();
            this.cMapLegendCreator = cmapLegendBuilder.create();
        } else {
            this.cMapLegendCreator = null;
        }
    }

    public BufferedImage getLegend() {
        return this.createResponse();
    }

    private synchronized BufferedImage createResponse() {
        if (this.image == null) {
            if (this.cMapLegendCreator != null) {
                this.image = this.cMapLegendCreator.getLegend();
            } else {
                this.image = ImageUtils.createImage(this.width, this.height, null, this.transparent);
                Graphics2D graphics = ImageUtils.prepareTransparency(this.transparent, this.bgColor, this.image, new HashMap());
                if (defaultLegend == null) {
                    this.drawRasterIcon(graphics);
                } else {
                    graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.drawImage(defaultLegend, 0, 0, this.width, this.height, null);
                }
                graphics.dispose();
            }
        }
        return this.image;
    }

    void drawRasterIcon(Graphics2D graphics) {
        Color blue = new Color(Integer.parseInt("5e72be", 16));
        Color cyan = new Color(Integer.parseInt("a2c0eb", 16));
        graphics.setColor(blue);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(cyan);
        int j = 0;
        while (j < this.height / 2) {
            int i = j % 2;
            while (i < this.width / 2) {
                graphics.fillRect(i * 2, j * 2, 2, 2);
                i += 2;
            }
            ++j;
        }
        GradientPaint paint = new GradientPaint(new Point(0, 0), new Color(0, 0, 255, 0), new Point(this.width, this.height), new Color(0, 0, 255, 100));
        graphics.setPaint(paint);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.BLUE);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

