/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.DateUtil;
import org.geotools.map.MapLayer;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.Converters;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureHeightTemplate;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTimeTemplate;
import org.vfny.geoserver.wms.responses.map.kml.KMLGeometryTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public abstract class KMLMapTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected double scaleDenominator = 1.0;
    NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
    SLDStyleFactory styleFactory = new SLDStyleFactory();
    FeatureTemplate template = new FeatureTemplate();
    protected WMSMapContext mapContext;
    protected final MapLayer mapLayer;
    protected final boolean vectorNameDescription;
    static List dtformats = new ArrayList();
    static List dformats = new ArrayList();
    static List tformats = new ArrayList();

    static {
        dtformats.add(DateFormat.getDateTimeInstance());
        dtformats.add(FeatureTemplate.DATETIME_FORMAT);
        KMLMapTransformer.addFormats(dtformats, "dd%MM%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "MM%dd%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "dd%MM%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "MM%dd%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm");
        dformats.add(DateFormat.getDateInstance());
        dformats.add(FeatureTemplate.DATE_FORMAT);
        KMLMapTransformer.addFormats(dformats, "dd%MM%yy");
        KMLMapTransformer.addFormats(dformats, "MM%dd%yy");
        KMLMapTransformer.addFormats(dformats, "dd%MMM%yy");
        KMLMapTransformer.addFormats(dformats, "MMM%dd%yy");
        tformats.add(DateFormat.getTimeInstance());
        tformats.add(FeatureTemplate.TIME_FORMAT);
    }

    static void addFormats(List formats, String pattern) {
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "-")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "/")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ".")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", " ")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ",")));
    }

    public KMLMapTransformer(WMSMapContext mapContext, MapLayer mapLayer) {
        this.mapContext = mapContext;
        this.mapLayer = mapLayer;
        Object kmAttrObj = mapContext.getRequest().getFormatOptions().get("kmattr");
        this.vectorNameDescription = kmAttrObj != null ? ((Boolean)Converters.convert(kmAttrObj, Boolean.class)).booleanValue() : mapContext.getRequest().getWMS().getKmlKmAttr();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class KMLMapTranslatorSupport
    extends KMLTransformerBase.KMLTranslatorSupport {
        KMLGeometryTransformer.KMLGeometryTranslator geometryTranslator;

        public KMLMapTranslatorSupport(ContentHandler contentHandler) {
            super(KMLMapTransformer.this, contentHandler);
        }

        protected void encodePlacemarkName(SimpleFeature feature, List<Symbolizer> symbolizers) throws IOException {
            String title = KMLMapTransformer.this.template.title(feature);
            boolean trySLD = false;
            if (title == null || "".equals(title)) {
                title = feature.getID();
            }
            if (title.equals(feature.getID())) {
                trySLD = true;
            }
            if (trySLD) {
                StringBuffer label = new StringBuffer();
                for (Symbolizer sym : symbolizers) {
                    if (!(sym instanceof TextSymbolizer)) continue;
                    Expression e = SLD.textLabel((TextSymbolizer)((TextSymbolizer)sym));
                    Object object = null;
                    if (e != null) {
                        object = e.evaluate((Object)feature);
                    }
                    String value = null;
                    if (object instanceof String) {
                        value = (String)object;
                    } else if (object != null) {
                        value = object.toString();
                    }
                    if (value == null || "".equals(value.trim())) continue;
                    label.append(value);
                }
                if (label.length() > 0) {
                    title = label.toString();
                }
            }
            this.start("name");
            this.cdata(title);
            this.end("name");
        }

        protected void encodePlacemarkSnippet(SimpleFeature feature, List<Symbolizer> styles) {
        }

        protected void encodePlacemarkDescription(SimpleFeature feature, List<Symbolizer> styles) throws IOException {
            StringBuilder description = new StringBuilder(KMLMapTransformer.this.template.description(feature));
            try {
                Class.forName("org.geoserver.geosearch.LayerAboutPage");
                description.append("<div> <a href=\"").append(this.getFeatureTypeURL()).append(".html").append("\">Full dataset info and download</a> </div>");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.start("description");
            this.cdata(description.toString());
            this.end("description");
        }

        protected void encodePlacemarkLookAt(Coordinate centroid) {
            this.start("LookAt");
            this.element("longitude", Double.toString(centroid.x));
            this.element("latitude", Double.toString(centroid.y));
            this.element("heading", "10.0");
            this.element("tilt", "10.0");
            this.element("range", "700");
            this.end("LookAt");
        }

        protected List<Symbolizer> filterSymbolizers(SimpleFeature feature, FeatureTypeStyle[] styles) {
            ArrayList<Symbolizer> symbolizerList = new ArrayList<Symbolizer>();
            int j = 0;
            while (j < styles.length) {
                Rule[] rules = KMLUtils.filterRules(styles[j], feature, KMLMapTransformer.this.scaleDenominator);
                int i = 0;
                while (i < rules.length) {
                    symbolizerList.addAll(Arrays.asList(rules[i].getSymbolizers()));
                    ++i;
                }
                ++j;
            }
            return symbolizerList;
        }

        protected void encodeStyle(SimpleFeature feature, List<Symbolizer> symbolizers) {
            if (!symbolizers.isEmpty()) {
                this.start("Style");
                Symbolizer[] symbolizerArray = symbolizers.toArray(new Symbolizer[symbolizers.size()]);
                this.encodeStyle(feature, symbolizerArray);
                this.end("Style");
            }
        }

        protected void encodeDefaultIconStyle(SimpleFeature feature) {
            boolean poly;
            boolean line = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof LineString || feature.getDefaultGeometry() instanceof MultiLineString);
            boolean bl = poly = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof Polygon || feature.getDefaultGeometry() instanceof MultiPolygon);
            if (!line && !poly) {
                LOGGER.log(Level.FINER, "Unexpectedly entered encodeDefaultIconStyle() with something that does not have a multipoint geometry.");
                return;
            }
            this.start("IconStyle");
            if (KMLMapTransformer.this.vectorNameDescription) {
                this.encodeColor("00ffffff");
            }
            if (line || poly) {
                this.element("scale", "0.4");
            }
            this.start("Icon");
            String imageURL = "http://icons.opengeo.org/markers/icon-" + (poly ? "poly.1" : "line.1") + ".png";
            this.element("href", imageURL);
            this.end("Icon");
            this.end("IconStyle");
        }

        protected void encodeDefaultTextStyle() {
            this.start("LabelStyle");
            this.encodeColor("00ffffff");
            this.end("LabelStyle");
        }

        protected void encodeStyle(SimpleFeature feature, Symbolizer[] symbolizers) {
            try {
                Style2D style;
                LinkedList<PointSymbolizer> iconStyles = new LinkedList<PointSymbolizer>();
                LinkedList<TextSymbolizer> labelStyles = new LinkedList<TextSymbolizer>();
                LinkedList<LineSymbolizer> lineStyles = new LinkedList<LineSymbolizer>();
                LinkedList<PolygonSymbolizer> polyStyles = new LinkedList<PolygonSymbolizer>();
                int i = 0;
                while (i < symbolizers.length) {
                    Symbolizer symbolizer = symbolizers[i];
                    if (symbolizer instanceof PointSymbolizer) {
                        iconStyles.add((PointSymbolizer)symbolizer);
                    } else if (symbolizer instanceof TextSymbolizer) {
                        labelStyles.add((TextSymbolizer)symbolizer);
                    } else if (symbolizer instanceof LineSymbolizer) {
                        lineStyles.add((LineSymbolizer)symbolizer);
                    } else if (symbolizer instanceof PolygonSymbolizer) {
                        polyStyles.add((PolygonSymbolizer)symbolizer);
                    }
                    LOGGER.finer(new StringBuffer("Adding symbolizer ").append(symbolizer).toString());
                    ++i;
                }
                if (iconStyles.isEmpty()) {
                    this.encodeDefaultIconStyle(feature);
                } else {
                    for (PointSymbolizer pointSymbolizer : iconStyles) {
                        try {
                            style = KMLMapTransformer.this.styleFactory.createStyle((Object)feature, (Symbolizer)pointSymbolizer, (Range)KMLMapTransformer.this.scaleRange);
                            this.encodePointStyle(feature, style, pointSymbolizer);
                        }
                        catch (IllegalArgumentException iae) {
                            LOGGER.fine(String.valueOf(iae.getMessage()) + " for " + pointSymbolizer.toString());
                        }
                    }
                }
                if (labelStyles.isEmpty()) {
                    this.encodeDefaultTextStyle();
                } else {
                    for (TextSymbolizer textSymbolizer : labelStyles) {
                        try {
                            style = (TextStyle2D)KMLMapTransformer.this.styleFactory.createStyle((Object)feature, (Symbolizer)textSymbolizer, (Range)KMLMapTransformer.this.scaleRange);
                            this.encodeTextStyle(feature, (TextStyle2D)style, textSymbolizer);
                        }
                        catch (IllegalArgumentException iae) {
                            LOGGER.fine(String.valueOf(iae.getMessage()) + " for " + textSymbolizer.toString());
                        }
                    }
                }
                if (!lineStyles.isEmpty()) {
                    for (LineSymbolizer lineSymbolizer : lineStyles) {
                        try {
                            style = (LineStyle2D)KMLMapTransformer.this.styleFactory.createStyle((Object)feature, (Symbolizer)lineSymbolizer, (Range)KMLMapTransformer.this.scaleRange);
                            this.encodeLineStyle(feature, (LineStyle2D)style, lineSymbolizer);
                        }
                        catch (IllegalArgumentException iae) {
                            LOGGER.fine(String.valueOf(iae.getMessage()) + " for " + lineSymbolizer.toString());
                        }
                    }
                }
                if (!polyStyles.isEmpty()) {
                    for (PolygonSymbolizer polygonSymbolizer : polyStyles) {
                        try {
                            style = (PolygonStyle2D)KMLMapTransformer.this.styleFactory.createStyle((Object)feature, (Symbolizer)polygonSymbolizer, (Range)KMLMapTransformer.this.scaleRange);
                            this.encodePolygonStyle(feature, (PolygonStyle2D)style, polygonSymbolizer, !lineStyles.isEmpty());
                        }
                        catch (IllegalArgumentException iae) {
                            LOGGER.fine(String.valueOf(iae.getMessage()) + " for " + polygonSymbolizer.toString());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error occurred during style encoding", e);
            }
        }

        protected void encodePolygonStyle(SimpleFeature feature, PolygonStyle2D style, PolygonSymbolizer symbolizer, boolean forceOutline) {
            double opacity;
            this.start("PolyStyle");
            if (symbolizer.getFill() != null) {
                opacity = ((Number)symbolizer.getFill().getOpacity().evaluate((Object)feature)).doubleValue();
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor((Color)symbolizer.getFill().getColor().evaluate((Object)feature, Color.class), opacity);
            } else {
                this.encodeColor("00aaaaaa");
            }
            if (symbolizer.getStroke() != null || forceOutline) {
                this.element("outline", "1");
            } else {
                this.element("outline", "0");
            }
            this.end("PolyStyle");
            if (symbolizer.getStroke() != null) {
                int width;
                this.start("LineStyle");
                opacity = ((Number)symbolizer.getStroke().getOpacity().evaluate((Object)feature)).doubleValue();
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (style != null) {
                    this.encodeColor(KMLUtils.colorToHex((Color)symbolizer.getStroke().getColor().evaluate((Object)feature, Color.class), opacity));
                }
                if ((width = ((Number)symbolizer.getStroke().getWidth().evaluate((Object)feature)).intValue()) != -1) {
                    this.element("width", Integer.toString(width));
                }
                this.end("LineStyle");
            }
        }

        protected void encodeLineStyle(SimpleFeature feature, LineStyle2D style, LineSymbolizer symbolizer) {
            this.start("LineStyle");
            if (symbolizer.getStroke() != null) {
                double opacity = ((Number)symbolizer.getStroke().getOpacity().evaluate((Object)feature)).doubleValue();
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (symbolizer.getStroke().getColor() != null) {
                    this.encodeColor((Color)symbolizer.getStroke().getColor().evaluate((Object)feature, Color.class), opacity);
                } else if (style != null) {
                    this.encodeColor((Color)style.getContour(), opacity);
                }
                int width = SLD.width((Stroke)symbolizer.getStroke());
                if (width != -1) {
                    this.element("width", Integer.toString(width));
                }
            } else {
                this.encodeColor("ffaaaaaa");
                this.element("width", "1");
            }
            this.end("LineStyle");
        }

        protected void encodePointStyle(SimpleFeature feature, Style2D style, PointSymbolizer symbolizer) {
            Mark mark;
            this.start("IconStyle");
            if (style instanceof MarkStyle2D && (mark = SLD.mark((PointSymbolizer)symbolizer)) != null) {
                double opacity = ((Number)mark.getFill().getOpacity().evaluate((Object)feature)).doubleValue();
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (mark.getFill() != null) {
                    Color color = (Color)mark.getFill().getColor().evaluate((Object)feature, Color.class);
                    this.encodeColor(color, opacity);
                }
            }
            this.element("colorMode", "normal");
            String iconHref = null;
            if (symbolizer.getGraphic() != null && symbolizer.getGraphic().getExternalGraphics() != null && symbolizer.getGraphic().getExternalGraphics().length > 0) {
                ExternalGraphic graphic = symbolizer.getGraphic().getExternalGraphics()[0];
                try {
                    if ("file".equals(graphic.getLocation().getProtocol())) {
                        File file = new File(graphic.getLocation().getFile());
                        iconHref = String.valueOf(RequestUtils.baseURL((HttpServletRequest)KMLMapTransformer.this.mapContext.getRequest().getHttpServletRequest())) + "styles/" + file.getName();
                    } else if ("http".equals(graphic.getLocation().getProtocol())) {
                        iconHref = graphic.getLocation().toString();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error processing external graphic:" + graphic, e);
                }
            }
            if ((iconHref = this.evaluateDynamicSymbolizer(iconHref, feature)) == null) {
                iconHref = "http://maps.google.com/mapfiles/kml/pal4/icon25.png";
            }
            this.start("Icon");
            this.element("href", iconHref);
            this.end("Icon");
            this.end("IconStyle");
        }

        protected String evaluateDynamicSymbolizer(String strLocation, SimpleFeature feature) {
            Expression location;
            if (strLocation == null) {
                return null;
            }
            try {
                location = ExpressionExtractor.extractCqlExpressions((String)strLocation);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Could not parse cql expressions out of " + strLocation, e);
                }
                location = ff.literal((Object)strLocation);
            }
            return location.evaluate((Object)feature).toString();
        }

        protected void encodeTextStyle(SimpleFeature feature, TextStyle2D style, TextSymbolizer symbolizer) {
            this.start("LabelStyle");
            if (symbolizer.getFill() != null) {
                double opacity = ((Number)symbolizer.getFill().getOpacity().evaluate((Object)feature)).doubleValue();
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor((Color)symbolizer.getFill().getColor().evaluate((Object)feature, Color.class), opacity);
            } else {
                this.encodeColor("ffffffff");
            }
            this.end("LabelStyle");
        }

        void encodeColor(Color color, double opacity) {
            this.encodeColor(KMLUtils.colorToHex(color, opacity));
        }

        void encodeColor(String hex) {
            this.element("color", hex);
        }

        Coordinate geometryCentroid(Geometry g) {
            if (g instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)g;
                if (gc.getNumGeometries() == 1) {
                    g = gc.getGeometryN(0);
                } else {
                    double maxAreaSoFar = gc.getGeometryN(0).getArea();
                    Coordinate centroidToReturn = gc.getGeometryN(0).getCentroid().getCoordinate();
                    int t = 0;
                    while (t < gc.getNumGeometries()) {
                        double area = gc.getGeometryN(t).getArea();
                        if (area > maxAreaSoFar) {
                            maxAreaSoFar = area;
                            centroidToReturn = gc.getGeometryN(t).getCentroid().getCoordinate();
                        }
                        ++t;
                    }
                    return centroidToReturn;
                }
            }
            if (g instanceof Point) {
                return g.getCoordinate();
            }
            if (g instanceof LineString) {
                double tol = 1.0E-6;
                double mid = g.getLength() / 2.0;
                Coordinate[] coords = g.getCoordinates();
                double len = 0.0;
                int i = 1;
                while (i < coords.length) {
                    LineSegment line = new LineSegment(coords[i - 1], coords[i]);
                    if (Math.abs((len += line.getLength()) - mid) < tol) {
                        return line.getCoordinate(1);
                    }
                    if (len > mid) {
                        return line.pointAlong(1.0 - (len - mid) / line.getLength());
                    }
                    ++i;
                }
                return g.getCentroid().getCoordinate();
            }
            return g.getCentroid().getCoordinate();
        }

        protected void encodePlacemark(SimpleFeature feature, List<Symbolizer> symbolizers) {
            this.encodePlacemark(feature, symbolizers, null);
        }

        protected void encodePlacemark(SimpleFeature feature, List<Symbolizer> symbolizers, Geometry markGeometry) {
            String selfLinks;
            Geometry geometry = this.featureGeometry(feature);
            Coordinate centroid = this.geometryCentroid(geometry);
            this.start("Placemark", KMLUtils.attributes(new String[]{"id", feature.getID()}));
            if (KMLMapTransformer.this.vectorNameDescription) {
                String msg;
                try {
                    this.encodePlacemarkName(feature, symbolizers);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'title' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                try {
                    this.encodePlacemarkSnippet(feature, symbolizers);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'description' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                try {
                    this.encodePlacemarkDescription(feature, symbolizers);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'description' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
            if ((selfLinks = (String)KMLMapTransformer.this.mapContext.getRequest().getFormatOptions().get("selfLinks")) != null && selfLinks.equalsIgnoreCase("true")) {
                GetMapRequest request = KMLMapTransformer.this.mapContext.getRequest();
                String link = "";
                try {
                    link = this.getFeatureTypeURL();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                String[] id = feature.getID().split("\\.");
                link = String.valueOf(link) + "/" + id[1] + ".kml";
                this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "self", "href", link}));
            }
            this.encodePlacemarkLookAt(centroid);
            try {
                this.encodePlacemarkTime(feature, symbolizers);
            }
            catch (Exception e) {
                String msg = "Error occured processing 'time' template: " + e.getMessage();
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", e);
            }
            this.encodeStyle(feature, symbolizers);
            this.encodeExtendedData(feature);
            if (markGeometry == null) {
                Coordinate labelPoint = KMLMapTransformer.this.vectorNameDescription ? centroid : null;
                this.encodePlacemarkGeometry(geometry, labelPoint, symbolizers);
            } else {
                Coordinate markCentroid = markGeometry.getCoordinate();
                this.start("Point");
                if (!Double.isNaN(markCentroid.z)) {
                    this.element("coordinates", String.valueOf(markCentroid.x) + "," + markCentroid.y + "," + markCentroid.z);
                } else {
                    this.element("coordinates", String.valueOf(markCentroid.x) + "," + markCentroid.y);
                }
                this.end("Point");
            }
            this.end("Placemark");
        }

        protected void encodeExtendedData(SimpleFeature feature) {
        }

        protected String getFeatureTypeURL() throws IOException {
            GeoServer gs = KMLMapTransformer.this.mapContext.getRequest().getWMS().getGeoServer();
            Catalog catalog = gs.getCatalog();
            String nsUri = KMLMapTransformer.this.mapLayer.getFeatureSource().getSchema().getName().getNamespaceURI();
            NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
            String featureTypeName = KMLMapTransformer.this.mapLayer.getFeatureSource().getSchema().getName().getLocalPart();
            GetMapRequest request = KMLMapTransformer.this.mapContext.getRequest();
            return ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)request.getHttpServletRequest()), (String)ResponseUtils.appendPath((String[])new String[]{"rest", ns.getPrefix(), featureTypeName}), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        }

        protected void encodePlacemarkTime(SimpleFeature feature, List<Symbolizer> symbolizers) throws IOException {
            try {
                String[] time = new FeatureTimeTemplate(KMLMapTransformer.this.template).execute(feature);
                if (time.length == 0) {
                    return;
                }
                if (time.length == 1) {
                    this.encodeKmlTimeStamp(this.parseDateTime(time[0]));
                } else {
                    this.encodeKmlTimeSpan(this.parseDateTime(time[0]), this.parseDateTime(time[1]));
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        protected void encodeKmlTimeSpan(Date from, Date to) throws Exception {
            String begin = this.encodeDateTime(from);
            String end = this.encodeDateTime(to);
            if (begin != null || end != null) {
                this.start("TimeSpan");
                if (begin != null) {
                    this.element("begin", begin);
                }
                if (end != null) {
                    this.element("end", end);
                }
                this.end("TimeSpan");
            }
        }

        protected void encodeKmlTimeStamp(Date time) throws Exception {
            String datetime = this.encodeDateTime(time);
            if (datetime != null) {
                this.start("TimeStamp");
                this.element("when", datetime);
                this.end("TimeStamp");
            }
        }

        protected String encodeDateTime(Date date) {
            if (date != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return new XSDateTimeBinding().encode((Object)c, null);
            }
            return null;
        }

        protected Date parseDateTime(String date) throws Exception {
            Date d = this.parseDate(dtformats, date);
            if (d == null) {
                d = this.parseDate(dformats, date);
            }
            if (d == null) {
                d = this.parseDate(tformats, date);
            }
            if (d == null) {
                try {
                    d = DateUtil.deserializeDateTime((String)date);
                }
                catch (Exception e1) {
                    try {
                        d = DateUtil.deserializeDate((String)date);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (d != null) {
                return d;
            }
            LOGGER.warning("Could not parse date: " + date);
            return null;
        }

        protected Date parseDate(List formats, String date) {
            for (SimpleDateFormat format : formats) {
                Date d = null;
                try {
                    d = format.parse(date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (d == null) continue;
                return d;
            }
            return null;
        }

        protected void encodePlacemarkGeometry(Geometry geometry, Coordinate centroid, List<Symbolizer> symbolizers) {
            if (geometry instanceof Point || geometry instanceof MultiPoint && ((MultiPoint)geometry).getNumPoints() == 1) {
                this.encodeGeometry(geometry, symbolizers);
            } else {
                this.start("MultiGeometry");
                if (!Double.isNaN(geometry.getCoordinate().z)) {
                    centroid.z = geometry.getCoordinate().z;
                }
                if (centroid != null) {
                    this.encodeGeometry((Geometry)new GeometryFactory().createPoint(centroid), null);
                }
                this.encodeGeometry(geometry, symbolizers);
                this.end("MultiGeometry");
            }
        }

        protected void encodeGeometry(Geometry geometry, List<Symbolizer> symbolizers) {
            if (geometry instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)geometry;
                int i = 0;
                while (i < collection.getNumGeometries()) {
                    this.encodeGeometry(collection.getGeometryN(i), symbolizers);
                    ++i;
                }
            } else if (geometry instanceof Point) {
                Coordinate centroid = ((Point)geometry).getCoordinate();
                this.start("Point");
                if (!Double.isNaN(centroid.z)) {
                    this.geometryTranslator.insertExtrudeTags(geometry);
                    this.element("coordinates", String.valueOf(centroid.x) + "," + centroid.y + "," + centroid.z);
                } else {
                    this.element("coordinates", String.valueOf(centroid.x) + "," + centroid.y);
                }
                this.end("Point");
            } else {
                this.geometryTranslator.encode(geometry);
            }
        }

        String featureId(SimpleFeature feature) {
            String id = feature.getID();
            id = id.replaceAll("&", "");
            id = id.replaceAll(">", "");
            id = id.replaceAll("<", "");
            id = id.replaceAll("%", "");
            return id;
        }

        Geometry featureGeometry(SimpleFeature f) {
            Geometry geom = (Geometry)f.getDefaultGeometry();
            try {
                final double height = new FeatureHeightTemplate(KMLMapTransformer.this.template).execute(f);
                if (!Double.isNaN(height) && height != 0.0) {
                    geom.apply(new CoordinateFilter(){

                        public void filter(Coordinate c) {
                            c.setCoordinate(new Coordinate(c.x, c.y, height));
                        }
                    });
                    geom.geometryChanged();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Couldn't render height template for " + f.getID(), ioe);
            }
            return geom;
        }
    }
}

